/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.dataio;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.landcover.dataio.AbstractLandCoverModelDescriptor;
import org.esa.snap.landcover.dataio.FileLandCoverModel;
import org.esa.snap.landcover.dataio.FileLandCoverUTMModel;
import org.esa.snap.landcover.dataio.LandCoverModel;

public class ConfigFileLandCoverModelDescriptor
extends AbstractLandCoverModelDescriptor {
    private final File[] fileList;
    private final boolean isUTM;
    private final boolean isFloat;
    private static final String LANDCOVER = "landcover";

    public ConfigFileLandCoverModelDescriptor(PropertyMap configProp, String key) {
        String descriptorName = configProp.getPropertyString(key);
        String prefix = "landcover." + descriptorName;
        this.name = configProp.getPropertyString(prefix + ".name");
        this.remotePath = configProp.getPropertyString(prefix + ".remotePath");
        this.NO_DATA_VALUE = configProp.getPropertyInt(prefix + ".nodatavalue");
        this.isUTM = configProp.getPropertyBool(prefix + ".utmIndexed");
        this.isFloat = configProp.getPropertyBool(prefix + ".floatData");
        int numFiles = configProp.getPropertyInt(prefix + ".file.num");
        ArrayList<File> fileArray = new ArrayList<File>(numFiles);
        for (int i = 1; i <= numFiles; ++i) {
            String filePath = configProp.getPropertyString(prefix + ".file." + i);
            if (filePath == null || filePath.isEmpty()) continue;
            fileArray.add(new File(filePath));
        }
        this.fileList = fileArray.toArray(new File[fileArray.size()]);
        String colourIndex = configProp.getPropertyString(prefix + ".colourIndex");
        if (colourIndex == null || !colourIndex.isEmpty()) {
            // empty if block
        }
    }

    @Override
    public LandCoverModel createLandCoverModel(Resampling resampling) throws IOException {
        return this.isUTM ? new FileLandCoverUTMModel(this, this.fileList, resampling) : new FileLandCoverModel(this, this.fileList, resampling);
    }

    @Override
    public String createTileFilename(int minLat, int minLon) {
        return this.fileList[0].getName();
    }

    @Override
    public int getDataType() {
        return this.isFloat ? 30 : super.getDataType();
    }
}

