/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.kmz;

import java.awt.image.RenderedImage;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.kmz.KmlOverlay;
import org.opengis.geometry.BoundingBox;

public class KmlGroundOverlay
extends KmlOverlay {
    private final BoundingBox latLonBox;
    private final ProductData.UTC startTime;
    private final ProductData.UTC endTime;

    public KmlGroundOverlay(String name, RenderedImage overlay, BoundingBox latLonBox) {
        this(name, overlay, latLonBox, null, null);
    }

    public KmlGroundOverlay(String name, RenderedImage overlay, BoundingBox latLonBox, ProductData.UTC startTime, ProductData.UTC endTime) {
        super("GroundOverlay", name, overlay);
        this.latLonBox = latLonBox;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public ProductData.UTC getStartTime() {
        return this.startTime;
    }

    public ProductData.UTC getEndTime() {
        return this.endTime;
    }

    public BoundingBox getLatLonBox() {
        return this.latLonBox;
    }

    @Override
    protected void createKmlSpecifics(StringBuilder sb) {
        super.createKmlSpecifics(sb);
        ProductData.UTC startTime = this.getStartTime();
        ProductData.UTC endTime = this.getEndTime();
        if (startTime != null && endTime != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
            sdf.setCalendar(startTime.getAsCalendar());
            String startTimeString = sdf.format(startTime.getAsDate());
            sdf.setCalendar(endTime.getAsCalendar());
            String endTimeString = sdf.format(endTime.getAsDate());
            sb.append("<TimeSpan>");
            sb.append("<begin>").append(startTimeString).append("</begin>");
            sb.append("<end>").append(endTimeString).append("</end>");
            sb.append("</TimeSpan>");
        }
        BoundingBox bbox = this.getLatLonBox();
        sb.append("<LatLonBox>");
        sb.append("<north>").append(bbox.getMaxY()).append("</north>");
        sb.append("<south>").append(bbox.getMinY()).append("</south>");
        sb.append("<east>").append(bbox.getMaxX()).append("</east>");
        sb.append("<west>").append(bbox.getMinX()).append("</west>");
        sb.append("</LatLonBox>");
    }
}

