/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.io;

import javax.swing.ProgressMonitor;
import org.esa.snap.core.util.io.InputStreamObserver;

public class ProgressMonitorInputStreamObserver
implements InputStreamObserver {
    private ProgressMonitor progressMonitor;

    public ProgressMonitorInputStreamObserver(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    @Override
    public void onReadStarted(long numBytesTotal) {
        this.progressMonitor.setMinimum(0);
        this.progressMonitor.setMaximum((int)numBytesTotal);
    }

    @Override
    public void onReadProgress(long numBytesRead) {
        this.progressMonitor.setProgress((int)numBytesRead);
    }

    @Override
    public void onReadEnded() {
        this.progressMonitor.close();
    }

    @Override
    public boolean isReadingCanceled() {
        return this.progressMonitor.isCanceled();
    }
}

