/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import java.awt.Rectangle;
import org.esa.snap.core.util.StringUtils;

public class RectangleConverter
implements Converter<Rectangle> {
    private static final String EXCEPTION_FORMAT_PATTERN = "Invalid Rectangle '%s' should be in form of x,y,width,height";

    public Class<Rectangle> getValueType() {
        return Rectangle.class;
    }

    public Rectangle parse(String text) throws ConversionException {
        if (text != null) {
            text = text.trim();
        }
        if (text == null || text.isEmpty() || !text.contains(",")) {
            throw new ConversionException(String.format(EXCEPTION_FORMAT_PATTERN, text));
        }
        String[] s = StringUtils.csvToArray(text);
        if (s.length != 4) {
            throw new ConversionException(String.format(EXCEPTION_FORMAT_PATTERN, text));
        }
        return new Rectangle(Integer.parseInt(s[0].trim()), Integer.parseInt(s[1].trim()), Integer.parseInt(s[2].trim()), Integer.parseInt(s[3].trim()));
    }

    public String format(Rectangle r) {
        if (r == null) {
            return "0,0,0,0";
        }
        return "" + r.x + ',' + r.y + ',' + r.width + ',' + r.height;
    }
}

