/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import com.bc.ceres.core.runtime.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.esa.snap.core.util.SystemUtils;

public class VersionChecker {
    private String remoteVersionUrlString;
    private File localVersionFile;
    private static final String VERSION_PREFIX = "VERSION ";
    private String localVersionStr = null;
    private String remoteVersionStr = null;

    public VersionChecker() {
        this(new File(SystemUtils.getApplicationHomeDir(), "VERSION.txt"), SystemUtils.getApplicationRemoteVersionUrl());
    }

    public VersionChecker(File localVersionFile, String remoteVersionUrlString) {
        this.localVersionFile = localVersionFile;
        this.remoteVersionUrlString = remoteVersionUrlString;
    }

    public String getRemoteVersionUrlString() {
        return this.remoteVersionUrlString;
    }

    public void setRemoteVersionUrlString(String remoteVersionUrlString) {
        this.remoteVersionUrlString = remoteVersionUrlString;
    }

    public File getLocalVersionFile() {
        return this.localVersionFile;
    }

    public void setLocalVersionFile(File localVersionFile) {
        this.localVersionFile = localVersionFile;
    }

    public void setLocalVersion(String ver) {
        this.localVersionStr = ver;
    }

    public int compareVersions() throws IOException {
        String remoteVersion = this.getRemoteVersion();
        if (this.localVersionStr == null) {
            this.localVersionStr = this.getLocalVersion();
        }
        return VersionChecker.compareVersions(this.localVersionStr, remoteVersion);
    }

    static int compareVersions(String localVersion, String remoteVersion) {
        if (localVersion.startsWith(VERSION_PREFIX) && remoteVersion.startsWith(VERSION_PREFIX)) {
            Version v1 = Version.parseVersion((String)localVersion.substring(VERSION_PREFIX.length()));
            Version v2 = Version.parseVersion((String)remoteVersion.substring(VERSION_PREFIX.length()));
            return v1.compareTo((Object)v2);
        }
        return localVersion.compareTo(remoteVersion);
    }

    public String getLocalVersion() throws IOException {
        try {
            if (this.localVersionStr == null) {
                return VersionChecker.getVersion(this.getLocalVersionFile().toURI().toURL());
            }
            return this.localVersionStr;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public String getRemoteVersion() throws IOException {
        try {
            if (this.remoteVersionStr == null) {
                this.remoteVersionStr = VersionChecker.getVersion(new URL(this.getRemoteVersionUrlString()));
            }
            return this.remoteVersionStr;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private static String getVersion(URL url) throws IOException {
        String versionString = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            String line = reader.readLine();
            if (line != null) {
                versionString = line.toUpperCase();
            }
        }
        if (versionString == null || !versionString.startsWith(VERSION_PREFIX)) {
            throw new IOException("unexpected version file format");
        }
        return versionString;
    }
}

