/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.esa.snap.core.datamodel.ProductData;

public class TimeStampExtractor {
    private static final String LEGAL_DATE_TIME_CHAR_MATCHER = "[yMdDhms:_\\.-]+";
    private static final String LEGAL_FILENAME_CHAR_MATCHER = "[\\?\\*\\w\\. -]*";
    private static final String START_DATE_PLACEHOLDER = "${startDate}";
    private static final String END_DATE_PLACEHOLDER = "${endDate}";
    private static final String START_DATE_MATCHER = "(\\$\\{startDate\\})";
    private static final String END_DATE_MATCHER = "(\\$\\{endDate\\})";
    private final String datePattern;
    private final String filenamePattern;
    private Map<DateType, Integer> startDateGroupIndices;
    private Map<DateType, Integer> stopDateGroupIndices;
    private TimeStampAccess timeStampAccess;

    public TimeStampExtractor(String dateInterpretationPattern, String filenameInterpretationPattern) {
        this.datePattern = dateInterpretationPattern;
        this.filenamePattern = filenameInterpretationPattern;
        this.init();
    }

    public ProductData.UTC[] extractTimeStamps(String fileName) throws ValidationException {
        ProductData.UTC startTime = this.timeStampAccess.getStartTime(fileName);
        ProductData.UTC stopTime = this.timeStampAccess.getStopTime(fileName);
        return new ProductData.UTC[]{startTime, stopTime};
    }

    private void init() {
        this.createGroupIndices();
        boolean filenameHasStartTime = this.filenamePattern.contains(START_DATE_PLACEHOLDER);
        boolean filenameHasStopTime = this.filenamePattern.contains(END_DATE_PLACEHOLDER);
        if (filenameHasStopTime && filenameHasStartTime) {
            this.timeStampAccess = new RangeTimeAccess();
        } else if (filenameHasStartTime || filenameHasStopTime) {
            this.timeStampAccess = new SingleTimeAccess();
        } else {
            throw new IllegalStateException(MessageFormat.format("Filename interpretation pattern ''{0} needs to contain at least one of ''{1}'' and ''{2}''.", this.filenamePattern, START_DATE_PLACEHOLDER, END_DATE_PLACEHOLDER));
        }
        this.timeStampAccess.init();
    }

    private void createGroupIndices() {
        this.startDateGroupIndices = new HashMap<DateType, Integer>(6);
        this.stopDateGroupIndices = new HashMap<DateType, Integer>(6);
        int yearIndex = this.datePattern.indexOf("yyyy");
        int monthIndex = this.datePattern.indexOf("MM");
        int dayIndex = this.datePattern.indexOf("dd");
        int doyIndex = this.datePattern.indexOf("DDD");
        int hourIndex = this.datePattern.indexOf("hh");
        int minuteIndex = this.datePattern.indexOf("mm");
        int secondIndex = this.datePattern.indexOf("ss");
        ArrayList<Integer> indices = new ArrayList<Integer>(7);
        indices.add(yearIndex);
        if (monthIndex != -1) {
            indices.add(monthIndex);
        }
        if (dayIndex != -1) {
            indices.add(dayIndex);
        }
        if (doyIndex != -1) {
            indices.add(doyIndex);
        }
        if (hourIndex != -1) {
            indices.add(0, hourIndex);
        }
        if (minuteIndex != -1) {
            indices.add(minuteIndex);
        }
        if (secondIndex != -1) {
            indices.add(secondIndex);
        }
        Collections.sort(indices);
        this.createGroupIndices(0, yearIndex, monthIndex, dayIndex, doyIndex, hourIndex, minuteIndex, secondIndex, indices, this.startDateGroupIndices);
        this.createGroupIndices(this.startDateGroupIndices.size(), yearIndex, monthIndex, dayIndex, doyIndex, hourIndex, minuteIndex, secondIndex, indices, this.stopDateGroupIndices);
    }

    private void createGroupIndices(int offset, int yearIndex, int monthIndex, int dayIndex, int doyIndex, int hourIndex, int minuteIndex, int secondIndex, List<Integer> indices, Map<DateType, Integer> groupIndices) {
        int position = offset + 1;
        for (Integer index : indices) {
            if (index == yearIndex) {
                groupIndices.put(DateType.YEAR, position);
                ++position;
                continue;
            }
            if (index == monthIndex) {
                groupIndices.put(DateType.MONTH, position);
                ++position;
                continue;
            }
            if (index == dayIndex) {
                groupIndices.put(DateType.DAY, position);
                ++position;
                continue;
            }
            if (index == doyIndex) {
                groupIndices.put(DateType.DAY_OF_YEAR, position);
                ++position;
                continue;
            }
            if (index == hourIndex) {
                groupIndices.put(DateType.HOUR, position);
                ++position;
                continue;
            }
            if (index == minuteIndex) {
                groupIndices.put(DateType.MINUTE, position);
                ++position;
                continue;
            }
            if (index != secondIndex) continue;
            groupIndices.put(DateType.SECOND, position);
            ++position;
        }
    }

    private ProductData.UTC createTime(Matcher matcher, Map<DateType, Integer> groupIndices) {
        ProductData.UTC startTime;
        String startYearGroup = this.getString(matcher, DateType.YEAR, groupIndices);
        String startMonthGroup = this.getString(matcher, DateType.MONTH, groupIndices);
        String startDayGroup = this.getString(matcher, DateType.DAY, groupIndices);
        String startDoyGroup = this.getString(matcher, DateType.DAY_OF_YEAR, groupIndices);
        String startHourGroup = this.getString(matcher, DateType.HOUR, groupIndices);
        String startMinuteGroup = this.getString(matcher, DateType.MINUTE, groupIndices);
        String startSecondGroup = this.getString(matcher, DateType.SECOND, groupIndices);
        String pattern = this.createPattern(startYearGroup, startMonthGroup, startDayGroup, startDoyGroup, startHourGroup, startMinuteGroup, startSecondGroup);
        try {
            startTime = ProductData.UTC.parse(startYearGroup + startMonthGroup + startDayGroup + startDoyGroup + startHourGroup + startMinuteGroup + startSecondGroup, pattern);
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
        return startTime;
    }

    private String getString(Matcher matcher, DateType dateType, Map<DateType, Integer> groupIndices) {
        if (!groupIndices.containsKey((Object)dateType)) {
            return "";
        }
        return matcher.group(groupIndices.get((Object)dateType));
    }

    private String createPattern(String yearGroup, String monthGroup, String dayGroup, String doyGroup, String hourGroup, String minuteGroup, String secondGroup) {
        StringBuilder pattern = new StringBuilder();
        if (!"".equals(yearGroup)) {
            pattern.append("yyyy");
        }
        if (!"".equals(monthGroup)) {
            pattern.append("MM");
        }
        if (!"".equals(dayGroup)) {
            pattern.append("dd");
        }
        if (!"".equals(doyGroup)) {
            pattern.append("DDD");
        }
        if (!"".equals(hourGroup)) {
            pattern.append("hh");
        }
        if (!"".equals(minuteGroup)) {
            pattern.append("mm");
        }
        if (!"".equals(secondGroup)) {
            pattern.append("ss");
        }
        return pattern.toString();
    }

    private String replaceSpecialSigns(String string) {
        String validSign = "[\\\\w\\\\. -]";
        String exactlyOneTimesModifier = "{1}";
        String anyTimesModifier = "\\*";
        String starSignPattern = "[\\\\w\\\\. -]\\*";
        String questionSignPattern = "[\\\\w\\\\. -]{1}";
        String result = string.replaceAll("\\*", "[\\\\w\\\\. -]\\*");
        result = result.replaceAll("\\?", "[\\\\w\\\\. -]{1}");
        return result;
    }

    private String getDateMatcher() {
        String yearPattern = "yyyy";
        String monthPattern = "MM";
        String dayPattern = "dd";
        String doyPattern = "DDD";
        String hourPattern = "hh";
        String minutePattern = "mm";
        String secondPattern = "ss";
        String yearMatcher = "(\\\\d{" + "yyyy".length() + "})";
        String monthMatcher = "(\\\\d{" + "MM".length() + "})";
        String dayMatcher = "(\\\\d{" + "dd".length() + "})";
        String doyMatcher = "(\\\\d{" + "DDD".length() + "})";
        String hourMatcher = "(\\\\d{" + "hh".length() + "})";
        String minuteMatcher = "(\\\\d{" + "mm".length() + "})";
        String secondMatcher = "(\\\\d{" + "ss".length() + "})";
        String dateMatcher = this.datePattern.replaceAll("yyyy", yearMatcher);
        dateMatcher = dateMatcher.replaceAll("MM", monthMatcher);
        dateMatcher = dateMatcher.replaceAll("dd", dayMatcher);
        dateMatcher = dateMatcher.replaceAll("DDD", doyMatcher);
        dateMatcher = dateMatcher.replaceAll("hh", hourMatcher);
        dateMatcher = dateMatcher.replaceAll("mm", minuteMatcher);
        dateMatcher = dateMatcher.replaceAll("ss", secondMatcher);
        return dateMatcher;
    }

    private void validateFileName(Matcher matcher, String fileName) throws ValidationException {
        if (!matcher.matches()) {
            throw new ValidationException("Given filename '" + fileName + "' does not match the given date pattern.");
        }
    }

    private static CountOf countOf(String countString) {
        return new CountOf(countString);
    }

    private class RangeTimeAccess
    implements TimeStampAccess {
        private Pattern startStopDatesPattern;

        private RangeTimeAccess() {
        }

        @Override
        public void init() {
            int startDatePos = TimeStampExtractor.this.filenamePattern.indexOf(TimeStampExtractor.START_DATE_PLACEHOLDER);
            int endDatePos = TimeStampExtractor.this.filenamePattern.lastIndexOf(TimeStampExtractor.END_DATE_PLACEHOLDER);
            String prefix = TimeStampExtractor.this.filenamePattern.substring(0, startDatePos);
            String inBetween = TimeStampExtractor.this.filenamePattern.substring(startDatePos + TimeStampExtractor.START_DATE_PLACEHOLDER.length(), endDatePos);
            String suffix = TimeStampExtractor.this.filenamePattern.substring(endDatePos + TimeStampExtractor.END_DATE_PLACEHOLDER.length());
            prefix = TimeStampExtractor.this.replaceSpecialSigns(prefix);
            inBetween = TimeStampExtractor.this.replaceSpecialSigns(inBetween);
            suffix = TimeStampExtractor.this.replaceSpecialSigns(suffix);
            String matcherExpression = prefix + TimeStampExtractor.this.getDateMatcher() + inBetween + TimeStampExtractor.this.getDateMatcher() + suffix;
            this.startStopDatesPattern = Pattern.compile(matcherExpression);
        }

        @Override
        public ProductData.UTC getStartTime(String fileName) throws ValidationException {
            Matcher matcher = this.startStopDatesPattern.matcher(fileName);
            TimeStampExtractor.this.validateFileName(matcher, fileName);
            return TimeStampExtractor.this.createTime(matcher, TimeStampExtractor.this.startDateGroupIndices);
        }

        @Override
        public ProductData.UTC getStopTime(String fileName) throws ValidationException {
            Matcher matcher = this.startStopDatesPattern.matcher(fileName);
            TimeStampExtractor.this.validateFileName(matcher, fileName);
            return TimeStampExtractor.this.createTime(matcher, TimeStampExtractor.this.stopDateGroupIndices);
        }
    }

    private class SingleTimeAccess
    implements TimeStampAccess {
        private Pattern startDatePattern;

        private SingleTimeAccess() {
        }

        @Override
        public void init() {
            boolean isStartDate;
            int datePos = TimeStampExtractor.this.filenamePattern.indexOf(TimeStampExtractor.START_DATE_PLACEHOLDER);
            if (datePos != -1) {
                isStartDate = true;
            } else {
                isStartDate = false;
                datePos = TimeStampExtractor.this.filenamePattern.indexOf(TimeStampExtractor.END_DATE_PLACEHOLDER);
            }
            String prefix = TimeStampExtractor.this.filenamePattern.substring(0, datePos);
            prefix = TimeStampExtractor.this.replaceSpecialSigns(prefix);
            int placeholderLength = isStartDate ? TimeStampExtractor.START_DATE_PLACEHOLDER.length() : TimeStampExtractor.END_DATE_PLACEHOLDER.length();
            String suffix = TimeStampExtractor.this.filenamePattern.substring(datePos + placeholderLength);
            suffix = TimeStampExtractor.this.replaceSpecialSigns(suffix);
            String matcherExpression = prefix + TimeStampExtractor.this.getDateMatcher() + suffix;
            this.startDatePattern = Pattern.compile(matcherExpression);
        }

        @Override
        public ProductData.UTC getStartTime(String fileName) throws ValidationException {
            Matcher matcher = this.startDatePattern.matcher(fileName);
            TimeStampExtractor.this.validateFileName(matcher, fileName);
            return TimeStampExtractor.this.createTime(matcher, TimeStampExtractor.this.startDateGroupIndices);
        }

        @Override
        public ProductData.UTC getStopTime(String fileName) throws ValidationException {
            return this.getStartTime(fileName);
        }
    }

    private static interface TimeStampAccess {
        public void init();

        public ProductData.UTC getStartTime(String var1) throws ValidationException;

        public ProductData.UTC getStopTime(String var1) throws ValidationException;
    }

    static enum DateType {
        YEAR,
        MONTH,
        DAY,
        DAY_OF_YEAR,
        HOUR,
        MINUTE,
        SECOND;

    }

    private static class CountOf {
        private final String countString;

        private CountOf(String countString) {
            this.countString = countString;
        }

        private int in(String string) {
            int count = 0;
            int fromIndex = 0;
            while (string.indexOf(this.countString, fromIndex) != -1) {
                fromIndex = string.indexOf(this.countString, fromIndex) + 1;
                ++count;
            }
            return count;
        }
    }

    public static class FilenameInterpretationPatternValidator
    implements Validator {
        public void validateValue(Property property, Object value) throws ValidationException {
            boolean hasEndDate;
            String pattern = ((String)value).trim();
            if (!pattern.contains(TimeStampExtractor.START_DATE_PLACEHOLDER) && !pattern.contains(TimeStampExtractor.END_DATE_PLACEHOLDER)) {
                throw new ValidationException(MessageFormat.format("Filename interpretation pattern ''{0} needs to contain at least one of ''{1}'' and ''{2}''.", pattern, TimeStampExtractor.START_DATE_PLACEHOLDER, TimeStampExtractor.END_DATE_PLACEHOLDER));
            }
            int startDateCount = this.getDateCount(pattern, TimeStampExtractor.START_DATE_PLACEHOLDER);
            int endDateCount = this.getDateCount(pattern, TimeStampExtractor.END_DATE_PLACEHOLDER);
            boolean hasStartDate = startDateCount == 1;
            boolean bl = hasEndDate = endDateCount == 1;
            if (hasStartDate && hasEndDate ? !pattern.matches("[\\?\\*\\w\\. -]*(\\$\\{startDate\\})[\\?\\*\\w\\. -]*(\\$\\{endDate\\})[\\?\\*\\w\\. -]*") : (hasStartDate && !hasEndDate ? !pattern.matches("[\\?\\*\\w\\. -]*(\\$\\{startDate\\})[\\?\\*\\w\\. -]*") : hasEndDate && !pattern.matches("[\\?\\*\\w\\. -]*(\\$\\{endDate\\})[\\?\\*\\w\\. -]*"))) {
                throw new ValidationException("Value of filenameInterpretationPattern contains illegal characters.\nlegal characters are a-zA-Z0-9_-*.?${}");
            }
        }

        private int getDateCount(String pattern, String placeholder) throws ValidationException {
            int dateCount = TimeStampExtractor.countOf(placeholder).in(pattern);
            if (dateCount > 1) {
                throw new ValidationException("Value of filenameInterpretationPattern must contain the date placeholder '" + placeholder + "' at most once.");
            }
            return dateCount;
        }
    }

    public static class DateInterpretationPatternValidator
    implements Validator {
        public void validateValue(Property property, Object value) throws ValidationException {
            String pattern = ((String)value).trim();
            if (pattern.length() < 4) {
                throw new ValidationException("Value of dateInterpretationPattern must at least contain 4 Characters");
            }
            if (!pattern.matches(TimeStampExtractor.LEGAL_DATE_TIME_CHAR_MATCHER)) {
                throw new ValidationException("Value of dateInterpretationPattern contains illegal charachters.\nValid characters are: 'y' 'M' 'd' 'D' 'h' 'm' 's' ':' '_' '-' '.'");
            }
            if (!pattern.contains("yyyy")) {
                throw new ValidationException("Value of dateInterpretationPattern must contain 'yyyy' as year placeholder.");
            }
            if (TimeStampExtractor.countOf("yyyy").in(pattern) > 1 || TimeStampExtractor.countOf("MM").in(pattern) > 1 || TimeStampExtractor.countOf("dd").in(pattern) > 1 || TimeStampExtractor.countOf("DDD").in(pattern) > 1 || TimeStampExtractor.countOf("hh").in(pattern) > 1 || TimeStampExtractor.countOf("mm").in(pattern) > 1 || TimeStampExtractor.countOf("ss").in(pattern) > 1) {
                throw new ValidationException("Value of dateInterpretationPattern can contain each of character sequences ('yyyy', 'MM', 'dd', 'DDD', 'hh', 'mm', 'ss') only once.");
            }
        }
    }
}

