/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.transform;

import java.awt.geom.Point2D;
import org.esa.snap.core.transform.MathTransform2D;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public abstract class AbstractTransform2D
extends AbstractMathTransform
implements MathTransform2D {
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        Point2D.Double source = new Point2D.Double();
        Point2D.Double target = new Point2D.Double();
        boolean throwTransformException = false;
        String message = null;
        for (int i = 0; i < numPts; ++i) {
            int srcXIndex = srcOff + 2 * i;
            int srcYIndex = srcOff + 2 * i + 1;
            int dstXIndex = dstOff + 2 * i;
            int dstYIndex = dstOff + 2 * i + 1;
            source.setLocation(srcPts[srcXIndex], srcPts[srcYIndex]);
            try {
                this.transform(source, target);
                dstPts[dstXIndex] = target.getX();
                dstPts[dstYIndex] = target.getY();
                continue;
            }
            catch (TransformException te) {
                throwTransformException = true;
                message = te.getMessage();
                dstPts[dstXIndex] = Double.NaN;
                dstPts[dstYIndex] = Double.NaN;
            }
        }
        if (throwTransformException) {
            TransformException transformException = message != null ? new TransformException("Could not transform point: " + message) : new TransformException("Could not transform point");
            transformException.setLastCompletedTransform((MathTransform)this);
            throw transformException;
        }
    }

    public abstract Point2D transform(Point2D var1, Point2D var2) throws TransformException;

    @Override
    public int getSourceDimensions() {
        return 2;
    }

    @Override
    public int getTargetDimensions() {
        return 2;
    }

    @Override
    public abstract MathTransform2D inverse() throws NoninvertibleTransformException;

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public abstract int hashCode();
}

