/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.param.validators;

import org.esa.snap.core.param.AbstractParamValidator;
import org.esa.snap.core.param.ParamFormatException;
import org.esa.snap.core.param.ParamParseException;
import org.esa.snap.core.param.ParamValidateException;
import org.esa.snap.core.param.Parameter;
import org.esa.snap.core.util.Debug;

public class BooleanValidator
extends AbstractParamValidator {
    public static final String TRUE_STRING = "true";
    public static final String FALSE_STRING = "false";

    @Override
    public Object parse(Parameter parameter, String text) throws ParamParseException {
        Debug.assertTrue(text != null);
        String trimedText = text.trim();
        if (BooleanValidator.isAllowedNullText(parameter, trimedText)) {
            return null;
        }
        if (trimedText.equalsIgnoreCase(TRUE_STRING)) {
            return Boolean.TRUE;
        }
        if (trimedText.equalsIgnoreCase(FALSE_STRING)) {
            return Boolean.FALSE;
        }
        throw new ParamParseException(parameter, "Value must be one of true or false.");
    }

    @Override
    public String format(Parameter parameter, Object value) throws ParamFormatException {
        if (BooleanValidator.isAllowedNullValue(parameter, value)) {
            return "";
        }
        Boolean bValue = BooleanValidator.castToBoolean(value);
        if (bValue == null) {
            throw new ParamFormatException(parameter, "Not a boolean value!");
        }
        return bValue != false ? TRUE_STRING : FALSE_STRING;
    }

    @Override
    public void validate(Parameter parameter, Object value) throws ParamValidateException {
        this.validateThatNullValueIsAllowed(parameter, value);
        Boolean b = BooleanValidator.castToBoolean(value);
        if (b == null) {
            throw new ParamValidateException(parameter, "Value must be of type boolean (true or false).");
        }
    }

    protected static Boolean castToBoolean(Object value) {
        return value instanceof Boolean ? (Boolean)value : null;
    }
}

