/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.param.editors;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.esa.snap.core.param.AbstractParamEditor;
import org.esa.snap.core.param.Parameter;

public class BooleanEditor
extends AbstractParamEditor {
    private JCheckBox _checkBox;

    public BooleanEditor(Parameter parameter) {
        super(parameter, false);
    }

    public JCheckBox getCheckBox() {
        return this._checkBox;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.getCheckBox();
    }

    @Override
    protected void initUI() {
        this._checkBox = new JCheckBox();
        this.nameEditorComponent(this._checkBox);
        if (this.getParameter().getProperties().getLabel() != null) {
            this._checkBox.setText(this.getParameter().getProperties().getLabel());
        }
        if (this.getParameter().getProperties().getDescription() != null) {
            this._checkBox.setToolTipText(this.getParameter().getProperties().getDescription());
        }
        this._checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                BooleanEditor.this.updateParameter();
            }
        });
    }

    @Override
    public void updateUI() {
        super.updateUI();
        boolean newValue = this.getParameter().getValue() instanceof Boolean ? ((Boolean)this.getParameter().getValue()).booleanValue() : Boolean.valueOf(this.getParameter().getValueAsText()).booleanValue();
        if (this.getCheckBox().isSelected() != newValue) {
            this.getCheckBox().setSelected(newValue);
        }
        if (this.getCheckBox().isEnabled() != this.isEnabled()) {
            this.getCheckBox().setEnabled(this.isEnabled());
        }
    }

    private void updateParameter() {
        boolean newValue = this.getCheckBox().isSelected();
        this.getParameter().setValue(newValue, null);
    }
}

