/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.image;

import com.bc.ceres.glevel.MultiLevelImage;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Lineal;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.Puntal;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.image.SingleBandedOpImage;
import org.esa.snap.core.util.jai.JAIUtils;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;

public class VectorDataMaskOpImage
extends SingleBandedOpImage {
    private static final byte FALSE = 0;
    private static final byte TRUE = -1;
    private final VectorDataNode vectorDataNode;
    private final AffineTransform m2iTransform;

    public VectorDataMaskOpImage(VectorDataNode vectorDataNode, RasterDataNode rasterDataNode, ResolutionLevel level) {
        super(0, rasterDataNode.getRasterWidth(), rasterDataNode.getRasterHeight(), VectorDataMaskOpImage.getPreferredTileSize(rasterDataNode), null, level);
        this.vectorDataNode = vectorDataNode;
        AffineTransform transform = rasterDataNode.getImageToModelTransform();
        try {
            transform.invert();
            this.m2iTransform = transform;
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException("Could not invert model-to-image transformation.", e);
        }
    }

    public VectorDataNode getVectorDataNode() {
        return this.vectorDataNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeRect(PlanarImage[] sourceImages, WritableRaster tile, Rectangle destRect) {
        BufferedImage image = new BufferedImage(this.colorModel, RasterFactory.createWritableRaster((SampleModel)tile.getSampleModel(), (DataBuffer)tile.getDataBuffer(), (Point)new Point(0, 0)), false, null);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.translate(-((double)tile.getMinX() + 0.5), -((double)tile.getMinY() + 0.5));
        graphics2D.setColor(Color.WHITE);
        FeatureCollection<SimpleFeatureType, SimpleFeature> features = this.vectorDataNode.getFeatureCollection();
        try (FeatureIterator featureIterator = features.features();){
            AffineTransform transform = AffineTransform.getScaleInstance(1.0 / this.getScale(), 1.0 / this.getScale());
            transform.concatenate(this.m2iTransform);
            AffineTransform2D transform2D = new AffineTransform2D(transform);
            while (featureIterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)featureIterator.next();
                Object value = feature.getDefaultGeometry();
                if (!(value instanceof Geometry)) continue;
                try {
                    VectorDataMaskOpImage.renderGeometry((Geometry)value, graphics2D, (MathTransform2D)transform2D);
                }
                catch (Exception exception) {}
            }
        }
        graphics2D.dispose();
        byte[] data = ((DataBufferByte)tile.getDataBuffer()).getData();
        for (int i = 0; i < data.length; ++i) {
            data[i] = data[i] != 0 ? -1 : 0;
        }
    }

    private static void renderGeometry(Geometry geom, Graphics2D graphics, MathTransform2D transform) throws Exception {
        if (geom instanceof Puntal) {
            Coordinate c = geom.getCoordinate();
            Point2D.Double pt = new Point2D.Double(c.x, c.y);
            transform.transform((Point2D)pt, (Point2D)pt);
            graphics.drawLine((int)pt.x, (int)pt.y, (int)pt.x, (int)pt.y);
        } else if (geom instanceof Lineal) {
            LiteShape2 shape = new LiteShape2(geom, (MathTransform)transform, null, false, true);
            graphics.draw((Shape)shape);
        } else if (geom instanceof Polygonal) {
            LiteShape2 shape = new LiteShape2(geom, (MathTransform)transform, null, false, true);
            graphics.fill((Shape)shape);
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)geom;
            for (int i = 0; i < collection.getNumGeometries(); ++i) {
                VectorDataMaskOpImage.renderGeometry(collection.getGeometryN(i), graphics, transform);
            }
        }
    }

    private static Dimension getPreferredTileSize(RasterDataNode rasterDataNode) {
        if (rasterDataNode.isSourceImageSet()) {
            MultiLevelImage sourceImage = rasterDataNode.getSourceImage();
            return new Dimension(sourceImage.getTileWidth(), sourceImage.getTileHeight());
        }
        if (rasterDataNode.getProduct() != null) {
            return ImageManager.getPreferredTileSize(rasterDataNode.getProduct());
        }
        return JAIUtils.computePreferredTileSize(rasterDataNode.getRasterWidth(), rasterDataNode.getRasterHeight(), 1);
    }
}

