/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.downloadable;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.esa.snap.core.datamodel.ProgressListenerList;
import org.esa.snap.core.dataop.downloadable.XMLSupport;
import org.esa.snap.core.util.SystemUtils;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public final class FtpDownloader {
    private final FTPClient ftpClient = new FTPClient();
    private final String server;
    private final String user;
    private final String password;
    private boolean ftpClientConnected = false;
    private ProgressListenerList progressListenerList = new ProgressListenerList();
    private static final String elemPrefix = "file_";

    public FtpDownloader(String server) throws IOException {
        this(server, "anonymous", "anonymous");
    }

    public FtpDownloader(String server, String user, String password) throws IOException {
        this.server = server;
        this.user = user;
        this.password = password;
        this.connect();
    }

    private void connect() throws IOException {
        this.ftpClient.setRemoteVerificationEnabled(false);
        this.ftpClient.connect(this.server);
        int reply = this.ftpClient.getReplyCode();
        if (FTPReply.isPositiveCompletion((int)reply)) {
            this.ftpClientConnected = this.ftpClient.login(this.user, this.password);
        }
        if (!this.ftpClientConnected) {
            this.disconnect();
            throw new IOException("Unable to connect to " + this.server);
        }
        this.ftpClient.enterLocalPassiveMode();
        this.ftpClient.setFileType(2);
        this.ftpClient.setDataTimeout(60000);
    }

    public void disconnect() throws IOException {
        if (this.ftpClientConnected) {
            this.ftpClient.logout();
            this.ftpClient.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FTPError retrieveFile(String remotePath, File localFile, Long fileSize) throws Exception {
        FilterOutputStream fos = null;
        InputStream fis = null;
        try {
            int n;
            SystemUtils.LOG.info("ftp retrieving " + remotePath);
            fis = this.ftpClient.retrieveFileStream(remotePath);
            if (fis == null) {
                int code = this.ftpClient.getReplyCode();
                SystemUtils.LOG.severe("error code:" + code + " on " + remotePath);
                if (code == 550) {
                    FTPError fTPError = FTPError.FILE_NOT_FOUND;
                    return fTPError;
                }
                FTPError fTPError = FTPError.READ_ERROR;
                return fTPError;
            }
            File parentFolder = localFile.getParentFile();
            if (!parentFolder.exists()) {
                parentFolder.mkdirs();
            }
            fos = new BufferedOutputStream(new FileOutputStream(localFile.getAbsolutePath()));
            this.progressListenerList.fireProcessStarted("Downloading " + localFile.getName() + "... ", 0, fileSize.intValue());
            int size = 4096;
            byte[] buf = new byte[4096];
            int total = 0;
            while ((n = fis.read(buf, 0, 4096)) > -1) {
                ((BufferedOutputStream)fos).write(buf, 0, n);
                if (fileSize == null) continue;
                this.progressListenerList.fireProcessInProgress(total += n);
            }
            this.progressListenerList.fireProcessEnded(true);
            this.ftpClient.completePendingCommand();
            FTPError fTPError = FTPError.OK;
            return fTPError;
        }
        catch (SocketException e) {
            SystemUtils.LOG.severe(e.getMessage());
            this.connect();
            throw new SocketException(e.getMessage() + "\nPlease verify that FTP is not blocked by your firewall.");
        }
        catch (Exception e) {
            SystemUtils.LOG.severe(e.getMessage());
            this.connect();
            FTPError fTPError = FTPError.READ_ERROR;
            return fTPError;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static long getFileSize(FTPFile[] fileList, String remoteFileName) {
        for (FTPFile file : fileList) {
            if (!file.getName().equalsIgnoreCase(remoteFileName)) continue;
            return file.getSize();
        }
        return 0L;
    }

    public Map<String, Long> readRemoteFileListNoCache(String remotePath) {
        HashMap<String, Long> fileSizeMap = new HashMap<String, Long>(100);
        try {
            FTPFile[] remoteFileList = this.getRemoteFileList(remotePath);
            if (remoteFileList != null) {
                for (FTPFile ftpFile : remoteFileList) {
                    fileSizeMap.put(ftpFile.getName(), ftpFile.getSize());
                }
            }
        }
        catch (Exception e) {
            SystemUtils.LOG.warning("Unable to get remote file list " + e.getMessage());
        }
        return fileSizeMap;
    }

    private FTPFile[] getRemoteFileList(String path) throws IOException {
        return this.ftpClient.listFiles(path);
    }

    public static Map<String, Long> readRemoteFileList(FtpDownloader ftp, String server, String remotePath) {
        boolean useCachedListing = true;
        File listingFile = new File(SystemUtils.getCacheDir(), server + ".listing.xml");
        if (!listingFile.exists()) {
            useCachedListing = false;
        }
        HashMap<String, Long> fileSizeMap = new HashMap<String, Long>(900);
        if (useCachedListing) {
            Document doc = null;
            try {
                doc = XMLSupport.LoadXML(listingFile.getAbsolutePath());
            }
            catch (IOException e) {
                useCachedListing = false;
            }
            if (useCachedListing) {
                Element root = doc.getRootElement();
                boolean listingFound = false;
                List children1 = root.getContent();
                for (Object c1 : children1) {
                    Element remotePathElem;
                    Attribute pathAttrib;
                    if (!(c1 instanceof Element) || (pathAttrib = (remotePathElem = (Element)c1).getAttribute("path")) == null || !pathAttrib.getValue().equalsIgnoreCase(remotePath)) continue;
                    listingFound = true;
                    List children2 = remotePathElem.getContent();
                    for (Object c2 : children2) {
                        Element fileElem;
                        Attribute attrib;
                        if (!(c2 instanceof Element) || (attrib = (fileElem = (Element)c2).getAttribute("size")) == null) continue;
                        try {
                            fileSizeMap.put(FtpDownloader.getFileName(fileElem.getName()), attrib.getLongValue());
                        }
                        catch (Exception exception) {}
                    }
                }
                if (!listingFound) {
                    useCachedListing = false;
                }
            }
        }
        if (!useCachedListing) {
            try {
                FTPFile[] remoteFileList = ftp.getRemoteFileList(remotePath);
                if (remoteFileList != null) {
                    FtpDownloader.writeRemoteFileList(remoteFileList, server, remotePath, listingFile);
                    for (FTPFile ftpFile : remoteFileList) {
                        fileSizeMap.put(ftpFile.getName(), ftpFile.getSize());
                    }
                }
            }
            catch (Exception e) {
                SystemUtils.LOG.warning("Unable to get remote file list " + e.getMessage());
            }
        }
        return fileSizeMap;
    }

    private static String getFileName(String elemName) {
        if (elemName.startsWith(elemPrefix)) {
            return elemName.substring(elemPrefix.length(), elemName.length());
        }
        return elemName;
    }

    private static void writeRemoteFileList(FTPFile[] remoteFileList, String server, String remotePath, File file) {
        Element root = new Element("remoteFileListing");
        root.setAttribute("server", server);
        Document doc = new Document(root);
        Element remotePathElem = new Element("remotePath");
        remotePathElem.setAttribute("path", remotePath);
        root.addContent((Content)remotePathElem);
        for (FTPFile ftpFile : remoteFileList) {
            Element fileElem = new Element(elemPrefix + ftpFile.getName());
            fileElem.setAttribute("size", String.valueOf(ftpFile.getSize()));
            remotePathElem.addContent((Content)fileElem);
        }
        XMLSupport.SaveXML(doc, file.getAbsolutePath());
    }

    public static boolean testFTP(String remoteFTP, String remotePath) throws IOException {
        FtpDownloader ftp = new FtpDownloader(remoteFTP);
        FTPFile[] remoteFileList = ftp.getRemoteFileList(remotePath);
        ftp.disconnect();
        return remoteFileList != null;
    }

    public static enum FTPError {
        FILE_NOT_FOUND,
        OK,
        READ_ERROR;

    }
}

