/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.barithm;

import com.bc.ceres.core.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.dataop.barithm.RasterDataSymbol;
import org.esa.snap.core.dataop.barithm.UncertaintyGenerator;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.jexp.Symbol;
import org.esa.snap.core.jexp.Term;
import org.esa.snap.core.jexp.WritableNamespace;
import org.esa.snap.core.jexp.impl.ParserImpl;
import org.esa.snap.core.jexp.impl.TermDecompiler;
import org.esa.snap.core.jexp.impl.TermFactory;

public class StandardUncertaintyGenerator
implements UncertaintyGenerator {
    private final boolean optimize;
    private final int maxOrder;

    public StandardUncertaintyGenerator() {
        this(1, false);
    }

    public StandardUncertaintyGenerator(int order, boolean optimize) {
        Assert.argument((order >= 1 && order <= 3 ? 1 : 0) != 0, (String)"order >= 1 && order <= 3");
        this.optimize = optimize;
        this.maxOrder = order;
    }

    @Override
    public String generateUncertainty(Product product, String relation, String expression) throws ParseException, UnsupportedOperationException {
        Term result;
        Term partialDerivative2;
        Term uncertainty2;
        Term partialDerivative1;
        Term uncertainty1;
        Term contrib;
        WritableNamespace namespace = product.createBandArithmeticDefaultNamespace();
        ParserImpl parser = new ParserImpl(namespace);
        Term term = parser.parse(expression);
        RasterDataSymbol[] symbols = BandArithmetic.getRefRasterDataSymbols(term);
        HashMap<RasterDataSymbol, Term> variables = new HashMap<RasterDataSymbol, Term>();
        for (RasterDataSymbol variable : symbols) {
            RasterDataNode[] uncertaintyRasters = variable.getRaster().getAncillaryVariables(relation);
            if (uncertaintyRasters.length <= 0) continue;
            List<Term> symbolRefs = Stream.of(uncertaintyRasters).map(r -> TermFactory.ref(namespace.resolveSymbol(r.getName()))).collect(Collectors.toList());
            variables.put(variable, symbolRefs.size() == 1 ? symbolRefs.get(0) : TermFactory.magnitude(symbolRefs));
        }
        ArrayList<Term> uncertaintySum = new ArrayList<Term>();
        for (Symbol variable : variables.keySet()) {
            Term uncertainty = (Term)variables.get(variable);
            Term partialDerivative = TermFactory.derivative(term, variable);
            Term contrib2 = TermFactory.mul(partialDerivative, uncertainty);
            uncertaintySum.add(contrib2);
        }
        if (this.maxOrder >= 2) {
            contrib = null;
            for (Symbol variable1 : variables.keySet()) {
                uncertainty1 = (Term)variables.get(variable1);
                partialDerivative1 = TermFactory.derivative(term, variable1);
                for (Symbol variable2 : variables.keySet()) {
                    uncertainty2 = (Term)variables.get(variable2);
                    partialDerivative2 = TermFactory.derivative(partialDerivative1, variable2);
                    Term singleContrib = TermFactory.mul(TermFactory.mul(partialDerivative2, uncertainty1), uncertainty2);
                    contrib = contrib != null ? TermFactory.add(contrib, singleContrib) : singleContrib;
                }
            }
            if (contrib != null) {
                uncertaintySum.add(TermFactory.div(contrib, TermFactory.c(2.0)));
            }
        }
        if (this.maxOrder == 3) {
            contrib = null;
            for (Symbol variable1 : variables.keySet()) {
                uncertainty1 = (Term)variables.get(variable1);
                partialDerivative1 = TermFactory.derivative(term, variable1);
                for (Symbol variable2 : variables.keySet()) {
                    uncertainty2 = (Term)variables.get(variable2);
                    partialDerivative2 = TermFactory.derivative(partialDerivative1, variable2);
                    for (Symbol variable3 : variables.keySet()) {
                        Term uncertainty3 = (Term)variables.get(variable3);
                        Term partialDerivative3 = TermFactory.derivative(partialDerivative2, variable3);
                        Term singleContrib = TermFactory.mul(TermFactory.mul(TermFactory.mul(partialDerivative3, uncertainty1), uncertainty2), uncertainty3);
                        contrib = contrib != null ? TermFactory.add(contrib, singleContrib) : singleContrib;
                    }
                }
            }
            if (contrib != null) {
                uncertaintySum.add(TermFactory.div(contrib, TermFactory.c(6.0)));
            }
        }
        if (uncertaintySum.isEmpty()) {
            result = term.isConst() && Double.isNaN(term.evalD(null)) ? Term.ConstD.NAN : Term.ConstD.ZERO;
        } else {
            result = TermFactory.magnitude(uncertaintySum);
            result = TermFactory.simplify(result);
            result = this.optimize ? TermFactory.optimize(result) : result;
        }
        return new TermDecompiler().decompile(result);
    }
}

