/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel.quicklooks;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.prefs.Preferences;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductVisitor;
import org.esa.snap.core.datamodel.quicklooks.QuicklookDB;
import org.esa.snap.core.datamodel.quicklooks.QuicklookGenerator;
import org.esa.snap.core.datamodel.quicklooks.Thumbnail;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.runtime.Config;

public class Quicklook
extends ProductNode
implements Thumbnail {
    public static final String DEFAULT_QUICKLOOK_NAME = "Quicklook";
    public static final String SNAP_QUICKLOOK_FILE_PREFIX = "snapQL_";
    private static final String QUICKLOOK_EXT = ".jpg";
    private BufferedImage image;
    private Product product;
    private File productFile;
    private final File browseFile;
    private Band[] quicklookBands;
    private final Path productQuicklookFolder;
    private final boolean productCanAppendFiles;
    private final boolean saveWithProduct;

    public Quicklook(File productFile) {
        this((Product)null, DEFAULT_QUICKLOOK_NAME);
        this.productFile = productFile;
    }

    public Quicklook(Product product, String name) {
        this(product, name, null, false, null, null);
    }

    public Quicklook(Product product, String name, File browseFile) {
        this(product, name, browseFile, false, null, null);
    }

    public Quicklook(Product product, String name, Band[] quicklookBands) {
        this(product, name, null, false, null, quicklookBands);
    }

    public Quicklook(Product product, String name, File browseFile, boolean productCanAppendFiles, Path productQuicklookFolder, Band[] quicklookBands) {
        super(name);
        this.browseFile = browseFile;
        this.productCanAppendFiles = productCanAppendFiles;
        this.productQuicklookFolder = productQuicklookFolder;
        this.quicklookBands = quicklookBands;
        this.setProduct(product);
        Preferences preferences = Config.instance().preferences();
        this.saveWithProduct = preferences.getBoolean("quicklooks.save.with.product", true);
    }

    public void setProduct(Product product) {
        if (product != null) {
            this.product = product;
            this.productFile = product.getFileLocation();
        }
    }

    public boolean hasProduct() {
        return this.product != null;
    }

    public File getProductFile() {
        return this.productFile;
    }

    @Override
    public long getRawStorageSize(ProductSubsetDef subsetDef) {
        return 0L;
    }

    @Override
    public void acceptVisitor(ProductVisitor visitor) {
        Guardian.assertNotNull("visitor", visitor);
        visitor.visit(this);
    }

    @Override
    public boolean hasCachedImage() {
        int id;
        File quickLookFile;
        if (this.productQuicklookFolder != null && (quickLookFile = this.productQuicklookFolder.resolve(this.getQLFileName(0)).toFile()).exists()) {
            return true;
        }
        if (this.productFile != null && (id = QuicklookDB.instance().getQuicklookId(this.productFile)) != -1) {
            File quickLookFile2 = QuicklookDB.getQuicklookCacheDir().resolve(this.getQLFileName(id)).toFile();
            return quickLookFile2.exists();
        }
        return false;
    }

    @Override
    public boolean hasImage() {
        return this.image != null;
    }

    @Override
    public synchronized BufferedImage getImage(ProgressMonitor pm) {
        if (this.image == null) {
            this.loadQuicklook();
            if (this.image == null) {
                QuicklookGenerator qlGen = new QuicklookGenerator();
                try {
                    if (this.browseFile != null) {
                        Product browseProduct = Quicklook.readBrowseProduct(this.browseFile);
                        this.image = qlGen.createQuickLookFromBrowseProduct(browseProduct);
                    } else if (this.product != null) {
                        if (this.quicklookBands == null) {
                            this.quicklookBands = QuicklookGenerator.findQuicklookBands(this.product);
                        }
                        this.image = qlGen.createQuickLookImage(this.product, this.quicklookBands, pm);
                    } else {
                        throw new IOException("Quicklook: product not set");
                    }
                    this.saveQuicklook(this.image);
                }
                catch (IOException e) {
                    SystemUtils.LOG.severe("Quicklook: Unable to generate quicklook: " + e.getMessage());
                }
            }
            this.notifyImageUpdated();
        }
        return this.image;
    }

    private static Product readBrowseProduct(File file) throws IOException {
        String filename = file.getName().toLowerCase();
        ProductReader productReader = null;
        if (filename.endsWith("tif")) {
            productReader = ProductIO.getProductReader("GeoTIFF");
        } else if (filename.endsWith("png") || filename.endsWith("jpg")) {
            productReader = ProductIO.getProductReader("PNG");
        }
        if (productReader != null) {
            return productReader.readProductNodes(file, null);
        }
        return ProductIO.readProduct(file);
    }

    private void loadQuicklook() {
        if (this.productQuicklookFolder != null) {
            File quickLookFile = this.productQuicklookFolder.resolve(this.getQLFileName(0)).toFile();
            this.image = QuicklookGenerator.loadImage(quickLookFile);
        }
        if (this.image == null) {
            File quickLookFile;
            int id;
            if (this.productFile == null && this.product != null) {
                this.productFile = this.product.getFileLocation();
            }
            if (this.productFile != null && (id = QuicklookDB.instance().getQuicklookId(this.productFile)) != -1 && (quickLookFile = QuicklookDB.getQuicklookCacheDir().resolve(this.getQLFileName(id)).toFile()).exists()) {
                this.image = QuicklookGenerator.loadImage(quickLookFile);
            }
        }
    }

    private void saveQuicklook(BufferedImage bufferedImage) {
        File quickLookFile;
        if (bufferedImage == null) {
            return;
        }
        if (this.saveWithProduct && this.productCanAppendFiles && this.productQuicklookFolder != null && QuicklookGenerator.writeImage(bufferedImage, quickLookFile = this.productQuicklookFolder.resolve(this.getQLFileName(0)).toFile())) {
            return;
        }
        if (this.productFile != null) {
            int id = QuicklookDB.instance().addQuickLookId(this.productFile);
            File quickLookFile2 = QuicklookDB.getQuicklookCacheDir().resolve(this.getQLFileName(id)).toFile();
            QuicklookGenerator.writeImage(bufferedImage, quickLookFile2);
        }
    }

    private String getQLFileName(int id) {
        return SNAP_QUICKLOOK_FILE_PREFIX + id + '_' + this.getName() + QUICKLOOK_EXT;
    }
}

