/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.core.Assert;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.GenericPlacemarkDescriptor;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.PlacemarkDescriptorRegistry;
import org.esa.snap.core.datamodel.PlacemarkGroup;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductVisitor;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.ObjectUtils;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.BoundingBox;

public class VectorDataNode
extends ProductNode {
    public static final String PROPERTY_NAME_FEATURE_COLLECTION = "featureCollection";
    public static final String PROPERTY_NAME_STYLE_CSS = "styleCss";
    public static final String PROPERTY_NAME_DEFAULT_STYLE_CSS = "defaultStyleCss";
    private static final String DEFAULT_STYLE_FORMAT = "fill:%s; fill-opacity:0.5; stroke:#ffffff; stroke-opacity:1.0; stroke-width:1.0; symbol:cross";
    private static final String[] FILL_COLORS = new String[]{"#ff0000", "#00ff00", "#0000ff", "#aaff00", "#00aaff", "#ffaa00", "#ff00aa", "#aa00ff", "#00ffaa"};
    static int fillColorIndex;
    private final SimpleFeatureType featureType;
    private final FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection;
    private final CollectionListener featureCollectionListener;
    private final PlacemarkDescriptor placemarkDescriptor;
    private PlacemarkGroup placemarkGroup;
    private String defaultStyleCss;
    private String styleCss;
    private ReferencedEnvelope bounds;
    private boolean permanent;

    public VectorDataNode(String name, SimpleFeatureType featureType) {
        this(name, (FeatureCollection<SimpleFeatureType, SimpleFeature>)new DefaultFeatureCollection(name, featureType), VectorDataNode.getPlacemarkDescriptor(featureType));
    }

    public VectorDataNode(String name, FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        this(name, featureCollection, VectorDataNode.getPlacemarkDescriptor((SimpleFeatureType)featureCollection.getSchema()));
    }

    public VectorDataNode(String name, FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection, PlacemarkDescriptor placemarkDescriptor) {
        super(name, "");
        this.featureType = (SimpleFeatureType)featureCollection.getSchema();
        this.featureCollection = featureCollection;
        this.featureCollectionListener = new CollectionListener(){

            public void collectionChanged(CollectionEvent tce) {
                if (tce.getEventType() == 0) {
                    VectorDataNode.this.fireFeaturesAdded(tce.getFeatures());
                } else if (tce.getEventType() == 1) {
                    VectorDataNode.this.fireFeaturesRemoved(tce.getFeatures());
                } else if (tce.getEventType() == 2) {
                    VectorDataNode.this.fireFeaturesChanged(tce.getFeatures());
                }
            }
        };
        this.featureCollection.addListener(this.featureCollectionListener);
        this.defaultStyleCss = String.format(DEFAULT_STYLE_FORMAT, FILL_COLORS[fillColorIndex++ % FILL_COLORS.length]);
        this.placemarkDescriptor = placemarkDescriptor;
        Debug.trace(String.format("VectorDataNode created: name=%s, featureType.typeName=%s, placemarkDescriptor.class=%s", name, this.featureType.getTypeName(), placemarkDescriptor.getClass()));
    }

    @Override
    public synchronized void setOwner(ProductNode owner) {
        super.setOwner(owner);
        if (this.getProduct() != null) {
            this.updateFeatureCollectionByPlacemarkGroup();
        }
    }

    public PlacemarkDescriptor getPlacemarkDescriptor() {
        return this.placemarkDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlacemarkGroup getPlacemarkGroup() {
        if (this.placemarkGroup == null) {
            VectorDataNode vectorDataNode = this;
            synchronized (vectorDataNode) {
                if (this.placemarkGroup == null) {
                    this.placemarkGroup = new PlacemarkGroup(this.getProduct(), this.getName(), this);
                }
            }
        }
        return this.placemarkGroup;
    }

    @Override
    public synchronized void setModified(boolean modified) {
        super.setModified(modified);
        if (this.placemarkGroup != null) {
            this.placemarkGroup.setModified(modified);
        }
    }

    public void fireFeaturesAdded(SimpleFeature ... features) {
        this.bounds = null;
        this.fireProductNodeChanged(PROPERTY_NAME_FEATURE_COLLECTION, null, features);
    }

    public void fireFeaturesRemoved(SimpleFeature ... features) {
        this.bounds = null;
        this.fireProductNodeChanged(PROPERTY_NAME_FEATURE_COLLECTION, features, null);
    }

    public void fireFeaturesChanged(SimpleFeature ... features) {
        this.bounds = null;
        this.fireProductNodeChanged(PROPERTY_NAME_FEATURE_COLLECTION, features, features);
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> getFeatureCollection() {
        return this.featureCollection;
    }

    public ReferencedEnvelope getEnvelope() {
        if (this.bounds == null) {
            this.bounds = new ReferencedEnvelope(this.featureType.getCoordinateReferenceSystem());
            try (FeatureIterator iterator = this.featureCollection.features();){
                while (iterator.hasNext()) {
                    BoundingBox geomBounds = ((SimpleFeature)iterator.next()).getBounds();
                    if (geomBounds.isEmpty()) continue;
                    this.bounds.include(geomBounds);
                }
            }
        }
        return this.bounds;
    }

    @Override
    public long getRawStorageSize(ProductSubsetDef subsetDef) {
        return this.featureType.getAttributeCount() * this.featureCollection.size() * 256;
    }

    public String getDefaultStyleCss() {
        return this.defaultStyleCss;
    }

    public void setDefaultStyleCss(String defaultStyleCss) {
        Assert.notNull((Object)this.defaultStyleCss, (String)PROPERTY_NAME_DEFAULT_STYLE_CSS);
        if (!ObjectUtils.equalObjects(this.defaultStyleCss, defaultStyleCss)) {
            String oldValue = this.defaultStyleCss;
            this.defaultStyleCss = defaultStyleCss;
            this.fireProductNodeChanged(PROPERTY_NAME_DEFAULT_STYLE_CSS, oldValue, this.defaultStyleCss);
        }
    }

    public String getStyleCss() {
        return this.styleCss;
    }

    public void setStyleCss(String styleCss) {
        if (!ObjectUtils.equalObjects(this.styleCss, styleCss)) {
            String oldValue = this.styleCss;
            this.styleCss = styleCss;
            this.fireProductNodeChanged(PROPERTY_NAME_STYLE_CSS, oldValue, this.styleCss);
        }
    }

    @Override
    public void acceptVisitor(ProductVisitor visitor) {
        if (this.placemarkGroup != null) {
            this.placemarkGroup.acceptVisitor(visitor);
        }
        visitor.visit(this);
    }

    @Override
    public void dispose() {
        this.featureCollection.removeListener(this.featureCollectionListener);
        super.dispose();
    }

    private void updateFeatureCollectionByPlacemarkGroup() {
        try (FeatureIterator iterator = this.featureCollection.features();){
            while (iterator.hasNext()) {
                this.generatePlacemarkForFeature((SimpleFeature)iterator.next());
            }
        }
    }

    private void generatePlacemarkForFeature(SimpleFeature feature) {
        Placemark placemark = this.getPlacemarkGroup().getPlacemark(feature);
        if (placemark == null) {
            this.placemarkGroup.add(this.placemarkDescriptor.createPlacemark(feature));
        }
    }

    private static PlacemarkDescriptor getPlacemarkDescriptor(SimpleFeatureType featureType) {
        PlacemarkDescriptorRegistry registry = PlacemarkDescriptorRegistry.getInstance();
        PlacemarkDescriptor placemarkDescriptor = registry.getPlacemarkDescriptor(featureType);
        if (placemarkDescriptor == null) {
            return new GenericPlacemarkDescriptor(featureType);
        }
        return placemarkDescriptor;
    }

    @Deprecated
    public boolean isInternalNode() {
        return this.getFeatureType().getTypeName().startsWith("org.esa.snap.");
    }

    @Deprecated
    public String getDefaultCSS() {
        return this.getDefaultStyleCss();
    }

    @Deprecated
    public void setDefaultCSS(String defaultCSS) {
        this.setDefaultStyleCss(defaultCSS);
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public void setPermanent(boolean permanent) {
        this.permanent = permanent;
    }
}

