/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import Jama.Matrix;
import Jama.SingularValueDecomposition;

public class RationalFunctionModel
implements Cloneable {
    private final int maxDegree;
    private final int termCount;
    private final double[] c;
    private final double[] d;
    private final double rmse;
    private double maxError;

    public RationalFunctionModel(int degreeP, int degreeQ, double[] x, double[] y, double[] g) {
        this(degreeP, degreeQ, x, y, g, 0);
    }

    RationalFunctionModel(int degreeP, int degreeQ, double[] x, double[] y, double[] g, int iterationCount) {
        if (degreeP < 0) {
            throw new IllegalArgumentException("degreeP < 0");
        }
        if (degreeQ < 0) {
            throw new IllegalArgumentException("degreeQ < 0");
        }
        if (degreeP > 4) {
            throw new IllegalArgumentException("degreeP > 4");
        }
        if (degreeQ > 4) {
            throw new IllegalArgumentException("degreeQ > 4");
        }
        if (x.length != y.length) {
            throw new IllegalArgumentException("x.length != y.length");
        }
        if (x.length != g.length) {
            throw new IllegalArgumentException("x.length != g.length");
        }
        int termCountP = RationalFunctionModel.getTermCountP(degreeP);
        int termCountQ = RationalFunctionModel.getTermCountQ(degreeQ);
        this.maxDegree = Math.max(degreeP, degreeQ);
        this.termCount = Math.max(termCountP, termCountQ + 1);
        this.c = new double[termCountP];
        this.d = new double[termCountQ];
        double[][] terms = new double[x.length][];
        for (int i = 0; i < x.length; ++i) {
            terms[i] = this.getTerms(x[i], y[i]);
        }
        RationalFunctionModel.fit(terms, g, this.c, this.d);
        for (int iter = 0; iter < iterationCount; ++iter) {
            RationalFunctionModel.refineFit(terms, g, this.c, this.d);
        }
        this.rmse = this.rmse(x, y, g);
        this.maxError = this.maxError(x, y, g);
    }

    public static int getTermCountP(int degreeP) {
        return (degreeP + 1) * (degreeP + 2) / 2;
    }

    public static int getTermCountQ(int degreeQ) {
        return (degreeQ + 1) * (degreeQ + 2) / 2 - 1;
    }

    public double getValue(double x, double y) {
        double[] terms = this.getTerms(x, y);
        return RationalFunctionModel.innerProduct(this.c, terms, 0.0, 0) / RationalFunctionModel.innerProduct(this.d, terms, 1.0, 1);
    }

    public double getRmse() {
        return this.rmse;
    }

    public double getMaxError() {
        return this.maxError;
    }

    private double[] getTerms(double x, double y) {
        double[] terms = new double[this.termCount];
        terms[0] = 1.0;
        if (this.maxDegree > 0) {
            terms[1] = x;
            terms[2] = y;
        }
        if (this.maxDegree > 1) {
            terms[3] = x * x;
            terms[4] = x * y;
            terms[5] = y * y;
        }
        if (this.maxDegree > 2) {
            terms[6] = x * terms[3];
            terms[7] = x * terms[4];
            terms[8] = x * terms[5];
            terms[9] = y * terms[5];
        }
        if (this.maxDegree > 3) {
            terms[10] = x * terms[6];
            terms[11] = x * terms[7];
            terms[12] = x * terms[8];
            terms[13] = x * terms[9];
            terms[14] = y * terms[9];
        }
        return terms;
    }

    private static double innerProduct(double[] a, double[] terms, double init, int firstTerm) {
        double s = init;
        int i = 0;
        int j = firstTerm;
        while (i < a.length) {
            s += a[i] * terms[j];
            ++i;
            ++j;
        }
        return s;
    }

    private static void fit(double[][] terms, double[] g, double[] c, double[] d) {
        assert (g.length == terms.length);
        int l = c.length;
        int r = d.length;
        int m = g.length;
        int n = l + r;
        double[][] a = new double[m][n];
        for (int i = 0; i < m; ++i) {
            System.arraycopy(terms[i], 0, a[i], 0, l);
            System.arraycopy(terms[i], 1, a[i], l, r);
            int j = l;
            while (j < n) {
                double[] dArray = a[i];
                int n2 = j++;
                dArray[n2] = dArray[n2] * -g[i];
            }
        }
        double[] x = new double[n];
        RationalFunctionModel.solve(a, g, x);
        System.arraycopy(x, 0, c, 0, l);
        System.arraycopy(x, l, d, 0, r);
    }

    private static void refineFit(double[][] terms, double[] g, double[] c, double[] d) {
        int j;
        assert (g.length == terms.length);
        int l = c.length;
        int r = d.length;
        int m = g.length;
        int n = l + r;
        double[][] a = new double[m][n];
        double[] b = new double[m];
        for (int i = 0; i < m; ++i) {
            double w = RationalFunctionModel.innerProduct(d, terms[i], 1.0, 1);
            double h = RationalFunctionModel.innerProduct(c, terms[i], 0.0, 0) / w;
            System.arraycopy(terms[i], 0, a[i], 0, l);
            System.arraycopy(terms[i], 1, a[i], l, r);
            int j2 = l;
            while (j2 < n) {
                double[] dArray = a[i];
                int n2 = j2++;
                dArray[n2] = dArray[n2] * -h;
            }
            j2 = 0;
            while (j2 < n) {
                double[] dArray = a[i];
                int n3 = j2++;
                dArray[n3] = dArray[n3] / w;
            }
            b[i] = g[i] - h;
        }
        double[] x = new double[n];
        RationalFunctionModel.solve(a, b, x);
        for (j = 0; j < l; ++j) {
            int n4 = j;
            c[n4] = c[n4] + x[j];
        }
        for (j = 0; j < r; ++j) {
            int n5 = j;
            d[n5] = d[n5] + x[l + j];
        }
    }

    private double rmse(double[] x, double[] y, double[] g) {
        double sum = 0.0;
        for (int i = 0; i < g.length; ++i) {
            double d = this.getValue(x[i], y[i]) - g[i];
            sum += d * d;
        }
        return Math.sqrt(sum / (double)g.length);
    }

    private double maxError(double[] x, double[] y, double[] g) {
        double maxError = 0.0;
        for (int i = 0; i < g.length; ++i) {
            double d = Math.abs(this.getValue(x[i], y[i]) - g[i]);
            if (!(d > maxError)) continue;
            maxError = d;
        }
        return maxError;
    }

    private static void solve(double[][] a, double[] b, double[] x) {
        int i;
        int j;
        Matrix v;
        Matrix u;
        SingularValueDecomposition svd;
        int m = b.length;
        int n = x.length;
        if (m < n) {
            svd = new Matrix(a, m, n).transpose().svd();
            u = svd.getV();
            v = svd.getU();
        } else {
            svd = new Matrix(a, m, n).svd();
            u = svd.getU();
            v = svd.getV();
        }
        double[] s = svd.getSingularValues();
        int rank = svd.rank();
        for (j = 0; j < rank; ++j) {
            x[j] = 0.0;
            for (i = 0; i < m; ++i) {
                int n2 = j;
                x[n2] = x[n2] + u.get(i, j) * b[i];
            }
            s[j] = x[j] / s[j];
        }
        for (j = 0; j < n; ++j) {
            x[j] = 0.0;
            for (i = 0; i < rank; ++i) {
                int n3 = j;
                x[n3] = x[n3] + v.get(j, i) * s[i];
            }
        }
    }

    public String createCFunctionCode(String compute_x, String lat, String lon) {
        return null;
    }
}

