/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import java.util.EventObject;
import java.util.Vector;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.ProductNodeList;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.core.datamodel.ProductVisitorAdapter;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.barithm.BandArithmetic;

public class ProductManager {
    private static final int PRODUCT_ADDED = 1;
    private static final int PRODUCT_REMOVED = 2;
    private Vector<Listener> listeners;
    private final ProductNodeList<Product> productList = new ProductNodeList();
    private ProductNodeNameChangeListener productNodeNameChangeListener = new ProductNodeNameChangeListener();

    public int getProductCount() {
        return this.productList.size();
    }

    public Product getProduct(int index) {
        return this.productList.getAt(index);
    }

    public String[] getProductDisplayNames() {
        return this.productList.getDisplayNames();
    }

    public String[] getProductNames() {
        return this.productList.getNames();
    }

    public Product[] getProducts() {
        return (Product[])this.productList.toArray(new Product[this.getProductCount()]);
    }

    public Product getProductByDisplayName(String displayName) {
        if (displayName == null) {
            return null;
        }
        return this.productList.getByDisplayName(displayName);
    }

    public Product getProductByRefNo(int refNo) {
        for (Product product : this.getProducts()) {
            if (refNo != product.getRefNo()) continue;
            return product;
        }
        return null;
    }

    public Product getProduct(String name) {
        return this.productList.get(name);
    }

    public int getProductIndex(Product product) {
        return this.productList.indexOf(product);
    }

    public boolean containsProduct(String name) {
        return this.productList.contains(name);
    }

    public boolean contains(Product product) {
        return this.productList.contains(product);
    }

    public void addProduct(Product product) {
        if (product != null) {
            if (this.contains(product)) {
                return;
            }
            if (this.productList.add(product)) {
                this.setProductManager(product);
                if (product.getRefNo() <= 0) {
                    product.setRefNo(this.getNextRefNo() + 1);
                }
                product.addProductNodeListener(this.productNodeNameChangeListener);
                this.fireEvent(product, 1);
            }
        }
    }

    private void updateExpressionToRenamedNode(ProductNode renamedNode, String oldName) {
        Product[] products = this.getProducts();
        String oldExternName = BandArithmetic.createExternalName(oldName);
        String newExternName = BandArithmetic.createExternalName(renamedNode.getName());
        for (Product product : products) {
            if (product == renamedNode.getProduct()) continue;
            product.acceptVisitor(new ExpressionUpdaterVisitor(oldExternName, newExternName));
        }
    }

    public boolean removeProduct(Product product) {
        int index;
        if (product != null && (index = this.productList.indexOf(product)) >= 0 && this.productList.remove(product)) {
            this.productList.clearRemovedList();
            product.removeProductNodeListener(this.productNodeNameChangeListener);
            this.clearProductManager(product);
            this.fireEvent(product, 2);
            product.resetRefNo();
            return true;
        }
        return false;
    }

    public void removeAllProducts() {
        Product[] products;
        for (Product product : products = this.getProducts()) {
            this.removeProduct(product);
        }
    }

    private void setProductManager(Product product) {
        if (product.getProductManager() != this) {
            product.setProductManager(this);
        }
    }

    private void clearProductManager(Product product) {
        if (product.getProductManager() == this) {
            product.setProductManager(null);
        }
    }

    private int getNextRefNo() {
        int numProducts = this.getProductCount();
        int highestRefNo = 0;
        for (int i = 0; i < numProducts; ++i) {
            int refNo = this.getProduct(i).getRefNo();
            if (refNo <= highestRefNo) continue;
            highestRefNo = refNo;
        }
        return highestRefNo;
    }

    public synchronized boolean addListener(Listener listener) {
        if (listener == null) {
            return false;
        }
        if (this.listeners == null) {
            this.listeners = new Vector(8);
        }
        for (Listener l : this.listeners) {
            if (listener != l) continue;
            return false;
        }
        this.listeners.add(listener);
        return true;
    }

    public synchronized boolean removeListener(Listener listener) {
        if (listener != null && this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener l = this.listeners.get(i);
                if (listener != l) continue;
                this.listeners.remove(i);
                return true;
            }
        }
        return false;
    }

    private boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    private void fireEvent(Product sourceProduct, int eventId) {
        if (this.hasListeners()) {
            Event event = new Event(sourceProduct);
            for (Listener listener : this.listeners) {
                ProductManager.fireEvent(eventId, listener, event);
            }
        }
    }

    private static void fireEvent(int eventId, Listener listener, Event event) {
        switch (eventId) {
            case 1: {
                listener.productAdded(event);
                break;
            }
            case 2: {
                listener.productRemoved(event);
            }
        }
    }

    private class ProductNodeNameChangeListener
    extends ProductNodeListenerAdapter {
        private ProductNodeNameChangeListener() {
        }

        @Override
        public void nodeChanged(ProductNodeEvent event) {
            if ("name".equals(event.getPropertyName())) {
                ProductManager.this.updateExpressionToRenamedNode(event.getSourceNode(), (String)event.getOldValue());
            }
        }
    }

    private static class ExpressionUpdaterVisitor
    extends ProductVisitorAdapter {
        private final String oldExternName;
        private final String newExternName;

        public ExpressionUpdaterVisitor(String oldExternName, String newExternName) {
            this.oldExternName = oldExternName;
            this.newExternName = newExternName;
        }

        @Override
        public void visit(TiePointGrid grid) {
            grid.updateExpression(this.oldExternName, this.newExternName);
        }

        @Override
        public void visit(Band band) {
            band.updateExpression(this.oldExternName, this.newExternName);
        }

        @Override
        public void visit(VirtualBand virtualBand) {
            virtualBand.updateExpression(this.oldExternName, this.newExternName);
        }

        @Override
        public void visit(Mask mask) {
            mask.updateExpression(this.oldExternName, this.newExternName);
        }

        @Override
        public void visit(ProductNodeGroup group) {
            group.updateExpression(this.oldExternName, this.newExternName);
        }
    }

    public static class Event
    extends EventObject {
        public Event(Product product) {
            super((Object)product);
        }

        public Product getProduct() {
            return (Product)((Object)this.getSource());
        }
    }

    public static interface Listener {
        public void productAdded(Event var1);

        public void productRemoved(Event var1);
    }
}

