/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import org.esa.snap.core.datamodel.DataNode;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductVisitor;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.ObjectUtils;

public class MetadataAttribute
extends DataNode {
    public MetadataAttribute(String name, int type) {
        this(name, type, 1);
    }

    public MetadataAttribute(String name, int type, int numElems) {
        this(name, ProductData.createInstance(type, numElems), false);
    }

    public MetadataAttribute(String name, ProductData data, boolean readOnly) {
        super(name, data, readOnly);
    }

    public MetadataElement getParentElement() {
        return MetadataElement.getParentElement(this);
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        MetadataAttribute attribute = (MetadataAttribute)((Object)object);
        return ObjectUtils.equalObjects(attribute.getData(), this.getData());
    }

    @Override
    public void acceptVisitor(ProductVisitor visitor) {
        Guardian.assertNotNull("visitor", visitor);
        visitor.visit(this);
    }

    public MetadataAttribute createDeepClone() {
        MetadataAttribute clone = new MetadataAttribute(this.getName(), this.getData().createDeepClone(), this.isReadOnly());
        clone.setDescription(this.getDescription());
        clone.setSynthetic(this.isSynthetic());
        clone.setUnit(this.getUnit());
        return clone;
    }
}

