/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.AbstractGeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Scene;
import org.esa.snap.core.dataop.maptransf.Datum;
import org.esa.snap.core.dataop.maptransf.MapInfo;
import org.esa.snap.core.dataop.maptransf.MapTransform;
import org.esa.snap.core.dataop.maptransf.geotools.CoordinateReferenceSystems;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.ProductUtils;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.operation.MathTransform;

public class MapGeoCoding
extends AbstractGeoCoding {
    private final MapInfo mapInfo;
    private final MapTransform mapTransform;
    private final AffineTransform imageToMapTransform;
    private final AffineTransform mapToImageTransform;
    private final boolean normalized;
    private final double normalizedLonMin;

    public MapGeoCoding(MapInfo mapInfo) {
        Guardian.assertNotNull("mapInfo", mapInfo);
        this.mapInfo = mapInfo;
        this.imageToMapTransform = this.mapInfo.getPixelToMapTransform();
        try {
            this.mapToImageTransform = this.mapInfo.getPixelToMapTransform().createInverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException("mapInfo", e);
        }
        this.mapTransform = this.mapInfo.getMapProjection().getMapTransform();
        Rectangle rect = new Rectangle(0, 0, this.mapInfo.getSceneWidth(), this.mapInfo.getSceneHeight());
        if (!rect.isEmpty()) {
            GeoPos[] geoPoints = this.createGeoBoundary(rect);
            this.normalized = ProductUtils.normalizeGeoPolygon(geoPoints) != 0;
            double normalizedLonMin = Double.MAX_VALUE;
            for (GeoPos geoPoint : geoPoints) {
                normalizedLonMin = Math.min(normalizedLonMin, geoPoint.lon);
            }
            this.normalizedLonMin = normalizedLonMin;
        } else {
            this.normalized = false;
            this.normalizedLonMin = -180.0;
        }
        CoordinateReferenceSystem mapCRS = CoordinateReferenceSystems.getCRS(mapInfo.getMapProjection(), mapInfo.getDatum());
        this.setMapCRS(mapCRS);
        this.setImageCRS((CoordinateReferenceSystem)MapGeoCoding.createImageCRS(mapCRS, (MathTransform)new AffineTransform2D(this.mapToImageTransform)));
        if (mapCRS instanceof DerivedCRS) {
            DerivedCRS derivedCRS = (DerivedCRS)mapCRS;
            CoordinateReferenceSystem baseCRS = derivedCRS.getBaseCRS();
            this.setGeoCRS(baseCRS);
        } else {
            this.setGeoCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
    }

    public MapInfo getMapInfo() {
        return this.mapInfo;
    }

    @Override
    public boolean isCrossingMeridianAt180() {
        return this.normalized;
    }

    @Override
    public boolean canGetGeoPos() {
        return true;
    }

    @Override
    public boolean canGetPixelPos() {
        return true;
    }

    @Override
    public final PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        GeoPos geoPosNorm = this.normGeoPos(geoPos, new GeoPos());
        Point2D mapPos = this.geoToMap(geoPosNorm, new Point2D.Double());
        return this.mapToPixel(mapPos, pixelPos);
    }

    @Override
    public final GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
        Point2D mapPos = this.pixelToMap(pixelPos, new Point2D.Double());
        GeoPos geoPosNorm = this.mapToGeo(mapPos, new GeoPos());
        return this.denormGeoPos(geoPosNorm, geoPos);
    }

    @Override
    public void dispose() {
    }

    @Override
    public Datum getDatum() {
        return this.mapInfo.getDatum();
    }

    public MapGeoCoding createDeepClone() {
        return new MapGeoCoding(this.mapInfo.createDeepClone());
    }

    private Point2D geoToMap(GeoPos geoPosNorm, Point2D mapPos) {
        return this.mapTransform.forward(geoPosNorm, mapPos);
    }

    private GeoPos mapToGeo(Point2D mapPos, GeoPos geoPos) {
        return this.mapTransform.inverse(mapPos, geoPos);
    }

    private PixelPos mapToPixel(Point2D mapPos, PixelPos pixelPos) {
        if (pixelPos != null) {
            this.mapToImageTransform.transform(mapPos, pixelPos);
            return pixelPos;
        }
        Point2D point2D = this.mapToImageTransform.transform(mapPos, pixelPos);
        return new PixelPos(point2D.getX(), point2D.getY());
    }

    private Point2D pixelToMap(PixelPos pixelPos, Point2D mapPos) {
        return this.imageToMapTransform.transform(pixelPos, mapPos);
    }

    private GeoPos normGeoPos(GeoPos geoPos, GeoPos geoPosNorm) {
        geoPosNorm.lat = geoPos.lat;
        geoPosNorm.lon = this.normalized && geoPos.lon < this.normalizedLonMin ? geoPos.lon + 360.0 : geoPos.lon;
        return geoPosNorm;
    }

    private GeoPos denormGeoPos(GeoPos geoPosNorm, GeoPos geoPos) {
        if (geoPos == null) {
            geoPos = new GeoPos();
        }
        geoPos.lat = geoPosNorm.lat;
        geoPos.lon = geoPosNorm.lon;
        while (geoPos.lon > 180.0) {
            geoPos.lon -= 360.0;
        }
        while (geoPos.lon < -180.0) {
            geoPos.lon += 360.0;
        }
        return geoPos;
    }

    private GeoPos[] createGeoBoundary(Rectangle rect) {
        int step = (int)Math.max(16.0, (rect.getWidth() + rect.getHeight()) / 250.0);
        PixelPos[] rectBoundary = ProductUtils.createRectBoundary(rect, step);
        GeoPos[] geoPoints = new GeoPos[rectBoundary.length];
        for (int i = 0; i < geoPoints.length; ++i) {
            geoPoints[i] = this.getGeoPos(rectBoundary[i], null);
        }
        return geoPoints;
    }

    @Override
    public boolean transferGeoCoding(Scene srcScene, Scene destScene, ProductSubsetDef subsetDef) {
        MapGeoCoding srcMapGeoCoding = (MapGeoCoding)srcScene.getGeoCoding();
        MapInfo srcMapInfo = srcMapGeoCoding.getMapInfo();
        float pixelX = srcMapInfo.getPixelX();
        float pixelY = srcMapInfo.getPixelY();
        float easting = srcMapInfo.getEasting();
        float northing = srcMapInfo.getNorthing();
        float pixelSizeX = srcMapInfo.getPixelSizeX();
        float pixelSizeY = srcMapInfo.getPixelSizeY();
        float orientation = srcMapInfo.getOrientation();
        if (subsetDef != null) {
            Rectangle region = subsetDef.getRegion();
            if (orientation != 0.0f) {
                int x0 = 0;
                int y0 = 0;
                if (region != null) {
                    x0 = region.x;
                    y0 = region.y;
                }
                pixelX = MapGeoCoding.scalePosition(pixelX - (float)x0, subsetDef.getSubSamplingX());
                pixelY = MapGeoCoding.scalePosition(pixelY - (float)y0, subsetDef.getSubSamplingY());
            } else if (region != null) {
                pixelX -= (float)Math.floor(pixelX);
                pixelY -= (float)Math.floor(pixelY);
                PixelPos pixelPos = new PixelPos((float)region.x + pixelX, (float)region.y + pixelY);
                GeoPos geoPos = this.getGeoPos(pixelPos, null);
                Point2D mapPoint = this.getMapInfo().getMapProjection().getMapTransform().forward(geoPos, null);
                easting = (float)mapPoint.getX();
                northing = (float)mapPoint.getY();
            }
            pixelSizeX *= (float)subsetDef.getSubSamplingX();
            pixelSizeY *= (float)subsetDef.getSubSamplingY();
        }
        MapInfo destMapInfo = (MapInfo)srcMapInfo.clone();
        destMapInfo.setPixelX(pixelX);
        destMapInfo.setPixelY(pixelY);
        destMapInfo.setEasting(easting);
        destMapInfo.setNorthing(northing);
        destMapInfo.setPixelSizeX(pixelSizeX);
        destMapInfo.setPixelSizeY(pixelSizeY);
        destMapInfo.setSceneWidth(destScene.getRasterWidth());
        destMapInfo.setSceneHeight(destScene.getRasterHeight());
        destScene.setGeoCoding(new MapGeoCoding(destMapInfo));
        return true;
    }

    private static float scalePosition(float position, int subSampling) {
        if (subSampling == 1) {
            return position;
        }
        int positionInt = (int)Math.floor(position);
        float fraction = position - (float)positionInt;
        return (float)(positionInt / subSampling) + fraction;
    }

    @Override
    public MathTransform getImageToMapTransform() {
        return new AffineTransform2D(this.imageToMapTransform);
    }
}

