/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import java.io.IOException;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.TimeCoding;

public class LineTimeCoding
implements TimeCoding {
    private final double[] mjDs;
    private final double minY;
    private final double maxY;

    public LineTimeCoding(int numLines, double mjdStart, double mjdEnd) throws IOException {
        this(LineTimeCoding.createMJDs(numLines, mjdStart, mjdEnd));
    }

    public LineTimeCoding(double[] mjDs) throws IOException {
        assert (mjDs != null);
        assert (mjDs.length > 0);
        this.mjDs = mjDs;
        this.minY = 0.0;
        this.maxY = mjDs.length;
    }

    @Override
    public double getMJD(PixelPos pixelPos) {
        double y = pixelPos.y;
        if (y < this.minY || y > this.maxY) {
            return Double.NaN;
        }
        int indexY = (int)Math.floor(y);
        if ((double)indexY == this.maxY) {
            --indexY;
        }
        return this.mjDs[indexY];
    }

    private static double[] createMJDs(int numLines, double mjdStart, double mjdEnd) {
        double part = (mjdEnd - mjdStart) / (double)(numLines - 1);
        double[] MJDs = new double[numLines];
        MJDs[0] = mjdStart;
        MJDs[MJDs.length - 1] = mjdEnd;
        for (int i = 1; i < MJDs.length - 1; ++i) {
            MJDs[i] = mjdStart + (double)i * part;
        }
        return MJDs;
    }
}

