/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geometry;

import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.ConverterRegistry;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.util.converters.JtsGeometryConverter;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class VectorDataNodeIO {
    public static final char DEFAULT_DELIMITER_CHAR = '\t';
    public static final String ESCAPE_STRING = "\\t";
    public static final String NULL_TEXT = "[null]";
    public static final String FILENAME_EXTENSION = ".csv";
    static final String PROPERTY_NAME_DEFAULT_CSS = "defaultCSS";

    public static Converter[] getConverters(SimpleFeatureType simpleFeatureType) throws IOException {
        Converter[] converters = new Converter[simpleFeatureType.getAttributeCount()];
        for (int i = 0; i < converters.length; ++i) {
            Class attributeType = simpleFeatureType.getType(i).getBinding();
            Converter converter = ConverterRegistry.getInstance().getConverter(attributeType);
            if (converter == null) {
                throw new IOException(String.format("No converter for type %s found.", attributeType));
            }
            converters[i] = converter;
        }
        return converters;
    }

    public static String encodeTabString(String input) {
        StringBuilder sb = new StringBuilder(input.length() + 10);
        boolean escapeMode = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\t') {
                sb.append(ESCAPE_STRING);
                escapeMode = false;
                continue;
            }
            if (c == '\\') {
                escapeMode = true;
            } else {
                if (c == 't' && escapeMode) {
                    sb.append('\\');
                }
                escapeMode = false;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String decodeTabString(String input) {
        StringBuilder sb = new StringBuilder(input.length() + 10);
        int numEscapes = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\\') {
                ++numEscapes;
                sb.append(c);
                continue;
            }
            if (c == 't' && numEscapes == 1) {
                sb.deleteCharAt(sb.length() - 1);
                sb.append('\t');
                numEscapes = 0;
                continue;
            }
            if (c == 't' && numEscapes > 1) {
                sb.deleteCharAt(sb.length() - 1);
                sb.append(c);
                numEscapes = 0;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static VectorDataNode[] getVectorDataNodes(VectorDataNode vectorDataNode, boolean individualShapes, String attributeName) {
        VectorDataNode[] vectorDataNodes;
        if (individualShapes) {
            FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection = vectorDataNode.getFeatureCollection();
            SimpleFeature[] features = (SimpleFeature[])featureCollection.toArray((Object[])new SimpleFeature[0]);
            vectorDataNodes = new VectorDataNode[features.length];
            HashMap<String, Integer> nameCountMap = new HashMap<String, Integer>();
            for (int i = 0; i < features.length; ++i) {
                SimpleFeature feature = features[i];
                String newName = attributeName != null && feature.getAttribute(attributeName) != null && !feature.getAttribute(attributeName).toString().isEmpty() ? feature.getAttribute(attributeName).toString().replace(" ", "_").replace("-", "_") : vectorDataNode.getName() + "_" + (i + 1);
                if (nameCountMap.containsKey(newName)) {
                    Integer count = (Integer)nameCountMap.get(newName);
                    nameCountMap.put(newName, count + 1);
                    newName = newName + "_" + count;
                } else {
                    nameCountMap.put(newName, 1);
                }
                vectorDataNodes[i] = new VectorDataNode(newName, (FeatureCollection<SimpleFeatureType, SimpleFeature>)new ListFeatureCollection(vectorDataNode.getFeatureType(), Arrays.asList(feature)));
            }
        } else {
            vectorDataNodes = new VectorDataNode[]{vectorDataNode};
        }
        return vectorDataNodes;
    }

    static {
        JtsGeometryConverter.registerConverter();
    }
}

