/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio.geometry;

import com.bc.ceres.binding.ConversionException;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.IOException;
import org.esa.snap.core.dataio.geometry.AbstractInterpretationStrategy;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

class LatLonAndFeatureTypeStrategy
extends AbstractInterpretationStrategy {
    private String featureTypeName;
    private double lat;
    private double lon;
    private int latIndex;
    private int lonIndex;

    LatLonAndFeatureTypeStrategy(String featureTypeName, int latIndex, int lonIndex) {
        this.featureTypeName = featureTypeName;
        this.latIndex = latIndex;
        this.lonIndex = lonIndex;
    }

    @Override
    public void setDefaultGeometry(String defaultGeometry, CoordinateReferenceSystem featureCrs, SimpleFeatureTypeBuilder builder) throws IOException {
        builder.add("geometry", Point.class, featureCrs);
        builder.setDefaultGeometry("geometry");
    }

    @Override
    public void setName(SimpleFeatureTypeBuilder builder) {
        builder.setName(this.featureTypeName);
    }

    @Override
    public String getFeatureId(String[] tokens) {
        return tokens[0];
    }

    @Override
    public SimpleFeature interpretLine(String[] tokens, SimpleFeatureBuilder builder, SimpleFeatureType simpleFeatureType) throws IOException, ConversionException, TransformException {
        int attributeIndex = 0;
        for (int columnIndex = 1; columnIndex < tokens.length; ++columnIndex) {
            String token = tokens[columnIndex];
            if (columnIndex == this.latIndex) {
                this.lat = Double.parseDouble(token);
            } else if (columnIndex == this.lonIndex) {
                this.lon = Double.parseDouble(token);
            }
            this.setAttributeValue(builder, simpleFeatureType, attributeIndex, token);
            ++attributeIndex;
        }
        builder.set("geometry", (Object)new GeometryFactory().createPoint(new Coordinate(this.lon, this.lat)));
        String featureId = this.getFeatureId(tokens);
        return builder.buildFeature(featureId);
    }

    @Override
    public int getExpectedTokenCount(int attributeCount) {
        int expectedTokenCount = attributeCount;
        --expectedTokenCount;
        return ++expectedTokenCount;
    }

    @Override
    public int getStartColumn() {
        return 1;
    }
}

