/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.TreeNode;
import org.esa.snap.runtime.Config;

public abstract class AbstractProductReader
implements ProductReader {
    private static final String SYSPROP_READER_TILE_WIDTH = "snap.dataio.reader.tileWidth";
    private static final String SYSPROP_READER_TILE_HEIGHT = "snap.dataio.reader.tileHeight";
    private final ProductReaderPlugIn readerPlugIn;
    private Object input;
    private ProductSubsetDef subsetDef;

    protected AbstractProductReader(ProductReaderPlugIn readerPlugIn) {
        this.readerPlugIn = readerPlugIn;
    }

    @Override
    public ProductReaderPlugIn getReaderPlugIn() {
        return this.readerPlugIn;
    }

    @Override
    public Object getInput() {
        return this.input;
    }

    protected void setInput(Object input) {
        this.input = input;
    }

    public boolean isMetadataIgnored() {
        boolean ignoreMetadata = false;
        if (this.subsetDef != null) {
            ignoreMetadata = this.subsetDef.isIgnoreMetadata();
        }
        return ignoreMetadata;
    }

    @Override
    public ProductSubsetDef getSubsetDef() {
        return this.subsetDef;
    }

    protected void setSubsetDef(ProductSubsetDef subsetDef) {
        this.subsetDef = subsetDef;
    }

    public boolean isNodeAccepted(String name) {
        return this.getSubsetDef() == null || this.getSubsetDef().isNodeAccepted(name);
    }

    @Override
    public Product readProductNodes(Object input, ProductSubsetDef subsetDef) throws IOException {
        if (input != null && !this.isInstanceOfValidInputType(input)) {
            throw new IllegalArgumentException("invalid input source: " + input);
        }
        long startTime = System.currentTimeMillis();
        this.setInput(input);
        this.setSubsetDef(subsetDef);
        Product product = this.readProductNodesImpl();
        AbstractProductReader.configurePreferredTileSize(product);
        product.setModified(false);
        if (product.getProductReader() == null) {
            product.setProductReader(this);
        }
        long endTime = System.currentTimeMillis();
        String msg = String.format("Read product nodes (took %d ms)", endTime - startTime);
        SystemUtils.LOG.fine(msg);
        return product;
    }

    protected abstract Product readProductNodesImpl() throws IOException;

    @Override
    public void readBandRasterData(Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        Guardian.assertNotNull("destBand", destBand);
        Guardian.assertNotNull("destBuffer", destBuffer);
        if (destBuffer.getNumElems() < destWidth * destHeight) {
            throw new IllegalArgumentException("destination buffer too small");
        }
        if (destBuffer.getNumElems() > destWidth * destHeight) {
            throw new IllegalArgumentException("destination buffer too big");
        }
        int sourceOffsetX = 0;
        int sourceOffsetY = 0;
        int sourceStepX = 1;
        int sourceStepY = 1;
        if (this.getSubsetDef() != null) {
            sourceStepX = this.getSubsetDef().getSubSamplingX();
            sourceStepY = this.getSubsetDef().getSubSamplingY();
            if (this.getSubsetDef().getRegion() != null) {
                sourceOffsetX = this.getSubsetDef().getRegion().x;
                sourceOffsetY = this.getSubsetDef().getRegion().y;
            }
        }
        int sourceWidth = sourceStepX * (destWidth - 1) + 1;
        int sourceHeight = sourceStepY * (destHeight - 1) + 1;
        this.readBandRasterDataImpl(sourceOffsetX += sourceStepX * destOffsetX, sourceOffsetY += sourceStepY * destOffsetY, sourceWidth, sourceHeight, sourceStepX, sourceStepY, destBand, destOffsetX, destOffsetY, destWidth, destHeight, destBuffer, pm);
    }

    protected abstract void readBandRasterDataImpl(int var1, int var2, int var3, int var4, int var5, int var6, Band var7, int var8, int var9, int var10, int var11, ProductData var12, ProgressMonitor var13) throws IOException;

    @Override
    public void close() throws IOException {
        Debug.trace("AbstractProductReader.close(): " + this.toString());
        this.input = null;
        this.subsetDef = null;
    }

    public TreeNode<File> getProductComponents() {
        File inputFile;
        Object input = this.getInput();
        if (input instanceof File) {
            inputFile = (File)input;
        } else if (input instanceof String) {
            inputFile = new File((String)input);
        } else {
            return null;
        }
        File parent = inputFile.getParentFile();
        if (parent == null) {
            return null;
        }
        TreeNode<File> result = new TreeNode<File>(parent.getName());
        result.setContent(parent);
        TreeNode<File> productFile = new TreeNode<File>(inputFile.getName());
        productFile.setContent(inputFile);
        result.addChild(productFile);
        return result;
    }

    protected boolean isInstanceOfValidInputType(Object input) {
        if (this.getReaderPlugIn() != null) {
            Class[] inputTypes;
            for (Class inputType : inputTypes = this.getReaderPlugIn().getInputTypes()) {
                if (!inputType.isInstance(input)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected int getGridDiscontinutity(String name) {
        if (AbstractProductReader.isNameOfLongitudeGrid(name)) {
            return TiePointGrid.DISCONT_AT_180;
        }
        return TiePointGrid.DISCONT_NONE;
    }

    protected TiePointGrid createTiePointGrid(String gridName, int gridWidth, int gridHeight, double offsetX, double offsetY, double subSamplingX, double subSamplingY, float[] tiePoints) {
        int gridDiscontinutity = this.getGridDiscontinutity(gridName);
        if (gridDiscontinutity != 0) {
            Debug.trace("creating tie-point grid '" + gridName + "' with discontinuity at " + gridDiscontinutity + " degree");
        }
        return new TiePointGrid(gridName, gridWidth, gridHeight, offsetX, offsetY, subSamplingX, subSamplingY, tiePoints, gridDiscontinutity);
    }

    public static void configurePreferredTileSize(Product product) {
        Dimension newSize = AbstractProductReader.getConfiguredTileSize(product, Config.instance().preferences().get(SYSPROP_READER_TILE_WIDTH, null), Config.instance().preferences().get(SYSPROP_READER_TILE_HEIGHT, null));
        if (newSize != null) {
            Dimension oldSize = product.getPreferredTileSize();
            if (oldSize == null) {
                product.setPreferredTileSize(newSize);
                SystemUtils.LOG.fine(String.format("Product '%s': tile size set to %d x %d pixels", product.getName(), newSize.width, newSize.height));
            } else if (!oldSize.equals(newSize)) {
                product.setPreferredTileSize(newSize);
                SystemUtils.LOG.fine(String.format("Product '%s': tile size set to %d x %d pixels, was %d x %d pixels", product.getName(), newSize.width, newSize.height, oldSize.width, oldSize.height));
            }
        }
    }

    static Dimension getConfiguredTileSize(Product product, String tileWidthStr, String tileHeightStr) {
        Integer tileWidth = AbstractProductReader.parseTileSize(tileWidthStr, product.getSceneRasterWidth());
        Integer tileHeight = AbstractProductReader.parseTileSize(tileHeightStr, product.getSceneRasterHeight());
        Dimension newSize = null;
        if (tileWidth != null || tileHeight != null) {
            Dimension oldSize = product.getPreferredTileSize();
            if (tileWidth == null) {
                tileWidth = oldSize != null ? oldSize.width : Math.min(product.getSceneRasterWidth(), tileHeight);
            }
            if (tileHeight == null) {
                tileHeight = oldSize != null ? oldSize.height : Math.min(product.getSceneRasterHeight(), tileWidth);
            }
            newSize = new Dimension(tileWidth, tileHeight);
        }
        return newSize;
    }

    static Integer parseTileSize(String sizeStr, int maxSize) {
        Integer size = null;
        if (sizeStr != null) {
            if (sizeStr.equals("*")) {
                size = maxSize;
            } else {
                try {
                    size = Integer.parseInt(sizeStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return size;
    }

    public String toString() {
        return this.getClass().getName() + "[input=" + this.input + "]";
    }

    private static boolean isNameOfLongitudeGrid(String name) {
        return name.equalsIgnoreCase("lon") || name.equalsIgnoreCase("long") || name.equalsIgnoreCase("longitude");
    }
}

