/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataio;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.Guardian;

public abstract class AbstractProductBuilder
extends AbstractProductReader {
    protected Product sourceProduct;
    protected boolean sourceProductOwner;
    protected int sceneRasterWidth;
    protected int sceneRasterHeight;
    protected String newProductName;
    protected String newProductDesc;
    protected Map<Band, RasterDataNode> bandMap = new Hashtable<Band, RasterDataNode>(16);

    public AbstractProductBuilder(boolean sourceProductOwner) {
        super(null);
        this.sourceProductOwner = sourceProductOwner;
    }

    public Product getSourceProduct() {
        return this.sourceProduct;
    }

    public boolean isSourceProductOwner() {
        return this.sourceProductOwner;
    }

    public void setNewProductDesc(String newProductDesc) {
        this.newProductDesc = newProductDesc;
    }

    public void setNewProductName(String newProductName) {
        this.newProductName = newProductName;
    }

    public int getSceneRasterWidth() {
        return this.sceneRasterWidth;
    }

    public int getSceneRasterHeight() {
        return this.sceneRasterHeight;
    }

    protected Product readProductNodes(Product sourceProduct, ProductSubsetDef subsetDef, String name, String desc) throws IOException {
        Guardian.assertNotNull("sourceProduct", (Object)sourceProduct);
        this.setNewProductName(name != null ? name : sourceProduct.getName());
        this.setNewProductDesc(desc != null ? desc : sourceProduct.getDescription());
        Product product = this.readProductNodes((Object)sourceProduct, subsetDef);
        product.setModified(true);
        return product;
    }

    @Override
    protected abstract Product readProductNodesImpl() throws IOException;

    @Override
    public void close() throws IOException {
        this.disposeBandMap();
        if (this.sourceProductOwner && this.sourceProduct != null) {
            this.sourceProduct.dispose();
        }
        this.sourceProduct = null;
        super.close();
    }

    protected void addFlagCodingsToProduct(Product product) {
        ProductNodeGroup<FlagCoding> flagCodingGroup = this.getSourceProduct().getFlagCodingGroup();
        for (int i = 0; i < flagCodingGroup.getNodeCount(); ++i) {
            FlagCoding sourceFlagCoding = flagCodingGroup.get(i);
            FlagCoding destFlagCoding = new FlagCoding(sourceFlagCoding.getName());
            destFlagCoding.setDescription(sourceFlagCoding.getDescription());
            this.cloneFlags(sourceFlagCoding, destFlagCoding);
            product.getFlagCodingGroup().add(destFlagCoding);
        }
    }

    protected void addIndexCodingsToProduct(Product product) {
        ProductNodeGroup<IndexCoding> indexCodingGroup = this.getSourceProduct().getIndexCodingGroup();
        for (int i = 0; i < indexCodingGroup.getNodeCount(); ++i) {
            IndexCoding sourceIndexCoding = indexCodingGroup.get(i);
            IndexCoding destIndexCoding = new IndexCoding(sourceIndexCoding.getName());
            destIndexCoding.setDescription(sourceIndexCoding.getDescription());
            this.cloneIndexes(sourceIndexCoding, destIndexCoding);
            product.getIndexCodingGroup().add(destIndexCoding);
        }
    }

    protected static void addAttribString(String name, String value, MetadataElement subsetElem) {
        ProductData data = ProductData.createInstance(value);
        subsetElem.addAttribute(new MetadataAttribute(name, data, true));
    }

    protected void cloneFlags(FlagCoding sourceFlagCoding, FlagCoding destFlagCoding) {
        this.cloneMetadataElementsAndAttributes(sourceFlagCoding, destFlagCoding, 1);
    }

    protected void cloneIndexes(IndexCoding sourceFlagCoding, IndexCoding destFlagCoding) {
        this.cloneMetadataElementsAndAttributes(sourceFlagCoding, destFlagCoding, 1);
    }

    protected void addMetadataToProduct(Product product) {
        this.cloneMetadataElementsAndAttributes(this.getSourceProduct().getMetadataRoot(), product.getMetadataRoot(), 0);
    }

    protected void cloneMetadataElementsAndAttributes(MetadataElement sourceRoot, MetadataElement destRoot, int level) {
        this.cloneMetadataElements(sourceRoot, destRoot, level);
        this.cloneMetadataAttributes(sourceRoot, destRoot);
    }

    protected void cloneMetadataElements(MetadataElement sourceRoot, MetadataElement destRoot, int level) {
        for (int i = 0; i < sourceRoot.getNumElements(); ++i) {
            MetadataElement sourceElement = sourceRoot.getElementAt(i);
            if (level <= 0 && !this.isNodeAccepted(sourceElement.getName())) continue;
            MetadataElement element = new MetadataElement(sourceElement.getName());
            element.setDescription(sourceElement.getDescription());
            destRoot.addElement(element);
            this.cloneMetadataElementsAndAttributes(sourceElement, element, level + 1);
        }
    }

    protected void cloneMetadataAttributes(MetadataElement sourceRoot, MetadataElement destRoot) {
        for (int i = 0; i < sourceRoot.getNumAttributes(); ++i) {
            MetadataAttribute sourceAttribute = sourceRoot.getAttributeAt(i);
            destRoot.addAttribute(sourceAttribute.createDeepClone());
        }
    }

    @Override
    protected boolean isInstanceOfValidInputType(Object input) {
        return input instanceof Product;
    }

    protected void disposeBandMap() {
        this.bandMap.clear();
    }
}

