/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap;

import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryManager;
import com.bc.ceres.core.runtime.Activator;
import com.bc.ceres.core.runtime.ConfigurationElement;
import com.bc.ceres.core.runtime.Extension;
import com.bc.ceres.core.runtime.ExtensionPoint;
import com.bc.ceres.core.runtime.ModuleContext;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.logging.Level;
import org.esa.snap.core.datamodel.RGBImageProfile;
import org.esa.snap.core.datamodel.RGBImageProfileManager;
import org.esa.snap.core.util.SystemUtils;
import org.geotools.factory.FactoryIteratorProvider;
import org.geotools.factory.GeoTools;
import org.geotools.referencing.operation.MathTransformProvider;

public class SnapCoreActivator
implements Activator {
    private FactoryIteratorProvider geotoolsFactoryIteratorProvider;

    public static boolean isStarted() {
        return false;
    }

    public static <T> void loadServices(ServiceRegistry<T> registry) {
        Iterable iterable = SystemUtils.loadServices(registry.getServiceType());
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            try {
                registry.addService(iterator.next());
            }
            catch (ServiceConfigurationError e) {
                SystemUtils.LOG.log(Level.WARNING, e.getMessage(), e.getCause());
            }
        }
    }

    public void start(ModuleContext moduleContext) throws CoreException {
        SystemUtils.init3rdPartyLibs(moduleContext.getModule().getClass());
        SnapCoreActivator.registerRGBProfiles(moduleContext);
        this.registerGeotoolsServices();
    }

    public void stop(ModuleContext moduleContext) throws CoreException {
        this.deregisterGeotoolsServices();
    }

    private void registerGeotoolsServices() {
        ServiceRegistry serviceRegistry = ServiceRegistryManager.getInstance().getServiceRegistry(MathTransformProvider.class);
        SnapCoreActivator.loadServices(serviceRegistry);
        this.geotoolsFactoryIteratorProvider = new GeotoolsFactoryIteratorProvider(serviceRegistry);
        GeoTools.addFactoryIteratorProvider((FactoryIteratorProvider)this.geotoolsFactoryIteratorProvider);
    }

    private void deregisterGeotoolsServices() {
        if (this.geotoolsFactoryIteratorProvider != null) {
            GeoTools.removeFactoryIteratorProvider((FactoryIteratorProvider)this.geotoolsFactoryIteratorProvider);
        }
    }

    private static void registerRGBProfiles(ModuleContext moduleContext) throws CoreException {
        ExtensionPoint rgbExtensionPoint = moduleContext.getModule().getExtensionPoint("rgbProfiles");
        Extension[] rgbExtensions = rgbExtensionPoint.getExtensions();
        RGBImageProfileManager profileManager = RGBImageProfileManager.getInstance();
        for (Extension extension : rgbExtensions) {
            ConfigurationElement[] rgbElements;
            ConfigurationElement confElem = extension.getConfigurationElement();
            for (ConfigurationElement rgbElement : rgbElements = (ConfigurationElement[])confElem.getChildren("rgbProfile")) {
                RGBImageProfile rgbImageProfile = new RGBImageProfile();
                rgbImageProfile.configure(rgbElement);
                profileManager.addProfile(rgbImageProfile);
            }
        }
    }

    private static final class GeotoolsFactoryIteratorProvider
    implements FactoryIteratorProvider {
        private final ServiceRegistry<MathTransformProvider> serviceRegistry;

        private GeotoolsFactoryIteratorProvider(ServiceRegistry<MathTransformProvider> serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
        }

        public <T> Iterator<T> iterator(Class<T> category) {
            if (category.equals(this.serviceRegistry.getServiceType())) {
                return this.serviceRegistry.getServices().iterator();
            }
            return null;
        }
    }
}

