/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics.output;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;

class EsriShapeFileWriter {
    private static final String FILE_EXTENSION_SHAPEFILE = ".shp";

    EsriShapeFileWriter() {
    }

    static void write(List<SimpleFeature> features, File file) throws IOException {
        String basename = file.getName();
        if (basename.endsWith(FILE_EXTENSION_SHAPEFILE)) {
            basename = basename.substring(0, basename.length() - 4);
        }
        File shapefile = new File(file.getParentFile(), basename + FILE_EXTENSION_SHAPEFILE);
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        Map<String, URL> map = Collections.singletonMap("url", shapefile.toURI().toURL());
        DataStore dataStore = factory.createNewDataStore(map);
        SimpleFeature simpleFeature = features.get(0);
        SimpleFeatureType simpleFeatureType = simpleFeature.getType();
        String typeName = simpleFeatureType.getName().getLocalPart();
        dataStore.createSchema((FeatureType)simpleFeatureType);
        FeatureStore featureStore = (FeatureStore)dataStore.getFeatureSource(typeName);
        DefaultTransaction transaction = new DefaultTransaction("X");
        featureStore.setTransaction((Transaction)transaction);
        SimpleFeatureCollection featureCollection = DataUtilities.collection(features);
        featureStore.addFeatures((FeatureCollection)featureCollection);
        try {
            transaction.commit();
        }
        catch (Exception e) {
            transaction.rollback();
            throw new IOException("Cannot write shapefile. Error:\n" + e.getMessage(), e);
        }
        finally {
            dataStore.dispose();
            transaction.close();
        }
    }
}

