/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.statistics;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.media.jai.Histogram;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.HistogramStxOp;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.SummaryStxOp;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.WildcardMatcher;
import org.esa.snap.statistics.BandConfiguration;
import org.esa.snap.statistics.ProductLoader;
import org.esa.snap.statistics.ProductLoop;
import org.esa.snap.statistics.ProductValidator;
import org.esa.snap.statistics.StatisticComputer;
import org.esa.snap.statistics.output.BandNameCreator;
import org.esa.snap.statistics.output.CsvStatisticsWriter;
import org.esa.snap.statistics.output.FeatureStatisticsWriter;
import org.esa.snap.statistics.output.MetadataWriter;
import org.esa.snap.statistics.output.StatisticsOutputContext;
import org.esa.snap.statistics.output.StatisticsOutputter;
import org.esa.snap.statistics.output.Util;

@OperatorMetadata(alias="StatisticsOp", category="Raster", version="1.0", authors="Sabine Embacher, Tonio Fincke, Thomas Storm", copyright="(c) 2012 by Brockmann Consult GmbH", description="Computes statistics for an arbitrary number of source products.", autoWriteDisabled=true)
public class StatisticsOp
extends Operator {
    public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String MAXIMUM = "maximum";
    public static final String MINIMUM = "minimum";
    public static final String MEDIAN = "median";
    public static final String AVERAGE = "average";
    public static final String SIGMA = "sigma";
    public static final String MAX_ERROR = "max_error";
    public static final String TOTAL = "total";
    public static final String PERCENTILE_PREFIX = "p";
    public static final String PERCENTILE_SUFFIX = "_threshold";
    public static final String DEFAULT_PERCENTILES = "90,95";
    public static final int[] DEFAULT_PERCENTILES_INTS = new int[]{90, 95};
    private static final double FILL_VALUE = -999.0;
    @SourceProducts(description="The source products to be considered for statistics computation. If not given, the parameter 'sourceProductPaths' must be provided.")
    Product[] sourceProducts;
    @Parameter(description="A comma-separated list of file paths specifying the source products.\nEach path may contain the wildcards '**' (matches recursively any directory),\n'*' (matches any character sequence in path names) and\n'?' (matches any single character).\nIf, for example, all NetCDF files under /eodata/ shall be considered, use '/eodata/**/*.nc'.")
    String[] sourceProductPaths;
    @Parameter(description="An ESRI shapefile, providing the considered geographical region(s) given as polygons. If null, all pixels are considered.")
    File shapefile;
    @Parameter(description="The start date. If not given, taken from the 'oldest' source product. Products that have a start date before the start date given by this parameter are not considered.", format="yyyy-MM-dd HH:mm:ss", converter=UtcConverter.class)
    ProductData.UTC startDate;
    @Parameter(description="The end date. If not given, taken from the 'youngest' source product. Products that have an end date after the end date given by this parameter are not considered.", format="yyyy-MM-dd HH:mm:ss", converter=UtcConverter.class)
    ProductData.UTC endDate;
    @Parameter(description="The band configurations. These configurations determine the input of the operator.", alias="bandConfigurations", itemAlias="bandConfiguration", notNull=true)
    BandConfiguration[] bandConfigurations;
    @Parameter(description="The target file for shapefile output. Shapefile output will only be written if this parameter is set. The band mapping file will have the suffix _band_mapping.txt.", notNull=false)
    File outputShapefile;
    @Parameter(description="The target file for ASCII output.The metadata file will have the suffix _metadata.txt.\nASCII output will only be written if this parameter is set.", notNull=false)
    File outputAsciiFile;
    @Parameter(description="The percentile levels that shall be created. Must be in the interval [0..100]", notNull=false, defaultValue="90,95")
    int[] percentiles;
    @Parameter(description="The degree of accuracy used for statistics computation. Higher numbers indicate higher accuracy but may lead to a considerably longer computation time.", defaultValue="3")
    int accuracy;
    final Set<StatisticsOutputter> statisticsOutputters = new HashSet<StatisticsOutputter>();
    final SortedSet<String> regionNames = new TreeSet<String>();
    private PrintStream metadataOutputStream;
    private PrintStream csvOutputStream;
    private PrintStream bandMappingOutputStream;

    public void initialize() throws OperatorException {
        String[] productNames;
        this.setDummyTargetProduct();
        this.validateInput();
        StatisticComputer statisticComputer = new StatisticComputer(this.shapefile, this.bandConfigurations, Util.computeBinCount(this.accuracy), this.getLogger());
        ProductValidator productValidator = new ProductValidator(Arrays.asList(this.bandConfigurations), this.startDate, this.endDate, this.getLogger());
        ProductLoop productLoop = new ProductLoop(new ProductLoader(), productValidator, statisticComputer, this.getLogger());
        productLoop.loop(this.sourceProducts, this.getProductsToLoad());
        if (this.startDate == null) {
            this.startDate = productLoop.getOldestDate();
        }
        if (this.endDate == null) {
            this.endDate = productLoop.getNewestDate();
        }
        if ((productNames = productLoop.getProductNames()).length == 0) {
            throw new OperatorException("No input products found that matches the criteria.");
        }
        Map<BandConfiguration, StatisticComputer.StxOpMapping> results = statisticComputer.getResults();
        String[] algorithmNames = StatisticsOp.getAlgorithmNames(this.percentiles);
        ArrayList<String> bandNamesList = new ArrayList<String>();
        for (BandConfiguration bandConfiguration : this.bandConfigurations) {
            if (bandConfiguration.sourceBandName != null) {
                bandNamesList.add(bandConfiguration.sourceBandName);
                continue;
            }
            bandNamesList.add(bandConfiguration.expression.replace(" ", "_"));
        }
        String[] bandNames = bandNamesList.toArray(new String[bandNamesList.size()]);
        this.regionNames.clear();
        for (StatisticComputer.StxOpMapping stxOpMapping : results.values()) {
            this.regionNames.addAll(stxOpMapping.summaryMap.keySet());
        }
        if (this.regionNames.size() == 0) {
            this.getLogger().warning("No statistics computed because no input product intersects any feature from the given shapefile.");
            return;
        }
        StatisticsOutputContext statisticsOutputContext = StatisticsOutputContext.create(productNames, bandNames, algorithmNames, this.startDate, this.endDate, this.regionNames.toArray(new String[this.regionNames.size()]));
        this.setupOutputter();
        for (StatisticsOutputter statisticsOutputter : this.statisticsOutputters) {
            statisticsOutputter.initialiseOutput(statisticsOutputContext);
        }
        for (Map.Entry entry : results.entrySet()) {
            BandConfiguration bandConfiguration = (BandConfiguration)entry.getKey();
            String bandName = bandConfiguration.sourceBandName != null ? bandConfiguration.sourceBandName : bandConfiguration.expression.replace(" ", "_");
            StatisticComputer.StxOpMapping stxOpMapping = (StatisticComputer.StxOpMapping)entry.getValue();
            Map<String, SummaryStxOp> summaryMap = stxOpMapping.summaryMap;
            Map<String, HistogramStxOp> histogramMap = stxOpMapping.histogramMap;
            for (String regionName : summaryMap.keySet()) {
                Object object;
                SummaryStxOp summaryStxOp = summaryMap.get(regionName);
                Histogram histogram = histogramMap.get(regionName).getHistogram();
                HashMap<String, Number> stxMap = new HashMap<String, Number>();
                if (histogram.getTotals()[0] == 0) {
                    stxMap.put(MINIMUM, -999.0);
                    stxMap.put(MAXIMUM, -999.0);
                    stxMap.put(AVERAGE, -999.0);
                    stxMap.put(SIGMA, -999.0);
                    stxMap.put(TOTAL, 0);
                    stxMap.put(MEDIAN, -999.0);
                    for (Object percentile : this.percentiles) {
                        stxMap.put(StatisticsOp.getPercentileName(percentile), -999.0);
                    }
                } else {
                    stxMap.put(MINIMUM, summaryStxOp.getMinimum());
                    stxMap.put(MAXIMUM, summaryStxOp.getMaximum());
                    stxMap.put(AVERAGE, summaryStxOp.getMean());
                    stxMap.put(SIGMA, summaryStxOp.getStandardDeviation());
                    stxMap.put(TOTAL, histogram.getTotals()[0]);
                    stxMap.put(MEDIAN, histogram.getPTileThreshold(0.5)[0]);
                    object = this.percentiles;
                    int n = ((int[])object).length;
                    for (int i = 0; i < n; ++i) {
                        Object percentile;
                        percentile = object[i];
                        stxMap.put(StatisticsOp.getPercentileName(percentile), this.computePercentile((int)percentile, histogram));
                    }
                }
                stxMap.put(MAX_ERROR, Util.getBinWidth(histogram));
                object = this.statisticsOutputters.iterator();
                while (object.hasNext()) {
                    StatisticsOutputter statisticsOutputter = (StatisticsOutputter)object.next();
                    statisticsOutputter.addToOutput(bandName, regionName, stxMap);
                }
            }
        }
        try {
            for (StatisticsOutputter statisticsOutputter : this.statisticsOutputters) {
                statisticsOutputter.finaliseOutput();
            }
        }
        catch (IOException e) {
            throw new OperatorException("Unable to write output.", (Throwable)e);
        }
        finally {
            if (this.metadataOutputStream != null) {
                this.metadataOutputStream.close();
            }
            if (this.csvOutputStream != null) {
                this.csvOutputStream.close();
            }
            if (this.bandMappingOutputStream != null) {
                this.bandMappingOutputStream.close();
            }
        }
        this.getLogger().log(Level.INFO, "Successfully computed statistics.");
    }

    private File[] getProductsToLoad() {
        TreeSet fileSet = new TreeSet();
        if (this.sourceProductPaths != null) {
            for (String filePattern : this.sourceProductPaths) {
                if (filePattern == null) continue;
                try {
                    WildcardMatcher.glob((String)filePattern, fileSet);
                }
                catch (IOException e) {
                    this.logReadProductError(filePattern);
                }
            }
        }
        return fileSet.toArray(new File[fileSet.size()]);
    }

    public static String[] getAlgorithmNames(int[] percentiles) {
        ArrayList<String> algorithms = new ArrayList<String>();
        algorithms.add(MINIMUM);
        algorithms.add(MAXIMUM);
        algorithms.add(MEDIAN);
        algorithms.add(AVERAGE);
        algorithms.add(SIGMA);
        for (int percentile : percentiles) {
            algorithms.add(StatisticsOp.getPercentileName(percentile));
        }
        algorithms.add(MAX_ERROR);
        algorithms.add(TOTAL);
        return algorithms.toArray(new String[algorithms.size()]);
    }

    private static String getPercentileName(int percentile) {
        return PERCENTILE_PREFIX + percentile + PERCENTILE_SUFFIX;
    }

    void setupOutputter() {
        if (this.outputAsciiFile != null) {
            try {
                StringBuilder metadataFileName = new StringBuilder(FileUtils.getFilenameWithoutExtension((File)this.outputAsciiFile));
                metadataFileName.append("_metadata.txt");
                File metadataFile = new File(this.outputAsciiFile.getParent(), metadataFileName.toString());
                this.metadataOutputStream = new PrintStream(new FileOutputStream(metadataFile));
                this.csvOutputStream = new PrintStream(new FileOutputStream(this.outputAsciiFile));
                this.statisticsOutputters.add(new CsvStatisticsWriter(this.csvOutputStream));
                this.statisticsOutputters.add(new MetadataWriter(this.metadataOutputStream));
            }
            catch (FileNotFoundException e) {
                throw new OperatorException((Throwable)e);
            }
        }
        if (this.outputShapefile != null) {
            try {
                String baseName = FileUtils.getFilenameWithoutExtension((File)this.outputShapefile);
                File bandMappingFile = new File(this.outputShapefile.getParent(), baseName + "_band_mapping.txt");
                FileOutputStream bandMappingFOS = new FileOutputStream(bandMappingFile);
                this.bandMappingOutputStream = new PrintStream(bandMappingFOS);
                BandNameCreator bandNameCreator = new BandNameCreator(this.bandMappingOutputStream);
                this.statisticsOutputters.add(FeatureStatisticsWriter.createFeatureStatisticsWriter(this.shapefile.toURI().toURL(), this.outputShapefile.getAbsolutePath(), bandNameCreator));
            }
            catch (MalformedURLException e) {
                throw new OperatorException("Unable to create shapefile outputter: shapefile '" + this.shapefile.getName() + "' is invalid.", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                throw new OperatorException("Unable to create shapefile outputter: maybe shapefile output directory does not exist?", (Throwable)e);
            }
        }
    }

    private Number computePercentile(int percentile, Histogram histogram) {
        return histogram.getPTileThreshold((double)percentile * 0.01)[0];
    }

    static Band getBand(BandConfiguration configuration, Product product) {
        Band band;
        if (configuration.sourceBandName != null) {
            band = product.getBand(configuration.sourceBandName);
            band.setNoDataValueUsed(true);
        } else {
            band = product.addBand(configuration.expression.replace(" ", "_"), configuration.expression, 31);
        }
        if (band == null) {
            throw new OperatorException(MessageFormat.format("Band ''{0}'' does not exist in product ''{1}''.", configuration.sourceBandName, product.getName()));
        }
        return band;
    }

    void validateInput() {
        if (this.startDate != null && this.endDate != null && this.endDate.getAsDate().before(this.startDate.getAsDate())) {
            throw new OperatorException("End date '" + this.endDate + "' before start date '" + this.startDate + "'");
        }
        if (this.accuracy < 0) {
            throw new OperatorException("Parameter 'accuracy' must be greater than or equal to 0");
        }
        if (this.accuracy > 6) {
            throw new OperatorException("Parameter 'accuracy' must be less than or equal to 6");
        }
        if (!(this.sourceProducts != null && this.sourceProducts.length != 0 || this.sourceProductPaths != null && this.sourceProductPaths.length != 0)) {
            throw new OperatorException("Either source products must be given or parameter 'sourceProductPaths' must be specified");
        }
        if (this.bandConfigurations == null) {
            throw new OperatorException("Parameter 'bandConfigurations' must be specified.");
        }
        for (BandConfiguration configuration : this.bandConfigurations) {
            if (configuration.sourceBandName == null && configuration.expression == null) {
                throw new OperatorException("Configuration must contain either a source band name or an expression.");
            }
            if (configuration.sourceBandName == null || configuration.expression == null) continue;
            throw new OperatorException("Configuration must contain either a source band name or an expression.");
        }
        if (this.outputAsciiFile != null && this.outputAsciiFile.isDirectory()) {
            throw new OperatorException("Parameter 'outputAsciiFile' must not point to a directory.");
        }
        if (this.outputShapefile != null) {
            if (this.outputShapefile.isDirectory()) {
                throw new OperatorException("Parameter 'outputShapefile' must point to a file.");
            }
            if (this.shapefile == null) {
                throw new OperatorException("Parameter 'shapefile' must be provided if an output shapefile shall be created.");
            }
        }
        if (this.shapefile != null && this.shapefile.isDirectory()) {
            throw new OperatorException("Parameter 'shapefile' must point to a file.");
        }
        for (int percentile : this.percentiles) {
            if (percentile >= 0 && percentile <= 100) continue;
            throw new OperatorException("Percentile '" + percentile + "' outside of interval [0..100].");
        }
    }

    static boolean isProductAlreadyOpened(List<Product> products, File file) {
        for (Product product : products) {
            if (!product.getFileLocation().getAbsolutePath().equals(file.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    private void logReadProductError(String file) {
        this.getLogger().severe(String.format("Failed to read from '%s' (not a data product or reader missing)", file));
    }

    private void setDummyTargetProduct() {
        Product product = new Product("dummy", "dummy", 2, 2);
        product.addBand("dummy", 10);
        this.setTargetProduct(product);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(StatisticsOp.class);
        }
    }

    public static class UtcConverter
    implements Converter<ProductData.UTC> {
        public ProductData.UTC parse(String text) throws ConversionException {
            try {
                return ProductData.UTC.parse((String)text, (String)StatisticsOp.DATETIME_PATTERN);
            }
            catch (ParseException e) {
                throw new ConversionException((Throwable)e);
            }
        }

        public String format(ProductData.UTC value) {
            if (value != null) {
                return value.format();
            }
            return "";
        }

        public Class<ProductData.UTC> getValueType() {
            return ProductData.UTC.class;
        }
    }
}

