/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.smart.configurator;

import java.awt.Dimension;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.runtime.Config;
import org.esa.snap.runtime.EngineConfig;
import org.esa.snap.smart.configurator.JavaSystemInfos;
import org.esa.snap.smart.configurator.VMParameters;

public class PerformanceParameters {
    public static final String PROPERTY_DEFAULT_TILE_SIZE = "snap.jai.defaultTileSize";
    public static final String PROPERTY_JAI_CACHE_SIZE = "snap.jai.tileCacheSize";
    private VMParameters vmParameters;
    private Path cachePath;
    private int nbThreads;
    private int defaultTileSize;
    private int cacheSize;

    public PerformanceParameters() {
        this.vmParameters = new VMParameters("");
    }

    public PerformanceParameters(PerformanceParameters clone) {
        this.setVMParameters(clone.vmParameters.toString());
        this.setCachePath(clone.getCachePath());
        this.setNbThreads(clone.getNbThreads());
        this.setDefaultTileSize(clone.getDefaultTileSize());
        this.setCacheSize(clone.getCacheSize());
    }

    public void setVmXMX(long vmXMX) {
        this.vmParameters.setVmXMX(vmXMX);
    }

    public void setVmXMS(long vmXMS) {
        this.vmParameters.setVmXMS(vmXMS);
    }

    public long getVmXMX() {
        return this.vmParameters.getVmXMX();
    }

    public Path getCachePath() {
        return this.cachePath;
    }

    public void setCachePath(Path largeTileCache) {
        this.cachePath = largeTileCache;
    }

    public int getNbThreads() {
        return this.nbThreads;
    }

    public void setNbThreads(int nbThreads) {
        this.nbThreads = nbThreads;
    }

    public String getVMParameters() {
        return this.vmParameters.toString();
    }

    public void setVMParameters(String vmParametersLine) {
        this.vmParameters = new VMParameters(vmParametersLine);
    }

    public int getDefaultTileSize() {
        return this.defaultTileSize;
    }

    public void setDefaultTileSize(int defaultTileSize) {
        this.defaultTileSize = defaultTileSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    static synchronized PerformanceParameters loadConfiguration() {
        Config configuration = Config.instance().load();
        Preferences preferences = configuration.preferences();
        PerformanceParameters actualParameters = new PerformanceParameters();
        VMParameters netBeansVmParameters = VMParameters.load();
        actualParameters.setVMParameters(netBeansVmParameters.toString());
        actualParameters.setCachePath(SystemUtils.getCacheDir().toPath());
        int defaultNbThreads = JavaSystemInfos.getInstance().getNbCPUs();
        actualParameters.setNbThreads(preferences.getInt(SystemUtils.SNAP_PARALLELISM_PROPERTY_NAME, defaultNbThreads));
        actualParameters.setDefaultTileSize(preferences.getInt(PROPERTY_DEFAULT_TILE_SIZE, 0));
        actualParameters.setCacheSize(preferences.getInt(PROPERTY_JAI_CACHE_SIZE, 0));
        return actualParameters;
    }

    static synchronized void saveConfiguration(PerformanceParameters confToSave) throws IOException, BackingStoreException {
        if (!PerformanceParameters.loadConfiguration().getVMParameters().equals(confToSave.getVMParameters())) {
            confToSave.vmParameters.save();
        }
        EngineConfig configuration = EngineConfig.instance().load();
        Preferences preferences = configuration.preferences();
        Path cachePath = confToSave.getCachePath();
        if (!Files.exists(cachePath, new LinkOption[0])) {
            Files.createDirectories(cachePath, new FileAttribute[0]);
        }
        if (Files.exists(cachePath, new LinkOption[0])) {
            preferences.put(SystemUtils.SNAP_CACHE_DIR_PROPERTY_NAME, cachePath.toAbsolutePath().toString());
        } else {
            SystemUtils.LOG.severe("Directory for cache path does not exist");
        }
        int parallelism = confToSave.getNbThreads();
        int defaultTileSize = confToSave.getDefaultTileSize();
        int jaiCacheSize = confToSave.getCacheSize();
        preferences.putInt(SystemUtils.SNAP_PARALLELISM_PROPERTY_NAME, parallelism);
        preferences.putInt(PROPERTY_DEFAULT_TILE_SIZE, defaultTileSize);
        preferences.putInt(PROPERTY_JAI_CACHE_SIZE, jaiCacheSize);
        preferences.flush();
        TileCache thisTileCache = JAI.createTileCache();
        JAI.getDefaultInstance().setTileCache(thisTileCache);
        JAI.getDefaultInstance().getTileScheduler().setParallelism(parallelism);
        JAI.setDefaultTileSize((Dimension)new Dimension(defaultTileSize, defaultTileSize));
    }
}

