/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.smart.configurator;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.prefs.BackingStoreException;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.smart.configurator.DiskBenchmarker;
import org.esa.snap.smart.configurator.JavaSystemInfos;
import org.esa.snap.smart.configurator.PerformanceParameters;
import org.esa.snap.smart.configurator.SystemInfos;

public class ConfigurationOptimizer {
    private static ConfigurationOptimizer configurationOptimizer = null;
    private static long DEFAULT_MIN_XMS = 2048L;
    private static long MIN_FREE_TMP_DISK_SPACE = 512L;
    private static long MIN_FREE_LARGE_CACHE_DISK_SPACE = 1024L;
    private static int DISK_MIN_SPEED_INCREASE = 20;
    SystemInfos sysInfos = JavaSystemInfos.getInstance();
    private PerformanceParameters actualPerformanceParameters = null;
    private PerformanceParameters custommisedPerformanceParameters = null;

    private ConfigurationOptimizer() {
    }

    public static ConfigurationOptimizer getInstance() {
        if (configurationOptimizer == null) {
            configurationOptimizer = new ConfigurationOptimizer();
        }
        return configurationOptimizer;
    }

    public PerformanceParameters getActualPerformanceParameters() {
        if (this.actualPerformanceParameters == null) {
            this.actualPerformanceParameters = PerformanceParameters.loadConfiguration();
        }
        return this.actualPerformanceParameters;
    }

    public PerformanceParameters computeOptimisedSystemParameters() {
        PerformanceParameters optimisedPerformanceParameters = new PerformanceParameters(this.actualPerformanceParameters);
        this.computeOptimisedRAMParams(optimisedPerformanceParameters);
        this.computeOptimisedPathParams(optimisedPerformanceParameters);
        return optimisedPerformanceParameters;
    }

    public void updateCustomisedParameters(PerformanceParameters updatedParams) {
        this.custommisedPerformanceParameters = updatedParams;
    }

    public void saveCustomisedParameters() throws IOException, BackingStoreException {
        PerformanceParameters.saveConfiguration(this.custommisedPerformanceParameters);
        this.actualPerformanceParameters = new PerformanceParameters(this.custommisedPerformanceParameters);
    }

    public void computeOptimisedRAMParams(PerformanceParameters performanceParameters) {
        long freeRAM = this.sysInfos.getFreeRAM();
        long reservedRAM = this.sysInfos.getReservedRam();
        long optimisedJVMMem = reservedRAM + freeRAM;
        performanceParameters.setVmXMX(optimisedJVMMem);
        if (optimisedJVMMem > DEFAULT_MIN_XMS) {
            performanceParameters.setVmXMS(DEFAULT_MIN_XMS);
        } else {
            performanceParameters.setVmXMS(optimisedJVMMem);
        }
    }

    private void computeOptimisedPathParams(PerformanceParameters performanceParameters) {
        String[] disks = this.sysInfos.getDisksNames();
        double fastestForTmpSpeed = 0.0;
        Path fastestForUserDir = null;
        double fastestForUserDirSpeed = 0.0;
        for (String diskName : disks) {
            try {
                double writeSpeed = this.sysInfos.getDiskWriteSpeed(diskName);
                if (writeSpeed > fastestForTmpSpeed && this.sysInfos.getDiskFreeSize(diskName) > MIN_FREE_TMP_DISK_SPACE) {
                    fastestForTmpSpeed = writeSpeed;
                }
                if (!(writeSpeed > fastestForUserDirSpeed) || this.sysInfos.getDiskFreeSize(diskName) <= MIN_FREE_LARGE_CACHE_DISK_SPACE) continue;
                fastestForUserDirSpeed = writeSpeed;
                File diskNameAsFile = new File(diskName);
                fastestForUserDir = FileUtils.getPathFromURI((URI)diskNameAsFile.toURI()).resolve("cache");
            }
            catch (IOException e) {
                SystemUtils.LOG.warning("Could not perform bechmark for disk: " + diskName);
            }
        }
        if (fastestForUserDir != null) {
            Path actualCache = this.actualPerformanceParameters.getCachePath();
            try {
                String actualLargeCacheDir;
                DiskBenchmarker benchmarker;
                double userDirWriteSpeed;
                double minSpeedToChange;
                if (!Files.exists(actualCache, new LinkOption[0])) {
                    Files.createDirectories(actualCache, new FileAttribute[0]);
                }
                if ((minSpeedToChange = (userDirWriteSpeed = (benchmarker = new DiskBenchmarker(actualLargeCacheDir = actualCache.toString())).getWriteSpeed()) * (double)(1.0f + (float)DISK_MIN_SPEED_INCREASE / 100.0f)) < fastestForUserDirSpeed) {
                    performanceParameters.setCachePath(fastestForUserDir);
                }
            }
            catch (IOException e) {
                performanceParameters.setCachePath(fastestForUserDir);
                SystemUtils.LOG.warning("Could not check performance of large cache dir: " + this.actualPerformanceParameters.getCachePath() + " error: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

