/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.smart.configurator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.BackingStoreException;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.smart.configurator.BenchmarkSingleCalculus;
import org.esa.snap.smart.configurator.ConfigurationOptimizer;
import org.esa.snap.smart.configurator.PerformanceParameters;

public class Benchmark {
    private List<BenchmarkSingleCalculus> benchmarkCalculus;

    public Benchmark(List<Integer> tileSizes, List<Integer> cacheSizes, List<Integer> nbThreads) {
        if (tileSizes.isEmpty() || cacheSizes.isEmpty() || nbThreads.isEmpty()) {
            throw new IllegalArgumentException("All benchmark parameters need to be filled");
        }
        this.benchmarkCalculus = new ArrayList<BenchmarkSingleCalculus>();
        this.benchmarkCalculus.add(new BenchmarkSingleCalculus(tileSizes.get(0), cacheSizes.get(0), nbThreads.get(0)));
        for (Integer tileSize : tileSizes) {
            for (Integer cacheSize : cacheSizes) {
                for (Integer nbThread : nbThreads) {
                    this.benchmarkCalculus.add(new BenchmarkSingleCalculus(tileSize, cacheSize, nbThread));
                }
            }
        }
    }

    public BenchmarkSingleCalculus getFasterBenchmarkSingleCalculus() {
        Collections.sort(this.benchmarkCalculus);
        return this.benchmarkCalculus.get(0);
    }

    public void loadBenchmarkPerfParams(BenchmarkSingleCalculus benchmarkSingleCalculus) {
        ConfigurationOptimizer confOptimizer = ConfigurationOptimizer.getInstance();
        PerformanceParameters benchmarkPerformanceParameters = confOptimizer.getActualPerformanceParameters();
        benchmarkPerformanceParameters.setDefaultTileSize(benchmarkSingleCalculus.getTileSize());
        benchmarkPerformanceParameters.setCacheSize(benchmarkSingleCalculus.getCacheSize());
        benchmarkPerformanceParameters.setNbThreads(benchmarkSingleCalculus.getNbThreads());
        confOptimizer.updateCustomisedParameters(benchmarkPerformanceParameters);
        try {
            confOptimizer.saveCustomisedParameters();
        }
        catch (IOException | BackingStoreException e) {
            SystemUtils.LOG.severe("Could not save performance parameters: " + e.getMessage());
        }
    }

    public String toString() {
        String benchmarksPrint = "Benchmark results sorted by execution time\n";
        benchmarksPrint = benchmarksPrint + "(Tile size, Cache size, Nb threads) = Execution time \n\n";
        for (BenchmarkSingleCalculus benchmarkSingleCalcul : this.benchmarkCalculus) {
            benchmarksPrint = benchmarksPrint + benchmarkSingleCalcul.toString() + "\n";
        }
        return benchmarksPrint;
    }

    public List<BenchmarkSingleCalculus> getBenchmarkCalculus() {
        return this.benchmarkCalculus;
    }

    public void addBenchmarkCalcul(BenchmarkSingleCalculus benchmarkSingleCalcul) {
        this.benchmarkCalculus.add(benchmarkSingleCalcul);
    }
}

