/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.util.ByteArrayCodec;
import java.nio.ByteOrder;

abstract class DataAccessor {
    protected final ByteArrayCodec codec;

    protected DataAccessor(ByteOrder byteOrder) {
        this.codec = ByteArrayCodec.getInstance(byteOrder);
    }

    public final ByteOrder getByteOrder() {
        return this.codec.getByteOrder();
    }

    public abstract byte getByte(byte[] var1, int var2);

    public abstract short getShort(byte[] var1, int var2);

    public abstract int getInt(byte[] var1, int var2);

    public abstract long getLong(byte[] var1, int var2);

    public abstract float getFloat(byte[] var1, int var2);

    public abstract double getDouble(byte[] var1, int var2);

    public abstract void setByte(byte[] var1, int var2, byte var3);

    public abstract void setShort(byte[] var1, int var2, short var3);

    public abstract void setInt(byte[] var1, int var2, int var3);

    public abstract void setLong(byte[] var1, int var2, long var3);

    public abstract void setFloat(byte[] var1, int var2, float var3);

    public abstract void setDouble(byte[] var1, int var2, double var3);

    public static DataAccessor getInstance(Type type, ByteOrder byteOrder) {
        if (type == SimpleType.BYTE) {
            return new Byte(byteOrder);
        }
        if (type == SimpleType.UBYTE) {
            return new UByte(byteOrder);
        }
        if (type == SimpleType.SHORT) {
            return new Short(byteOrder);
        }
        if (type == SimpleType.USHORT) {
            return new UShort(byteOrder);
        }
        if (type == SimpleType.INT) {
            return new Int(byteOrder);
        }
        if (type == SimpleType.UINT) {
            return new UInt(byteOrder);
        }
        if (type == SimpleType.LONG) {
            return new Long(byteOrder);
        }
        if (type == SimpleType.ULONG) {
            return new Long(byteOrder);
        }
        if (type == SimpleType.FLOAT) {
            return new Float(byteOrder);
        }
        if (type == SimpleType.DOUBLE) {
            return new Double(byteOrder);
        }
        throw new IllegalArgumentException("type: DataAccessor not implemented for " + type);
    }

    static final class Double
    extends DataAccessor {
        Double(ByteOrder byteOrder) {
            super(byteOrder);
        }

        @Override
        public byte getByte(byte[] array, int position) {
            return (byte)this.getDouble(array, position);
        }

        @Override
        public short getShort(byte[] array, int position) {
            return (short)this.getDouble(array, position);
        }

        @Override
        public int getInt(byte[] array, int position) {
            return (int)this.getDouble(array, position);
        }

        @Override
        public long getLong(byte[] array, int position) {
            return (long)this.getDouble(array, position);
        }

        @Override
        public float getFloat(byte[] array, int position) {
            return (float)this.getDouble(array, position);
        }

        @Override
        public double getDouble(byte[] array, int position) {
            return this.codec.getDouble(array, position);
        }

        @Override
        public void setByte(byte[] array, int position, byte value) {
            this.setDouble(array, position, value);
        }

        @Override
        public void setShort(byte[] array, int position, short value) {
            this.setDouble(array, position, value);
        }

        @Override
        public void setInt(byte[] array, int position, int value) {
            this.setDouble(array, position, value);
        }

        @Override
        public void setLong(byte[] array, int position, long value) {
            this.setDouble(array, position, value);
        }

        @Override
        public void setFloat(byte[] array, int position, float value) {
            this.setDouble(array, position, value);
        }

        @Override
        public void setDouble(byte[] array, int position, double value) {
            this.codec.setDouble(array, position, value);
        }
    }

    static final class Float
    extends DataAccessor {
        Float(ByteOrder byteOrder) {
            super(byteOrder);
        }

        @Override
        public byte getByte(byte[] array, int position) {
            return (byte)this.getFloat(array, position);
        }

        @Override
        public short getShort(byte[] array, int position) {
            return (short)this.getFloat(array, position);
        }

        @Override
        public int getInt(byte[] array, int position) {
            return (int)this.getFloat(array, position);
        }

        @Override
        public long getLong(byte[] array, int position) {
            return (long)this.getFloat(array, position);
        }

        @Override
        public float getFloat(byte[] array, int position) {
            return this.codec.getFloat(array, position);
        }

        @Override
        public double getDouble(byte[] array, int position) {
            return this.getFloat(array, position);
        }

        @Override
        public void setByte(byte[] array, int position, byte value) {
            this.setFloat(array, position, value);
        }

        @Override
        public void setShort(byte[] array, int position, short value) {
            this.setFloat(array, position, value);
        }

        @Override
        public void setInt(byte[] array, int position, int value) {
            this.setFloat(array, position, value);
        }

        @Override
        public void setLong(byte[] array, int position, long value) {
            this.setFloat(array, position, value);
        }

        @Override
        public void setFloat(byte[] array, int position, float value) {
            this.codec.setFloat(array, position, value);
        }

        @Override
        public void setDouble(byte[] array, int position, double value) {
            this.setFloat(array, position, (float)value);
        }
    }

    static final class Long
    extends DataAccessor {
        Long(ByteOrder byteOrder) {
            super(byteOrder);
        }

        @Override
        public byte getByte(byte[] array, int position) {
            return (byte)this.getLong(array, position);
        }

        @Override
        public short getShort(byte[] array, int position) {
            return (short)this.getLong(array, position);
        }

        @Override
        public int getInt(byte[] array, int position) {
            return (int)this.getLong(array, position);
        }

        @Override
        public long getLong(byte[] array, int position) {
            return this.codec.getLong(array, position);
        }

        @Override
        public float getFloat(byte[] array, int position) {
            return this.getLong(array, position);
        }

        @Override
        public double getDouble(byte[] array, int position) {
            return this.getLong(array, position);
        }

        @Override
        public void setByte(byte[] array, int position, byte value) {
            this.setLong(array, position, value);
        }

        @Override
        public void setShort(byte[] array, int position, short value) {
            this.setLong(array, position, value);
        }

        @Override
        public void setInt(byte[] array, int position, int value) {
            this.setLong(array, position, value);
        }

        @Override
        public void setLong(byte[] array, int position, long value) {
            this.codec.setLong(array, position, value);
        }

        @Override
        public void setFloat(byte[] array, int position, float value) {
            this.setLong(array, position, (long)value);
        }

        @Override
        public void setDouble(byte[] array, int position, double value) {
            this.setLong(array, position, (long)value);
        }
    }

    static final class UInt
    extends DataAccessor {
        UInt(ByteOrder byteOrder) {
            super(byteOrder);
        }

        @Override
        public byte getByte(byte[] array, int position) {
            return (byte)this.getLong(array, position);
        }

        @Override
        public short getShort(byte[] array, int position) {
            return (short)this.getLong(array, position);
        }

        @Override
        public int getInt(byte[] array, int position) {
            return this.codec.getInt(array, position);
        }

        @Override
        public long getLong(byte[] array, int position) {
            return (long)this.getInt(array, position) & 0xFFFFFFFFL;
        }

        @Override
        public float getFloat(byte[] array, int position) {
            return this.getLong(array, position);
        }

        @Override
        public double getDouble(byte[] array, int position) {
            return this.getLong(array, position);
        }

        @Override
        public void setByte(byte[] array, int position, byte value) {
            this.setInt(array, position, value);
        }

        @Override
        public void setShort(byte[] array, int position, short value) {
            this.setInt(array, position, value);
        }

        @Override
        public void setInt(byte[] array, int position, int value) {
            this.codec.setInt(array, position, value);
        }

        @Override
        public void setLong(byte[] array, int position, long value) {
            this.setInt(array, position, (int)value);
        }

        @Override
        public void setFloat(byte[] array, int position, float value) {
            this.setInt(array, position, (int)value);
        }

        @Override
        public void setDouble(byte[] array, int position, double value) {
            this.setInt(array, position, (int)value);
        }
    }

    static final class Int
    extends DataAccessor {
        Int(ByteOrder byteOrder) {
            super(byteOrder);
        }

        @Override
        public byte getByte(byte[] array, int position) {
            return (byte)this.getInt(array, position);
        }

        @Override
        public short getShort(byte[] array, int position) {
            return (short)this.getInt(array, position);
        }

        @Override
        public int getInt(byte[] array, int position) {
            return this.codec.getInt(array, position);
        }

        @Override
        public long getLong(byte[] array, int position) {
            return this.getInt(array, position);
        }

        @Override
        public float getFloat(byte[] array, int position) {
            return this.getInt(array, position);
        }

        @Override
        public double getDouble(byte[] array, int position) {
            return this.getInt(array, position);
        }

        @Override
        public void setByte(byte[] array, int position, byte value) {
            this.setInt(array, position, value);
        }

        @Override
        public void setShort(byte[] array, int position, short value) {
            this.setInt(array, position, value);
        }

        @Override
        public void setInt(byte[] array, int position, int value) {
            this.codec.setInt(array, position, value);
        }

        @Override
        public void setLong(byte[] array, int position, long value) {
            this.setInt(array, position, (int)value);
        }

        @Override
        public void setFloat(byte[] array, int position, float value) {
            this.setInt(array, position, (int)value);
        }

        @Override
        public void setDouble(byte[] array, int position, double value) {
            this.setInt(array, position, (int)value);
        }
    }

    static final class UShort
    extends DataAccessor {
        UShort(ByteOrder byteOrder) {
            super(byteOrder);
        }

        @Override
        public byte getByte(byte[] array, int position) {
            return (byte)this.getInt(array, position);
        }

        @Override
        public short getShort(byte[] array, int position) {
            return this.codec.getShort(array, position);
        }

        @Override
        public int getInt(byte[] array, int position) {
            return this.getShort(array, position) & 0xFFFF;
        }

        @Override
        public long getLong(byte[] array, int position) {
            return this.getInt(array, position);
        }

        @Override
        public float getFloat(byte[] array, int position) {
            return this.getInt(array, position);
        }

        @Override
        public double getDouble(byte[] array, int position) {
            return this.getInt(array, position);
        }

        @Override
        public void setByte(byte[] array, int position, byte value) {
            this.setShort(array, position, value);
        }

        @Override
        public void setShort(byte[] array, int position, short value) {
            this.codec.setShort(array, position, value);
        }

        @Override
        public void setInt(byte[] array, int position, int value) {
            this.setShort(array, position, (short)value);
        }

        @Override
        public void setLong(byte[] array, int position, long value) {
            this.setShort(array, position, (short)value);
        }

        @Override
        public void setFloat(byte[] array, int position, float value) {
            this.setShort(array, position, (short)value);
        }

        @Override
        public void setDouble(byte[] array, int position, double value) {
            this.setShort(array, position, (short)value);
        }
    }

    static final class Short
    extends DataAccessor {
        Short(ByteOrder byteOrder) {
            super(byteOrder);
        }

        @Override
        public byte getByte(byte[] array, int position) {
            return (byte)this.getShort(array, position);
        }

        @Override
        public short getShort(byte[] array, int position) {
            return this.codec.getShort(array, position);
        }

        @Override
        public int getInt(byte[] array, int position) {
            return this.getShort(array, position);
        }

        @Override
        public long getLong(byte[] array, int position) {
            return this.getShort(array, position);
        }

        @Override
        public float getFloat(byte[] array, int position) {
            return this.getShort(array, position);
        }

        @Override
        public double getDouble(byte[] array, int position) {
            return this.getShort(array, position);
        }

        @Override
        public void setByte(byte[] array, int position, byte value) {
            this.setShort(array, position, value);
        }

        @Override
        public void setShort(byte[] array, int position, short value) {
            this.codec.setShort(array, position, value);
        }

        @Override
        public void setInt(byte[] array, int position, int value) {
            this.setShort(array, position, (short)value);
        }

        @Override
        public void setLong(byte[] array, int position, long value) {
            this.setShort(array, position, (short)value);
        }

        @Override
        public void setFloat(byte[] array, int position, float value) {
            this.setShort(array, position, (short)value);
        }

        @Override
        public void setDouble(byte[] array, int position, double value) {
            this.setShort(array, position, (short)value);
        }
    }

    static final class UByte
    extends DataAccessor {
        UByte(ByteOrder byteOrder) {
            super(byteOrder);
        }

        @Override
        public byte getByte(byte[] array, int position) {
            return array[position];
        }

        @Override
        public short getShort(byte[] array, int position) {
            return (short)this.getInt(array, position);
        }

        @Override
        public int getInt(byte[] array, int position) {
            return this.getByte(array, position) & 0xFF;
        }

        @Override
        public long getLong(byte[] array, int position) {
            return this.getInt(array, position);
        }

        @Override
        public float getFloat(byte[] array, int position) {
            return this.getInt(array, position);
        }

        @Override
        public double getDouble(byte[] array, int position) {
            return this.getInt(array, position);
        }

        @Override
        public void setByte(byte[] array, int position, byte value) {
            array[position] = value;
        }

        @Override
        public void setShort(byte[] array, int position, short value) {
            this.setByte(array, position, (byte)value);
        }

        @Override
        public void setInt(byte[] array, int position, int value) {
            this.setByte(array, position, (byte)value);
        }

        @Override
        public void setLong(byte[] array, int position, long value) {
            this.setByte(array, position, (byte)value);
        }

        @Override
        public void setFloat(byte[] array, int position, float value) {
            this.setByte(array, position, (byte)value);
        }

        @Override
        public void setDouble(byte[] array, int position, double value) {
            this.setByte(array, position, (byte)value);
        }
    }

    static final class Byte
    extends DataAccessor {
        Byte(ByteOrder byteOrder) {
            super(byteOrder);
        }

        @Override
        public byte getByte(byte[] array, int position) {
            return array[position];
        }

        @Override
        public short getShort(byte[] array, int position) {
            return this.getByte(array, position);
        }

        @Override
        public int getInt(byte[] array, int position) {
            return this.getByte(array, position);
        }

        @Override
        public long getLong(byte[] array, int position) {
            return this.getByte(array, position);
        }

        @Override
        public float getFloat(byte[] array, int position) {
            return this.getByte(array, position);
        }

        @Override
        public double getDouble(byte[] array, int position) {
            return this.getByte(array, position);
        }

        @Override
        public void setByte(byte[] array, int position, byte value) {
            array[position] = value;
        }

        @Override
        public void setShort(byte[] array, int position, short value) {
            this.setByte(array, position, (byte)value);
        }

        @Override
        public void setInt(byte[] array, int position, int value) {
            this.setByte(array, position, (byte)value);
        }

        @Override
        public void setLong(byte[] array, int position, long value) {
            this.setByte(array, position, (byte)value);
        }

        @Override
        public void setFloat(byte[] array, int position, float value) {
            this.setByte(array, position, (byte)value);
        }

        @Override
        public void setDouble(byte[] array, int position, double value) {
            this.setByte(array, position, (byte)value);
        }
    }
}

