/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.expr;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.expr.AbstractExpression;
import com.bc.ceres.binio.expr.Expression;
import java.io.IOException;
import java.util.ArrayList;

public class SelectionExpr
extends AbstractExpression {
    private final Expression condition;
    private final Case[] cases;
    private final Expression defaultExpression;

    public SelectionExpr(Expression condition, Case[] cases) {
        Expression defaultExpression = null;
        ArrayList<Case> caseList = new ArrayList<Case>(cases.length);
        for (Case aCase : cases) {
            if (aCase instanceof Default) {
                defaultExpression = aCase.expression;
                continue;
            }
            caseList.add(aCase);
        }
        if (defaultExpression == null) {
            throw new IllegalArgumentException("cases");
        }
        this.condition = condition;
        this.condition.setParent(this);
        this.cases = caseList.toArray(new Case[caseList.size()]);
        for (Case aCase : this.cases) {
            aCase.expression.setParent(this);
        }
        this.defaultExpression = defaultExpression;
        this.defaultExpression.setParent(this);
    }

    @Override
    public boolean isConstant() {
        if (!this.condition.isConstant()) {
            return false;
        }
        for (Case member : this.cases) {
            if (member.expression.isConstant()) continue;
            return false;
        }
        return this.defaultExpression.isConstant();
    }

    @Override
    public Object evaluate(CompoundData context) throws IOException {
        Object result = this.condition.evaluate(context);
        for (Case c : this.cases) {
            if (!result.equals(c.value)) continue;
            return c.expression.evaluate(context);
        }
        return this.defaultExpression.evaluate(context);
    }

    public static class Default
    extends Case {
        public Default(Expression expression) {
            super(null, expression);
        }
    }

    public static class Case {
        private final Object value;
        private final Expression expression;

        public Case(Object value, Expression expression) {
            this.value = value;
            this.expression = expression;
        }
    }
}

