/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.utils;

import net.sf.javaml.core.Complex;

public class MathUtils {
    private static final double epsilon = 1.0E-6;

    public static boolean zero(double a) {
        return Math.abs(a) < 1.0E-6;
    }

    public static boolean eq(Complex a, Complex b) {
        return MathUtils.eq(a.re, b.re) && MathUtils.eq(a.im, b.im);
    }

    public static boolean eq(double a, double b) {
        return a - b < 1.0E-6 && b - a < 1.0E-6 || Double.isNaN(a) && Double.isNaN(b);
    }

    public static boolean le(double a, double b) {
        return a - b < 1.0E-6;
    }

    public static boolean ge(double a, double b) {
        return b - a < 1.0E-6;
    }

    public static boolean lt(double a, double b) {
        return b - a > 1.0E-6;
    }

    public static boolean gt(double a, double b) {
        return a - b > 1.0E-6;
    }

    public static boolean eq(double[] me1, double[] me2) {
        if (me1.length != me2.length) {
            return false;
        }
        for (int i = 0; i < me1.length; ++i) {
            if (MathUtils.eq(me1[i], me2[i])) continue;
            return false;
        }
        return true;
    }

    public static double min(double[] array) {
        double min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] < min)) continue;
            min = array[i];
        }
        return min;
    }

    public static double log2(double n) {
        return Math.log(n) / Math.log(2.0);
    }

    public static double harmonicMean(double[] g) {
        double sum = 0.0;
        for (double d : g) {
            sum += 1.0 / d;
        }
        return (double)g.length / sum;
    }

    public static double arithmicMean(double[] g) {
        double sum = 0.0;
        for (double d : g) {
            sum += d;
        }
        return sum / (double)g.length;
    }
}

