/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering.mcl;

import java.util.Vector;
import net.sf.javaml.clustering.mcl.DoubleFormat;

public class Vectors {
    public static int ndigits = 0;
    public static int colwidth = 0;

    public static int[] range(int start, int end, int step) {
        int[] out = new int[(int)Math.floor((end - start) / step) + 1];
        for (int i = 0; i < out.length; ++i) {
            out[i] = start + step * i;
        }
        return out;
    }

    public static int[] range(int start, int end) {
        return Vectors.range(start, end, end - start > 0 ? 1 : -1);
    }

    public static double[] range(double start, double end, double step) {
        double[] out = new double[(int)Math.floor((end - start) / step) + 1];
        for (int i = 0; i < out.length; ++i) {
            out[i] = start + step * (double)i;
        }
        return out;
    }

    public static double[] range(double start, double end) {
        return Vectors.range(start, end, end - start > 0.0 ? 1.0 : -1.0);
    }

    public static double sum(double[] vec) {
        double sum = 0.0;
        for (int i = 0; i < vec.length; ++i) {
            sum += vec[i];
        }
        return sum;
    }

    public static int sum(int[] vec) {
        int sum = 0;
        for (int i = 0; i < vec.length; ++i) {
            sum += vec[i];
        }
        return sum;
    }

    public static double[] cumsum(double[] vec) {
        double[] x = new double[vec.length];
        x[0] = vec[0];
        for (int i = 1; i < vec.length; ++i) {
            x[i] = vec[i] + x[i - 1];
        }
        return x;
    }

    public static int max(int[] vec) {
        int max = vec[0];
        for (int i = 1; i < vec.length; ++i) {
            if (vec[i] <= max) continue;
            max = vec[i];
        }
        return max;
    }

    public static double max(double[] vec) {
        double max = vec[0];
        for (int i = 1; i < vec.length; ++i) {
            if (!(vec[i] > max)) continue;
            max = vec[i];
        }
        return max;
    }

    public static int min(int[] vec) {
        int min = vec[0];
        for (int i = 1; i < vec.length; ++i) {
            if (vec[i] >= min) continue;
            min = vec[i];
        }
        return min;
    }

    public static double min(double[] vec) {
        double min = vec[0];
        for (int i = 1; i < vec.length; ++i) {
            if (!(vec[i] < min)) continue;
            min = vec[i];
        }
        return min;
    }

    public static double[] concat(double[] x, double[] y) {
        double[] z = new double[x.length + y.length];
        System.arraycopy(x, 0, z, 0, x.length);
        System.arraycopy(y, 0, z, x.length, y.length);
        return z;
    }

    public static double[] concat(double[] x, double[] y, double[] z) {
        double[] w = new double[x.length + y.length + z.length];
        System.arraycopy(x, 0, w, 0, x.length);
        System.arraycopy(y, 0, w, x.length, y.length);
        System.arraycopy(y, 0, w, x.length + y.length, z.length);
        return w;
    }

    public static double[] increaseSize(double[] vector, int moreelements) {
        double[] longer = new double[vector.length + moreelements];
        System.arraycopy(vector, 0, longer, 0, vector.length);
        return longer;
    }

    public static double[][] increaseSize(double[][] matrix, int morerows, int morecols) {
        int i;
        double[][] array2 = new double[matrix.length + morerows][];
        for (i = 0; i < matrix.length; ++i) {
            array2[i] = morecols > 0 ? Vectors.increaseSize(matrix[i], morecols) : matrix[i];
        }
        for (i = matrix.length; i < array2.length; ++i) {
            array2[i] = new double[matrix[0].length + morecols];
        }
        return array2;
    }

    public static double[] removeElement(double[] vector, int element) {
        double[] shorter = new double[vector.length - 1];
        System.arraycopy(vector, 0, shorter, 0, element);
        System.arraycopy(vector, element + 1, shorter, element, vector.length - element - 1);
        return shorter;
    }

    public static double[][] removeElements(double[][] matrix, int[] rows, int[] cols) {
        return Vectors.chooseElements(matrix, Vectors.rangeComplement(rows, matrix.length), Vectors.rangeComplement(cols, matrix[0].length));
    }

    public static double[] removeElements(double[] vector, int[] elements) {
        return Vectors.chooseElements(vector, Vectors.rangeComplement(elements, vector.length));
    }

    public static int[] rangeComplement(int[] set, int length) {
        int[] complement = new int[length - set.length];
        int sindex = 0;
        int cindex = 0;
        for (int i = 0; i < length; ++i) {
            if (sindex >= set.length || set[sindex] != i) {
                complement[cindex] = i;
                ++cindex;
                continue;
            }
            ++sindex;
        }
        return complement;
    }

    public static double[][] chooseElements(double[][] matrix, int[] rows, int[] cols) {
        double[][] matrix2 = new double[rows.length][cols.length];
        for (int i = 0; i < rows.length; ++i) {
            matrix2[i] = Vectors.chooseElements(matrix[rows[i]], cols);
        }
        return matrix2;
    }

    public static double[] chooseElements(double[] vector, int[] keep) {
        double[] vector2 = new double[keep.length];
        for (int i = 0; i < keep.length; ++i) {
            vector2[i] = vector[keep[i]];
        }
        return vector2;
    }

    public static int[] increaseSize(int[] vector, int moreelements) {
        int[] longer = new int[vector.length + moreelements];
        System.arraycopy(vector, 0, longer, 0, vector.length);
        return longer;
    }

    public static int[][] increaseSize(int[][] matrix, int morerows, int morecols) {
        int i;
        int[][] array2 = new int[matrix.length + morerows][];
        for (i = 0; i < matrix.length; ++i) {
            array2[i] = morecols > 0 ? Vectors.increaseSize(matrix[i], morecols) : matrix[i];
        }
        for (i = matrix.length; i < array2.length; ++i) {
            array2[i] = new int[matrix[0].length + morecols];
        }
        return array2;
    }

    public static int[] removeElement(int[] vector, int element) {
        int[] shorter = new int[vector.length - 1];
        System.arraycopy(vector, 0, shorter, 0, element);
        System.arraycopy(vector, element + 1, shorter, element, vector.length - element - 1);
        return shorter;
    }

    public static int[][] removeElements(int[][] matrix, int[] rows, int[] cols) {
        return Vectors.chooseElements(matrix, Vectors.rangeComplement(rows, matrix.length), Vectors.rangeComplement(cols, matrix[0].length));
    }

    public static int[] removeElements(int[] vector, int[] elements) {
        return Vectors.chooseElements(vector, Vectors.rangeComplement(elements, vector.length));
    }

    public static int[][] chooseElements(int[][] matrix, int[] rows, int[] cols) {
        int[][] matrix2 = new int[rows.length][cols.length];
        for (int i = 0; i < rows.length; ++i) {
            matrix2[i] = Vectors.chooseElements(matrix[rows[i]], cols);
        }
        return matrix2;
    }

    public static int[] chooseElements(int[] vector, int[] keep) {
        int[] vector2 = new int[keep.length];
        for (int i = 0; i < keep.length; ++i) {
            vector2[i] = vector[keep[i]];
        }
        return vector2;
    }

    public static String print(double[] x) {
        if (x == null) {
            return "null";
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < x.length - 1; ++i) {
            b.append(Vectors.format(x[i])).append(" ");
        }
        b.append(Vectors.format(x[x.length - 1]));
        return b.toString();
    }

    private static String format(double x) {
        if (ndigits > 0) {
            return DoubleFormat.format(x, ndigits, colwidth);
        }
        return Double.toString(x);
    }

    public static String print(double[][] x) {
        if (x == null) {
            return "null";
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < x.length - 1; ++i) {
            b.append(Vectors.print(x[i])).append("\n");
        }
        b.append(Vectors.print(x[x.length - 1]));
        return b.toString();
    }

    public static String print(int[] x) {
        if (x == null) {
            return "null";
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < x.length - 1; ++i) {
            b.append(x[i]).append(" ");
        }
        b.append(x[x.length - 1]);
        return b.toString();
    }

    public static String print(int[][] x) {
        if (x == null) {
            return "null";
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < x.length - 1; ++i) {
            b.append(Vectors.print(x[i])).append("\n");
        }
        b.append(Vectors.print(x[x.length - 1]));
        return b.toString();
    }

    public static double[] ones(int len, double factor) {
        double[] x = new double[len];
        for (int i = 0; i < x.length; ++i) {
            x[i] = 1.0;
        }
        return x;
    }

    public static int[] ones(int len, int factor) {
        int[] x = new int[len];
        for (int i = 0; i < x.length; ++i) {
            x[i] = factor;
        }
        return x;
    }

    public static double[] zeros(int len) {
        return new double[len];
    }

    public static int[] ones(int len) {
        return Vectors.ones(len, 1);
    }

    public static int[] cast(double[] vec) {
        int[] ivec = new int[vec.length];
        for (int i = 0; i < ivec.length; ++i) {
            ivec[i] = (int)vec[i];
        }
        return ivec;
    }

    public static double[] cast(int[] vec) {
        double[] dvec = new double[vec.length];
        for (int i = 0; i < dvec.length; ++i) {
            dvec[i] = vec[i];
        }
        return dvec;
    }

    public static int[] find(int[] vec, int val) {
        Vector<Integer> v = new Vector<Integer>();
        for (int i = 0; i < vec.length; ++i) {
            if (vec[i] != val) continue;
            v.add(new Integer(i));
        }
        int[] vv = new int[v.size()];
        for (int i = 0; i < vv.length; ++i) {
            vv[i] = (Integer)v.get(i);
        }
        return vv;
    }

    public static double[] subVector(double[] vec, int[] indices) {
        double[] x = new double[indices.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = vec[indices[i]];
        }
        return x;
    }

    public static int[] subVector(int[] vec, int[] indices) {
        int[] x = new int[indices.length];
        for (int i = 0; i < x.length; ++i) {
            x[i] = vec[indices[i]];
        }
        return x;
    }

    public static double[] subVector(double[] vec, int start, int end) {
        double[] x = new double[end - start + 1];
        for (int i = 0; i <= end - start; ++i) {
            x[i] = vec[start + i];
        }
        return x;
    }

    public static void setSubVector(int[] vec, int[] indices, int[] replacements) {
        for (int i = 0; i < indices.length; ++i) {
            vec[indices[i]] = replacements[i];
        }
    }

    public static void setSubVector(int[] vec, int[] indices, int replacement) {
        for (int i = 0; i < indices.length; ++i) {
            vec[indices[i]] = replacement;
        }
    }

    public static void add(int[] vec, int scalar) {
        int i = 0;
        while (i < vec.length) {
            int n = i++;
            vec[n] = vec[n] + scalar;
        }
    }

    public static int[] setSubVectorCopy(int[] vec, int[] indices, int[] replacements) {
        int[] x = new int[vec.length];
        for (int i = 0; i < indices.length; ++i) {
            x[indices[i]] = replacements[i];
        }
        return x;
    }

    public static double[] copy(double[] source) {
        if (source == null) {
            return null;
        }
        double[] dest = new double[source.length];
        System.arraycopy(source, 0, dest, 0, source.length);
        return dest;
    }

    public static int[] copy(int[] source) {
        if (source == null) {
            return null;
        }
        int[] dest = new int[source.length];
        System.arraycopy(source, 0, dest, 0, source.length);
        return dest;
    }

    public static double[] mult(double[] ds, double d) {
        int i = 0;
        while (i < ds.length) {
            int n = i++;
            ds[n] = ds[n] * d;
        }
        return ds;
    }

    public static double mult(double[] ds, double[] dt) {
        if (ds.length != dt.length) {
            throw new IllegalArgumentException("Vector dimensions must agree.");
        }
        double s = 0.0;
        for (int i = 0; i < ds.length; ++i) {
            s += ds[i] * dt[i];
        }
        return s;
    }

    public static double[][] transpose(double[][] mat) {
        double[][] a = new double[mat[0].length][mat.length];
        for (int i = 0; i < mat[0].length; ++i) {
            for (int j = 0; j < mat.length; ++j) {
                a[i][j] = mat[j][i];
            }
        }
        return a;
    }

    public static int[][] transpose(int[][] mat) {
        int[][] a = new int[mat[0].length][mat.length];
        for (int i = 0; i < mat[0].length; ++i) {
            for (int j = 0; j < mat.length; ++j) {
                a[i][j] = mat[j][i];
            }
        }
        return a;
    }
}

