/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;

public class StubLoader {
    public static final int VERSION_MAJOR = StubLoader.getVersionField("MAJOR");
    public static final int VERSION_MINOR = StubLoader.getVersionField("MINOR");
    private static final String versionClassName = "com.kenai.jffi.Version";
    private static final Locale LOCALE = Locale.ENGLISH;
    private static final String bootPropertyFilename = "boot.properties";
    private static final String bootLibraryPropertyName = "jffi.boot.library.path";
    private static final String stubLibraryName = String.format("jffi-%d.%d", VERSION_MAJOR, VERSION_MINOR);
    private static final OS OS_ = StubLoader.determineOS();
    private static final CPU CPU_ = StubLoader.determineCPU();
    private static volatile Throwable failureCause = null;
    private static volatile boolean loaded = false;

    public static final boolean isLoaded() {
        return loaded;
    }

    public static final Throwable getFailureCause() {
        return failureCause;
    }

    private static OS determineOS() {
        String osName = System.getProperty("os.name").split(" ")[0];
        if (StubLoader.startsWithIgnoreCase(osName, "mac") || StubLoader.startsWithIgnoreCase(osName, "darwin")) {
            return OS.DARWIN;
        }
        if (StubLoader.startsWithIgnoreCase(osName, "linux")) {
            return OS.LINUX;
        }
        if (StubLoader.startsWithIgnoreCase(osName, "sunos") || StubLoader.startsWithIgnoreCase(osName, "solaris")) {
            return OS.SOLARIS;
        }
        if (StubLoader.startsWithIgnoreCase(osName, "aix")) {
            return OS.AIX;
        }
        if (StubLoader.startsWithIgnoreCase(osName, "openbsd")) {
            return OS.OPENBSD;
        }
        if (StubLoader.startsWithIgnoreCase(osName, "freebsd")) {
            return OS.FREEBSD;
        }
        if (StubLoader.startsWithIgnoreCase(osName, "windows")) {
            return OS.WINDOWS;
        }
        return OS.UNKNOWN;
    }

    private static final CPU determineCPU() {
        String archString = System.getProperty("os.arch", "unknown");
        if (StubLoader.equalsIgnoreCase("x86", archString) || StubLoader.equalsIgnoreCase("i386", archString) || StubLoader.equalsIgnoreCase("i86pc", archString)) {
            return CPU.I386;
        }
        if (StubLoader.equalsIgnoreCase("x86_64", archString) || StubLoader.equalsIgnoreCase("amd64", archString)) {
            return CPU.X86_64;
        }
        if (StubLoader.equalsIgnoreCase("ppc", archString) || StubLoader.equalsIgnoreCase("powerpc", archString)) {
            return CPU.PPC;
        }
        if (StubLoader.equalsIgnoreCase("ppc64", archString) || StubLoader.equalsIgnoreCase("powerpc64", archString)) {
            return CPU.PPC64;
        }
        if (StubLoader.equalsIgnoreCase("s390", archString) || StubLoader.equalsIgnoreCase("s390x", archString)) {
            return CPU.S390X;
        }
        if (StubLoader.equalsIgnoreCase("arm", archString)) {
            return CPU.ARM;
        }
        for (CPU cpu : CPU.values()) {
            if (!StubLoader.equalsIgnoreCase(cpu.name(), archString)) continue;
            return cpu;
        }
        return CPU.UNKNOWN;
    }

    public static CPU getCPU() {
        return CPU_;
    }

    public static OS getOS() {
        return OS_;
    }

    private static String getStubLibraryName() {
        return stubLibraryName;
    }

    public static String getPlatformName() {
        if (StubLoader.getOS().equals((Object)OS.DARWIN)) {
            return "Darwin";
        }
        String osName = System.getProperty("os.name").split(" ")[0];
        return StubLoader.getCPU().name().toLowerCase(LOCALE) + "-" + osName;
    }

    private static String getStubLibraryPath() {
        return "jni/" + StubLoader.getPlatformName() + "/" + System.mapLibraryName(stubLibraryName);
    }

    static void load() {
        String libName = StubLoader.getStubLibraryName();
        String bootPath = StubLoader.getBootPath();
        if (bootPath != null && StubLoader.loadFromBootPath(libName, bootPath)) {
            return;
        }
        String libraryPath = System.getProperty("java.library.path");
        if (libraryPath != null && StubLoader.loadFromBootPath(libName, libraryPath)) {
            return;
        }
        StubLoader.loadFromJar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBootPath() {
        String bootPath = System.getProperty(bootLibraryPropertyName);
        if (bootPath != null) {
            return bootPath;
        }
        InputStream is = StubLoader.getResourceAsStream(bootPropertyFilename);
        if (is != null) {
            Properties p = new Properties();
            try {
                p.load(is);
                String string2 = p.getProperty(bootLibraryPropertyName);
                return string2;
            }
            catch (IOException ex) {
                try {
                    is.close();
                }
                catch (IOException ex2) {
                    throw new RuntimeException(ex2);
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return null;
    }

    private static String getAlternateLibraryPath(String path) {
        if (path.endsWith("dylib")) {
            return path.substring(0, path.lastIndexOf("dylib")) + "jnilib";
        }
        return path.substring(0, path.lastIndexOf("jnilib")) + "dylib";
    }

    private static boolean loadFromBootPath(String libName, String bootPath) {
        String[] dirs = bootPath.split(File.pathSeparator);
        for (int i = 0; i < dirs.length; ++i) {
            String soname = System.mapLibraryName(libName);
            File stub = new File(new File(dirs[i], StubLoader.getPlatformName()), soname);
            if (!stub.isFile()) {
                stub = new File(new File(dirs[i]), soname);
            }
            String path = stub.getAbsolutePath();
            try {
                System.load(path);
                return true;
            }
            catch (UnsatisfiedLinkError ex) {
                if (StubLoader.getOS() != OS.DARWIN) continue;
                try {
                    System.load(StubLoader.getAlternateLibraryPath(path));
                    return true;
                }
                catch (UnsatisfiedLinkError ex2) {
                    // empty catch block
                }
                continue;
            }
        }
        return false;
    }

    private static void loadFromJar() {
        InputStream is = StubLoader.getStubLibraryStream();
        File dstFile = null;
        FileOutputStream os2 = null;
        try {
            dstFile = File.createTempFile("jffi", null);
            dstFile.deleteOnExit();
            os2 = new FileOutputStream(dstFile);
            ReadableByteChannel srcChannel = Channels.newChannel(is);
            long pos = 0L;
            while (is.available() > 0) {
                pos += os2.getChannel().transferFrom(srcChannel, pos, Math.max(4096, is.available()));
            }
        }
        catch (IOException ex) {
            throw new UnsatisfiedLinkError(ex.getMessage());
        }
        finally {
            try {
                if (os2 != null) {
                    os2.close();
                }
                is.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        System.load(dstFile.getAbsolutePath());
    }

    private static InputStream getStubLibraryStream() {
        Object[] paths;
        String stubPath = StubLoader.getStubLibraryPath();
        for (String string2 : paths = new String[]{stubPath, "/" + stubPath}) {
            InputStream is = StubLoader.getResourceAsStream(string2);
            if (is == null && StubLoader.getOS() == OS.DARWIN) {
                is = StubLoader.getResourceAsStream(StubLoader.getAlternateLibraryPath(string2));
            }
            if (is == null) continue;
            return is;
        }
        throw new UnsatisfiedLinkError("could not locate stub library in jar file.  Tried " + Arrays.deepToString(paths));
    }

    private static InputStream getResourceAsStream(String resourceName) {
        ClassLoader[] cls;
        for (ClassLoader cl : cls = new ClassLoader[]{ClassLoader.getSystemClassLoader(), StubLoader.class.getClassLoader(), Thread.currentThread().getContextClassLoader()}) {
            InputStream is;
            if (cl == null || (is = cl.getResourceAsStream(resourceName)) == null) continue;
            return is;
        }
        return null;
    }

    private static int getVersionField(String name) {
        try {
            Class<?> c = Class.forName(versionClassName);
            return (Integer)c.getField(name).get(c);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static boolean startsWithIgnoreCase(String s1, String s2) {
        return s1.startsWith(s2) || s1.toUpperCase(LOCALE).startsWith(s2.toUpperCase(LOCALE)) || s1.toLowerCase(LOCALE).startsWith(s2.toLowerCase(LOCALE));
    }

    private static boolean equalsIgnoreCase(String s1, String s2) {
        return s1.equalsIgnoreCase(s2) || s1.toUpperCase(LOCALE).equals(s2.toUpperCase(LOCALE)) || s1.toLowerCase(LOCALE).equals(s2.toLowerCase(LOCALE));
    }

    static {
        try {
            StubLoader.load();
            loaded = true;
        }
        catch (Throwable t) {
            failureCause = t;
        }
    }

    public static enum CPU {
        I386,
        X86_64,
        PPC,
        PPC64,
        SPARC,
        SPARCV9,
        S390X,
        ARM,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase(LOCALE);
        }
    }

    public static enum OS {
        DARWIN,
        FREEBSD,
        NETBSD,
        OPENBSD,
        LINUX,
        SOLARIS,
        WINDOWS,
        AIX,
        ZLINUX,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase(LOCALE);
        }
    }
}

