/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.bigtiff.internal;

import org.esa.snap.core.util.geotiff.GeoTIFFCodes;

public class GeoKeyEntry {
    private final int keyId;
    private final int tiffTagLocation;
    private final int count;
    private final Integer intValue;
    private final String stringValue;
    private final double[] doubleValues;

    public GeoKeyEntry(int keyId, int tiffTagLocation, int count, Object value) {
        this.keyId = keyId;
        this.tiffTagLocation = tiffTagLocation;
        this.count = count;
        if (value instanceof Integer) {
            this.intValue = (Integer)value;
            this.stringValue = null;
            this.doubleValues = null;
        } else if (value instanceof String) {
            this.intValue = null;
            this.stringValue = (String)value;
            this.doubleValues = null;
        } else if (value instanceof double[]) {
            this.intValue = null;
            this.stringValue = null;
            this.doubleValues = (double[])value;
        } else {
            throw new IllegalArgumentException(value.getClass() + "not supported");
        }
    }

    public int getKeyId() {
        return this.keyId;
    }

    public String getName() {
        return GeoTIFFCodes.getInstance().getName(this.getKeyId());
    }

    boolean hasIntValue() {
        return this.intValue != null;
    }

    public Integer getIntValue() {
        return this.intValue;
    }

    public boolean hasStringValue() {
        return this.stringValue != null;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public boolean hasDoubleValues() {
        return this.doubleValues != null;
    }

    public double[] getDoubleValues() {
        return this.doubleValues;
    }

    public String toString() {
        String s2;
        String s1 = "" + this.keyId + ", " + this.tiffTagLocation + ", " + this.count + ", ";
        if (this.hasIntValue()) {
            s2 = String.valueOf(this.intValue);
        } else if (this.hasDoubleValues()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (double v : this.doubleValues) {
                sb.append(v);
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("]");
            s2 = sb.toString();
        } else {
            s2 = this.stringValue;
        }
        return s1 + s2;
    }
}

