/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.bigtiff;

import it.geosolutions.imageio.plugins.tiff.TIFFField;
import it.geosolutions.imageio.plugins.tiff.TIFFTag;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFIFD;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageMetadata;
import java.util.Map;
import java.util.SortedMap;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.geotiff.EPSGCodes;
import org.esa.snap.dataio.bigtiff.TiffFileInfo;
import org.esa.snap.dataio.bigtiff.internal.GeoKeyEntry;

class TiffToProductMetadataConverter {
    private static final int[] PROCESSED_GEO_TIFF_TAGS = new int[]{33550, 33922, 34264};

    TiffToProductMetadataConverter() {
    }

    static void addTiffTagsToMetadata(TIFFImageMetadata imageMetadata, TiffFileInfo tiffInfo, MetadataElement metadataElem) {
        TIFFField[] tiffFields;
        MetadataElement tiffMetadata = new MetadataElement("TIFF Metadata");
        if (tiffInfo.isGeotiff()) {
            MetadataElement geoTiffMetadata = new MetadataElement("GeoTIFF Metadata");
            TiffToProductMetadataConverter.addGeoTiffTagsToMetadata(tiffInfo, geoTiffMetadata);
            tiffMetadata.addElement(geoTiffMetadata);
        }
        TIFFIFD tiffifd = imageMetadata.getRootIFD();
        for (TIFFField tiffField : tiffFields = tiffifd.getTIFFFields()) {
            int tagNumber = tiffField.getTag().getNumber();
            if (tagNumber == 65000 || TiffToProductMetadataConverter.isGeoTiffTag(tagNumber)) continue;
            MetadataAttribute attribute = TiffToProductMetadataConverter.generateMetadataAttribute(tiffField);
            tiffMetadata.addAttribute(attribute);
        }
        metadataElem.addElement(tiffMetadata);
    }

    private static void addGeoTiffTagsToMetadata(TiffFileInfo tiffInfo, MetadataElement geoTiffMetadata) {
        MetadataAttribute attribute;
        TIFFField field = tiffInfo.getField(34735);
        MetadataElement geoKeyDirMetadata = new MetadataElement(field.getTag().getName());
        geoTiffMetadata.addElement(geoKeyDirMetadata);
        SortedMap<Integer, GeoKeyEntry> geoKeyMap = tiffInfo.getGeoKeyEntries();
        for (Map.Entry<Integer, GeoKeyEntry> entry : geoKeyMap.entrySet()) {
            GeoKeyEntry geoKeyEntry = entry.getValue();
            String name = geoKeyEntry.getName();
            ProductData data = TiffToProductMetadataConverter.getGeoKeyValue(geoKeyEntry);
            if (data == null) continue;
            attribute = new MetadataAttribute(name, data, true);
            geoKeyDirMetadata.addAttribute(attribute);
        }
        for (Object tagNunmber : (Object)PROCESSED_GEO_TIFF_TAGS) {
            TIFFField tiffField = tiffInfo.getField((int)tagNunmber);
            if (tiffField == null) continue;
            attribute = TiffToProductMetadataConverter.generateMetadataAttribute(tiffField);
            geoTiffMetadata.addAttribute(attribute);
        }
    }

    private static boolean isGeoTiffTag(int tagNumber) {
        return tagNumber == 34735 || tagNumber == 34737 || tagNumber == 34736 || tagNumber == 33550 || tagNumber == 33922 || tagNumber == 34264;
    }

    private static MetadataAttribute generateMetadataAttribute(TIFFField tiffField) {
        TIFFTag geoTiffTag = tiffField.getTag();
        String name = geoTiffTag.getName();
        int dataCount = tiffField.getCount();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dataCount; ++i) {
            if (geoTiffTag.hasValueNames()) {
                sb.append(geoTiffTag.getValueName(tiffField.getAsInt(i)));
            } else {
                sb.append(tiffField.getValueAsString(i));
            }
            if (i + 1 >= dataCount) continue;
            sb.append(", ");
        }
        ProductData value = ProductData.createInstance((String)sb.toString());
        return new MetadataAttribute(name, value, true);
    }

    private static ProductData getGeoKeyValue(GeoKeyEntry geoKeyEntry) {
        ProductData value = geoKeyEntry.hasDoubleValues() ? ProductData.createInstance((double[])geoKeyEntry.getDoubleValues()) : (geoKeyEntry.hasStringValue() ? ProductData.createInstance((String)geoKeyEntry.getStringValue()) : (geoKeyEntry.getKeyId() == 1024 ? TiffToProductMetadataConverter.getModelTypeValueName(geoKeyEntry.getIntValue()) : (geoKeyEntry.getKeyId() == 1025 ? TiffToProductMetadataConverter.getRasterTypeValueName(geoKeyEntry.getIntValue()) : TiffToProductMetadataConverter.getEPSGValueName(geoKeyEntry))));
        return value;
    }

    private static ProductData getEPSGValueName(GeoKeyEntry geoKeyEntry) {
        String epsgCodeName = EPSGCodes.getInstance().getName(geoKeyEntry.getIntValue().intValue());
        ProductData value = epsgCodeName == null ? ProductData.createInstance((int)geoKeyEntry.getIntValue()) : ProductData.createInstance((String)epsgCodeName);
        return value;
    }

    static ProductData getRasterTypeValueName(int rasterTypeIndex) {
        ProductData value = rasterTypeIndex == 1 ? ProductData.createInstance((String)"RasterPixelIsArea") : (rasterTypeIndex == 2 ? ProductData.createInstance((String)"RasterPixelIsPoint") : ProductData.createInstance((String)"unknown"));
        return value;
    }

    static ProductData getModelTypeValueName(int modelTypeIndex) {
        ProductData value = modelTypeIndex == 1 ? ProductData.createInstance((String)"ModelTypeProjected") : (modelTypeIndex == 2 ? ProductData.createInstance((String)"ModelTypeGeographic") : (modelTypeIndex == 3 ? ProductData.createInstance((String)"ModelTypeGeocentric") : ProductData.createInstance((String)"unknown")));
        return value;
    }
}

