/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.bigtiff;

import it.geosolutions.imageio.plugins.tiff.TIFFField;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFIFD;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.esa.snap.dataio.bigtiff.internal.GeoKeyEntry;

public class TiffFileInfo {
    private static final int TAG_GEO_KEY_DIRECTORY___SPOT = 34735;
    private static final int TAG_GEO_DOUBLE_PARAMS___SPOT = 34736;
    private static final int TAG_GEO_ASCII_PARAMS___SPOT = 34737;
    private final Map<Integer, TIFFField> fieldMap;

    TiffFileInfo(TIFFIFD rootIFD) {
        TIFFField[] tiffFields = rootIFD.getTIFFFields();
        this.fieldMap = new HashMap<Integer, TIFFField>(tiffFields.length);
        for (TIFFField field : tiffFields) {
            this.fieldMap.put(field.getTagNumber(), field);
        }
    }

    TIFFField getField(int tagNumber) {
        return this.fieldMap.get(tagNumber);
    }

    boolean containsField(int tagNumber) {
        return this.fieldMap.containsKey(tagNumber);
    }

    boolean isGeotiff() {
        return this.fieldMap.containsKey(34735);
    }

    public SortedMap<Integer, GeoKeyEntry> getGeoKeyEntries() {
        int[] dirValues = this.getGeoKeyDirValues();
        double[] doubleValues = this.getGeoDoubleParamValues();
        String[] asciiValues = this.getGeoAsciiParamValues();
        int size = dirValues.length / 4 - 1;
        int strIdx = 0;
        TreeMap<Integer, GeoKeyEntry> map = new TreeMap<Integer, GeoKeyEntry>();
        for (int i = 0; i < size; ++i) {
            Object value;
            int offset = (i + 1) * 4;
            int keyId = dirValues[offset];
            int tiffTagLocation = dirValues[offset + 1];
            int count = dirValues[offset + 2];
            int offsetOrValue = dirValues[offset + 3];
            if (tiffTagLocation == 34736) {
                double[] doubles = new double[count];
                System.arraycopy(doubleValues, offsetOrValue, doubles, 0, count);
                value = doubles;
            } else {
                value = tiffTagLocation == 34737 && asciiValues.length > strIdx ? asciiValues[strIdx++] : new Integer(offsetOrValue);
            }
            map.put(keyId, new GeoKeyEntry(keyId, tiffTagLocation, count, value));
        }
        return map;
    }

    private int[] getGeoKeyDirValues() {
        if (!this.containsField(34735)) {
            throw new IllegalStateException("no GEO_KEY_DIRECTORY");
        }
        TIFFField field = this.getField(34735);
        int count = field.getCount();
        int[] ints = new int[count];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = field.getAsInt(i);
        }
        return ints;
    }

    private double[] getGeoDoubleParamValues() {
        if (this.containsField(34736)) {
            return TiffFileInfo.getDoubleValues(this.getField(34736));
        }
        return new double[0];
    }

    private static double[] getDoubleValues(TIFFField field) {
        int count = field.getCount();
        double[] doubles = new double[count];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = field.getAsDouble(i);
        }
        return doubles;
    }

    private String[] getGeoAsciiParamValues() {
        if (this.containsField(34737)) {
            TIFFField field = this.getField(34737);
            String[] values = TiffFileInfo.getStringValues(field);
            ArrayList<String> strings = new ArrayList<String>();
            for (String value : values) {
                value = value.replace("\u0000", "");
                strings.addAll(Arrays.asList(value.split("\\|")));
            }
            return strings.toArray(new String[strings.size()]);
        }
        return new String[0];
    }

    private static String[] getStringValues(TIFFField field) {
        int count = field.getCount();
        String[] strings = new String[count];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = field.getAsString(i);
        }
        return strings;
    }
}

