/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReadParamJava;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.imageio.stream.MemoryCacheImageInputStream;
import jj2000.j2k.JJ2KExceptionHandler;
import jj2000.j2k.NoNextElementException;
import jj2000.j2k.NotImplementedError;
import jj2000.j2k.codestream.CorruptedCodestreamException;
import jj2000.j2k.codestream.HeaderInfo;
import jj2000.j2k.codestream.Markers;
import jj2000.j2k.codestream.PrecInfo;
import jj2000.j2k.codestream.ProgressionType;
import jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import jj2000.j2k.codestream.reader.CBlkInfo;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.codestream.reader.PktDecoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.entropy.decoder.DecLyrdCBlk;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.quantization.dequantizer.StdDequantizerParams;
import jj2000.j2k.util.ArrayUtil;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public class FileBitstreamReaderAgent
extends BitstreamReaderAgent
implements Markers,
ProgressionType,
StdEntropyCoderOptions {
    private boolean isPsotEqualsZero = true;
    public PktDecoder pktDec;
    private J2KImageReadParamJava j2krparam;
    private RandomAccessIO in;
    private int nt;
    private int[][] firstPackOff;
    private int[] nBytes;
    private boolean printInfo = false;
    private int[] baknBytes;
    private int[][] tilePartLen;
    private int[] totTileLen;
    private int[] totTileHeadLen;
    private int firstTilePartHeadLen;
    private double totAllTileLen;
    private int mainHeadLen;
    private int headLen = 0;
    private int[][] tilePartHeadLen;
    private Vector pktHL;
    private boolean isTruncMode;
    private int remainingTileParts;
    private int[] tilePartsRead;
    private int totTilePartsRead = 0;
    private int[] tileParts;
    private int[] totTileParts;
    private int curTilePart;
    private int[][] tilePartNum;
    private boolean isEOCFound = false;
    private HeaderInfo hi;
    private CBlkInfo[][][][][] cbI;
    private int lQuit;
    private boolean usePOCQuit = false;
    long[][] tilePartPositions = null;
    int cdstreamStart = 0;
    int t = 0;
    int pos = -1;
    int tp = 0;
    int tptot = 0;
    int tilePartStart = 0;
    boolean rateReached = false;
    int numtp = 0;
    int maxTP = this.nt;
    int lastPos = 0;
    int maxPos = 0;

    public int getNumTileParts(int n) {
        if (this.firstPackOff == null || this.firstPackOff[n] == null) {
            throw new Error("Tile " + n + " not found in input codestream.");
        }
        return this.firstPackOff[n].length;
    }

    public CBlkInfo[][][][][] getCBlkInfo() {
        return this.cbI;
    }

    public FileBitstreamReaderAgent(HeaderDecoder headerDecoder, RandomAccessIO randomAccessIO, DecoderSpecs decoderSpecs, J2KImageReadParamJava j2KImageReadParamJava, boolean bl, HeaderInfo headerInfo) throws IOException {
        super(headerDecoder, decoderSpecs);
        this.j2krparam = j2KImageReadParamJava;
        this.printInfo = bl;
        this.hi = headerInfo;
        String string = this.printInfo ? "Codestream elements information in bytes (offset, total length, header length):\n\n" : null;
        this.tnbytes = j2KImageReadParamJava.getDecodingRate() == Double.MAX_VALUE ? Integer.MAX_VALUE : (int)(j2KImageReadParamJava.getDecodingRate() * (double)headerDecoder.getMaxCompImgWidth() * (double)headerDecoder.getMaxCompImgHeight()) / 8;
        this.isTruncMode = true;
        int n = -1;
        if (n != -1 && !this.isTruncMode) {
            throw new Error("Cannot use -parsing and -ncb_quit condition at the same time.");
        }
        this.lQuit = -1;
        this.nt = this.ntX * this.ntY;
        this.in = randomAccessIO;
        this.pktDec = new PktDecoder(decoderSpecs, headerDecoder, randomAccessIO, this, this.isTruncMode, n);
        this.tileParts = new int[this.nt];
        this.totTileParts = new int[this.nt];
        this.totTileLen = new int[this.nt];
        this.tilePartLen = new int[this.nt][];
        this.tilePartNum = new int[this.nt][];
        this.firstPackOff = new int[this.nt][];
        this.tilePartsRead = new int[this.nt];
        this.totTileHeadLen = new int[this.nt];
        this.tilePartHeadLen = new int[this.nt][];
        this.nBytes = new int[this.nt];
        this.baknBytes = new int[this.nt];
        headerDecoder.nTileParts = new int[this.nt];
        this.isTruncMode = this.isTruncMode;
        this.cdstreamStart = headerDecoder.mainHeadOff;
        this.headLen = this.mainHeadLen = this.in.getPos() - this.cdstreamStart;
        this.anbytes = n == -1 ? this.mainHeadLen : 0;
        if (this.printInfo) {
            string = string + "Main header length    : " + this.cdstreamStart + ", " + this.mainHeadLen + ", " + this.mainHeadLen + "\n";
        }
        if (this.anbytes > this.tnbytes) {
            throw new Error("Requested bitrate is too small.");
        }
        this.totAllTileLen = 0.0;
        this.remainingTileParts = this.nt;
        this.maxPos = this.lastPos = this.in.getPos();
        if (j2KImageReadParamJava.getResolution() == -1) {
            this.targetRes = decoderSpecs.dls.getMin();
        } else {
            this.targetRes = j2KImageReadParamJava.getResolution();
            if (this.targetRes < 0) {
                throw new IllegalArgumentException("Specified negative resolution level index: " + this.targetRes);
            }
        }
        int n2 = decoderSpecs.dls.getMin();
        if (this.targetRes > n2) {
            FacilityManager.getMsgLogger().printmsg(2, "Specified resolution level (" + this.targetRes + ") is larger" + " than the maximum possible. Setting it to " + n2 + " (maximum possible)");
            this.targetRes = n2;
        }
        this.initTLM();
    }

    private void initTLM() throws IOException {
        int n = this.in.getPos();
        Object object = null;
        int n2 = 0;
        try {
            short s;
            this.in.seek(this.cdstreamStart + 2);
            while ((s = this.in.readShort()) != -112) {
                int n3 = this.in.readUnsignedShort();
                if (s == -171) {
                    ++n2;
                    if (object == null) {
                        object = new byte[256][];
                    }
                    int n4 = this.in.read();
                    object[n4] = new byte[n3 - 3];
                    this.in.readFully(object[n4], 0, n3 - 3);
                    continue;
                }
                this.in.skipBytes(n3 - 2);
            }
        }
        catch (IOException iOException) {
            object = null;
        }
        if (object != null) {
            int n5;
            Object object2;
            int n6;
            ArrayList[] arrayListArray = null;
            long l = this.cdstreamStart + this.mainHeadLen;
            int n7 = 0;
            for (n6 = 0; n6 < n2; ++n6) {
                if (object[n6] == null) {
                    arrayListArray = null;
                    break;
                }
                if (arrayListArray == null) {
                    arrayListArray = new ArrayList[this.nt];
                }
                object2 = new ByteArrayInputStream(object[n6]);
                MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream((InputStream)object2);
                try {
                    int n8 = memoryCacheImageInputStream.read();
                    n5 = n8 >> 4 & 3;
                    int n9 = n8 >> 6 & 1;
                    int n10 = object[n6].length;
                    while (memoryCacheImageInputStream.getStreamPosition() < (long)n10) {
                        int n11 = n7;
                        switch (n5) {
                            case 1: {
                                n11 = memoryCacheImageInputStream.read();
                                break;
                            }
                            case 2: {
                                n11 = memoryCacheImageInputStream.readUnsignedShort();
                            }
                        }
                        if (arrayListArray[n11] == null) {
                            arrayListArray[n11] = new ArrayList();
                        }
                        arrayListArray[n11].add(new Long(l));
                        long l2 = 0L;
                        switch (n9) {
                            case 0: {
                                l2 = memoryCacheImageInputStream.readUnsignedShort();
                                break;
                            }
                            case 1: {
                                l2 = memoryCacheImageInputStream.readUnsignedInt();
                            }
                        }
                        l += l2;
                        if (n5 != 0) continue;
                        ++n7;
                    }
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (arrayListArray != null) {
                this.tilePartPositions = new long[this.nt][];
                for (n6 = 0; n6 < this.nt; ++n6) {
                    if (arrayListArray[n6] == null) {
                        this.tilePartPositions = null;
                        break;
                    }
                    object2 = arrayListArray[n6];
                    int n12 = ((ArrayList)object2).size();
                    this.tilePartPositions[n6] = new long[n12];
                    long[] lArray = this.tilePartPositions[n6];
                    for (n5 = 0; n5 < n12; ++n5) {
                        lArray[n5] = (Long)((ArrayList)object2).get(n5);
                    }
                }
            }
        }
        this.in.seek(n);
    }

    private void initTile(int n) throws IOException {
        int n2;
        boolean bl;
        boolean bl2;
        String string;
        block31: {
            int n3;
            if (this.tilePartPositions == null) {
                this.in.seek(this.lastPos);
            }
            string = "";
            int n4 = -1;
            bl2 = false;
            bl = false;
            try {
                n2 = 0;
                while (this.remainingTileParts != 0 && (this.totTileParts[n] == 0 || this.tilePartsRead[n] < this.totTileParts[n])) {
                    bl2 = true;
                    if (this.tilePartPositions != null) {
                        this.in.seek((int)this.tilePartPositions[n][n2++]);
                    }
                    this.tilePartStart = this.in.getPos();
                    try {
                        this.t = this.readTilePartHeader();
                        if (this.isEOCFound) break;
                        this.tp = this.tilePartsRead[this.t];
                        if (this.isPsotEqualsZero) {
                            this.tilePartLen[this.t][this.tp] = this.in.length() - 2 - this.tilePartStart;
                        }
                    }
                    catch (EOFException eOFException) {
                        this.firstPackOff[this.t][this.tp] = this.in.length();
                        throw eOFException;
                    }
                    this.pos = this.in.getPos();
                    if (this.isTruncMode && n4 == -1 && this.pos - this.cdstreamStart > this.tnbytes) {
                        this.firstPackOff[this.t][this.tp] = this.in.length();
                        this.rateReached = true;
                        break;
                    }
                    this.firstPackOff[this.t][this.tp] = this.pos;
                    this.tilePartHeadLen[this.t][this.tp] = this.pos - this.tilePartStart;
                    if (this.printInfo) {
                        string = string + "Tile-part " + this.tp + " of tile " + this.t + " : " + this.tilePartStart + ", " + this.tilePartLen[this.t][this.tp] + ", " + this.tilePartHeadLen[this.t][this.tp] + "\n";
                    }
                    int n5 = this.t;
                    this.totTileLen[n5] = this.totTileLen[n5] + this.tilePartLen[this.t][this.tp];
                    int n6 = this.t;
                    this.totTileHeadLen[n6] = this.totTileHeadLen[n6] + this.tilePartHeadLen[this.t][this.tp];
                    this.totAllTileLen += (double)this.tilePartLen[this.t][this.tp];
                    if (this.isTruncMode) {
                        if (this.anbytes + this.tilePartLen[this.t][this.tp] > this.tnbytes) {
                            this.anbytes += this.tilePartHeadLen[this.t][this.tp];
                            this.headLen += this.tilePartHeadLen[this.t][this.tp];
                            this.rateReached = true;
                            int n7 = this.t;
                            this.nBytes[n7] = this.nBytes[n7] + (this.tnbytes - this.anbytes);
                            break;
                        }
                        this.anbytes += this.tilePartHeadLen[this.t][this.tp];
                        this.headLen += this.tilePartHeadLen[this.t][this.tp];
                        int n8 = this.t;
                        this.nBytes[n8] = this.nBytes[n8] + (this.tilePartLen[this.t][this.tp] - this.tilePartHeadLen[this.t][this.tp]);
                    } else {
                        if (this.anbytes + this.tilePartHeadLen[this.t][this.tp] > this.tnbytes) break;
                        this.anbytes += this.tilePartHeadLen[this.t][this.tp];
                        this.headLen += this.tilePartHeadLen[this.t][this.tp];
                    }
                    if (this.tptot == 0) {
                        this.firstTilePartHeadLen = this.tilePartHeadLen[this.t][this.tp];
                    }
                    int n9 = this.t;
                    this.tilePartsRead[n9] = this.tilePartsRead[n9] + 1;
                    n3 = this.tilePartStart + this.tilePartLen[this.t][this.tp];
                    if (this.tilePartPositions == null) {
                        this.in.seek(n3);
                    }
                    if (n3 > this.maxPos) {
                        this.maxPos = n3;
                    }
                    --this.remainingTileParts;
                    --this.maxTP;
                    ++this.tptot;
                    if (!this.isPsotEqualsZero) continue;
                    if (this.remainingTileParts != 0) {
                        FacilityManager.getMsgLogger().printmsg(2, "Some tile-parts have not been found. The codestream may be corrupted.");
                    }
                    break;
                }
            }
            catch (EOFException eOFException) {
                bl = true;
                if (this.printInfo) {
                    FacilityManager.getMsgLogger().printmsg(1, string);
                }
                FacilityManager.getMsgLogger().printmsg(2, "Codestream truncated in tile " + this.t);
                n3 = this.in.length();
                if (n3 >= this.tnbytes) break block31;
                this.tnbytes = n3;
                this.trate = (float)this.tnbytes * 8.0f / (float)this.hd.getMaxCompImgWidth() / (float)this.hd.getMaxCompImgHeight();
            }
        }
        if (!bl2) {
            return;
        }
        if (!bl) {
            if (this.printInfo) {
                FacilityManager.getMsgLogger().printmsg(1, string);
            }
            if (!(this.remainingTileParts != 0 || this.isEOCFound || this.isPsotEqualsZero || this.rateReached)) {
                try {
                    n2 = this.in.getPos();
                    this.in.seek(this.maxPos);
                    if (this.in.readShort() != -39) {
                        FacilityManager.getMsgLogger().printmsg(2, "EOC marker not found. Codestream is corrupted.");
                    }
                    this.in.seek(n2);
                }
                catch (EOFException eOFException) {
                    FacilityManager.getMsgLogger().printmsg(2, "EOC marker is missing");
                }
            }
        }
        if (!this.isTruncMode) {
            this.allocateRate();
        } else if (this.remainingTileParts == 0 && !bl && this.in.getPos() >= this.tnbytes) {
            this.anbytes += 2;
        }
        if (this.tilePartPositions == null) {
            this.lastPos = this.in.getPos();
        }
        for (int i = 0; i < this.nt; ++i) {
            this.baknBytes[i] = this.nBytes[i];
            if (!this.printInfo) continue;
            FacilityManager.getMsgLogger().println("" + this.hi.toStringTileHeader(i, this.tilePartLen[i].length), 2, 2);
        }
    }

    private void allocateRate() throws IOException {
        int n;
        int n2 = this.tnbytes;
        if (this.remainingTileParts == 0) {
            this.anbytes += 2;
        }
        if (this.anbytes > n2) {
            throw new Error("Requested bitrate is too small for parsing");
        }
        int n3 = n = n2 - this.anbytes;
        for (int i = this.nt - 1; i > 0; --i) {
            this.nBytes[i] = (int)((double)n3 * ((double)this.totTileLen[i] / this.totAllTileLen));
            n -= this.nBytes[i];
        }
        this.nBytes[0] = n;
    }

    private int readTilePartHeader() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        HeaderInfo.SOT sOT = this.hi.getNewSOT();
        short s = this.in.readShort();
        if (s != -112) {
            if (s == -39) {
                this.isEOCFound = true;
                return -1;
            }
            throw new CorruptedCodestreamException("SOT tag not found in tile-part start");
        }
        this.isEOCFound = false;
        sOT.lsot = n5 = this.in.readUnsignedShort();
        if (n5 != 10) {
            throw new CorruptedCodestreamException("Wrong length for SOT marker segment: " + n5);
        }
        sOT.isot = n4 = this.in.readUnsignedShort();
        if (n4 > 65534) {
            throw new CorruptedCodestreamException("Tile index too high in tile-part.");
        }
        sOT.psot = n3 = this.in.readInt();
        boolean bl = this.isPsotEqualsZero = n3 == 0;
        if (n3 < 0) {
            throw new NotImplementedError("Tile length larger than maximum supported");
        }
        sOT.tpsot = n2 = this.in.read();
        if (n2 != this.tilePartsRead[n4] || n2 < 0 || n2 > 254) {
            throw new CorruptedCodestreamException("Out of order tile-part");
        }
        sOT.tnsot = n = this.in.read();
        this.hi.sot.put("t" + n4 + "_tp" + n2, sOT);
        if (n == 0) {
            int n6;
            int n7;
            if (this.tileParts[n4] == 0 || this.tileParts[n4] == this.tilePartLen.length) {
                n7 = 2;
                ++this.remainingTileParts;
            } else {
                n7 = 1;
            }
            int n8 = n4;
            this.tileParts[n8] = this.tileParts[n8] + n7;
            n = this.tileParts[n4];
            FacilityManager.getMsgLogger().printmsg(2, "Header of tile-part " + n2 + " of tile " + n4 + ", does not indicate the total" + " number of tile-parts. Assuming that there are " + n + " tile-parts for this tile.");
            int[] nArray = this.tilePartLen[n4];
            this.tilePartLen[n4] = new int[n];
            for (n6 = 0; n6 < n - n7; ++n6) {
                this.tilePartLen[n4][n6] = nArray[n6];
            }
            nArray = this.tilePartNum[n4];
            this.tilePartNum[n4] = new int[n];
            for (n6 = 0; n6 < n - n7; ++n6) {
                this.tilePartNum[n4][n6] = nArray[n6];
            }
            nArray = this.firstPackOff[n4];
            this.firstPackOff[n4] = new int[n];
            for (n6 = 0; n6 < n - n7; ++n6) {
                this.firstPackOff[n4][n6] = nArray[n6];
            }
            nArray = this.tilePartHeadLen[n4];
            this.tilePartHeadLen[n4] = new int[n];
            for (n6 = 0; n6 < n - n7; ++n6) {
                this.tilePartHeadLen[n4][n6] = nArray[n6];
            }
        } else {
            this.totTileParts[n4] = n;
            if (this.tileParts[n4] == 0) {
                this.remainingTileParts += n - 1;
                this.tileParts[n4] = n;
                this.tilePartLen[n4] = new int[n];
                this.tilePartNum[n4] = new int[n];
                this.firstPackOff[n4] = new int[n];
                this.tilePartHeadLen[n4] = new int[n];
            } else {
                if (this.tileParts[n4] > n) {
                    throw new CorruptedCodestreamException("Invalid number of tile-parts in tile " + n4 + ": " + n);
                }
                this.remainingTileParts += n - this.tileParts[n4];
                if (this.tileParts[n4] != n) {
                    int n9;
                    int[] nArray = this.tilePartLen[n4];
                    this.tilePartLen[n4] = new int[n];
                    for (n9 = 0; n9 < this.tileParts[n4] - 1; ++n9) {
                        this.tilePartLen[n4][n9] = nArray[n9];
                    }
                    nArray = this.tilePartNum[n4];
                    this.tilePartNum[n4] = new int[n];
                    for (n9 = 0; n9 < this.tileParts[n4] - 1; ++n9) {
                        this.tilePartNum[n4][n9] = nArray[n9];
                    }
                    nArray = this.firstPackOff[n4];
                    this.firstPackOff[n4] = new int[n];
                    for (n9 = 0; n9 < this.tileParts[n4] - 1; ++n9) {
                        this.firstPackOff[n4][n9] = nArray[n9];
                    }
                    nArray = this.tilePartHeadLen[n4];
                    this.tilePartHeadLen[n4] = new int[n];
                    for (n9 = 0; n9 < this.tileParts[n4] - 1; ++n9) {
                        this.tilePartHeadLen[n4][n9] = nArray[n9];
                    }
                }
            }
        }
        this.hd.resetHeaderMarkers();
        this.hd.nTileParts[n4] = n;
        do {
            this.hd.extractTilePartMarkSeg(this.in.readShort(), this.in, n4, n2);
        } while ((this.hd.getNumFoundMarkSeg() & 0x2000) == 0);
        this.hd.readFoundTilePartMarkSeg(n4, n2);
        this.tilePartLen[n4][n2] = n3;
        this.tilePartNum[n4][n2] = this.totTilePartsRead++;
        this.hd.setTileOfTileParts(n4);
        return n4;
    }

    private boolean readLyResCompPos(int[][] nArray, int n, int n2, int n3, int n4, int n5) throws IOException {
        int n6;
        int n7;
        int n8 = 10000;
        for (n7 = n4; n7 < n5; ++n7) {
            if (n7 >= this.mdl.length) continue;
            for (n6 = n2; n6 < n3; ++n6) {
                if (nArray[n7] == null || n6 >= nArray[n7].length || nArray[n7][n6] >= n8) continue;
                n8 = nArray[n7][n6];
            }
        }
        n7 = this.getTileIdx();
        boolean bl = false;
        int n9 = this.firstPackOff[n7][this.curTilePart] + this.tilePartLen[n7][this.curTilePart] - 1 - this.tilePartHeadLen[n7][this.curTilePart];
        int n10 = (Integer)this.decSpec.nls.getTileDef(n7);
        int n11 = 1;
        String string = this.printInfo ? "Tile " + this.getTileIdx() + " (tile-part:" + this.curTilePart + "): offset, length, header length\n" : null;
        boolean bl2 = false;
        if (((Boolean)this.decSpec.pphs.getTileDef(n7)).booleanValue()) {
            bl2 = true;
        }
        for (int i = n8; i < n; ++i) {
            for (int j = n2; j < n3; ++j) {
                for (int k = n4; k < n5; ++k) {
                    if (k >= this.mdl.length || j >= nArray[k].length || j > this.mdl[k] || i < nArray[k][j] || i >= n10) continue;
                    n11 = this.pktDec.getNumPrecinct(k, j);
                    for (int i2 = 0; i2 < n11; ++i2) {
                        n6 = this.in.getPos();
                        if (bl2) {
                            this.pktDec.readPktHead(i, j, k, i2, this.cbI[k][j], this.nBytes);
                        }
                        if (n6 > n9 && this.curTilePart < this.firstPackOff[n7].length - 1) {
                            ++this.curTilePart;
                            this.in.seek(this.firstPackOff[n7][this.curTilePart]);
                            n9 = this.in.getPos() + this.tilePartLen[n7][this.curTilePart] - 1 - this.tilePartHeadLen[n7][this.curTilePart];
                        }
                        if (bl = this.pktDec.readSOPMarker(this.nBytes, i2, k, j)) {
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, string);
                            }
                            return true;
                        }
                        if (!bl2) {
                            bl = this.pktDec.readPktHead(i, j, k, i2, this.cbI[k][j], this.nBytes);
                        }
                        if (bl) {
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, string);
                            }
                            return true;
                        }
                        int n12 = this.in.getPos() - n6;
                        this.pktHL.addElement(new Integer(n12));
                        bl = this.pktDec.readPktBody(i, j, k, i2, this.cbI[k][j], this.nBytes);
                        int n13 = this.in.getPos() - n6;
                        if (this.printInfo) {
                            string = string + " Pkt l=" + i + ",r=" + j + ",c=" + k + ",p=" + i2 + ": " + n6 + ", " + n13 + ", " + n12 + "\n";
                        }
                        if (!bl) continue;
                        if (this.printInfo) {
                            FacilityManager.getMsgLogger().printmsg(1, string);
                        }
                        return true;
                    }
                }
            }
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        return false;
    }

    private boolean readResLyCompPos(int[][] nArray, int n, int n2, int n3, int n4, int n5) throws IOException {
        int n6;
        int n7 = this.getTileIdx();
        boolean bl = false;
        int n8 = this.firstPackOff[n7][this.curTilePart] + this.tilePartLen[n7][this.curTilePart] - 1 - this.tilePartHeadLen[n7][this.curTilePart];
        int n9 = 10000;
        for (int i = n4; i < n5; ++i) {
            if (i >= this.mdl.length) continue;
            for (n6 = n2; n6 < n3; ++n6) {
                if (n6 > this.mdl[i] || nArray[i] == null || n6 >= nArray[i].length || nArray[i][n6] >= n9) continue;
                n9 = nArray[i][n6];
            }
        }
        String string = this.printInfo ? "Tile " + this.getTileIdx() + " (tile-part:" + this.curTilePart + "): offset, length, header length\n" : null;
        n6 = (Integer)this.decSpec.nls.getTileDef(n7);
        boolean bl2 = false;
        if (((Boolean)this.decSpec.pphs.getTileDef(n7)).booleanValue()) {
            bl2 = true;
        }
        int n10 = 1;
        for (int i = n2; i < n3; ++i) {
            for (int j = n9; j < n; ++j) {
                for (int k = n4; k < n5; ++k) {
                    if (k >= this.mdl.length || i > this.mdl[k] || i >= nArray[k].length || j < nArray[k][i] || j >= n6) continue;
                    n10 = this.pktDec.getNumPrecinct(k, i);
                    for (int i2 = 0; i2 < n10; ++i2) {
                        int n11 = this.in.getPos();
                        if (bl2) {
                            this.pktDec.readPktHead(j, i, k, i2, this.cbI[k][i], this.nBytes);
                        }
                        if (n11 > n8 && this.curTilePart < this.firstPackOff[n7].length - 1) {
                            ++this.curTilePart;
                            this.in.seek(this.firstPackOff[n7][this.curTilePart]);
                            n8 = this.in.getPos() + this.tilePartLen[n7][this.curTilePart] - 1 - this.tilePartHeadLen[n7][this.curTilePart];
                        }
                        if (bl = this.pktDec.readSOPMarker(this.nBytes, i2, k, i)) {
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, string);
                            }
                            return true;
                        }
                        if (!bl2) {
                            bl = this.pktDec.readPktHead(j, i, k, i2, this.cbI[k][i], this.nBytes);
                        }
                        if (bl) {
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, string);
                            }
                            return true;
                        }
                        int n12 = this.in.getPos() - n11;
                        this.pktHL.addElement(new Integer(n12));
                        bl = this.pktDec.readPktBody(j, i, k, i2, this.cbI[k][i], this.nBytes);
                        int n13 = this.in.getPos() - n11;
                        if (this.printInfo) {
                            string = string + " Pkt l=" + j + ",r=" + i + ",c=" + k + ",p=" + i2 + ": " + n11 + ", " + n13 + ", " + n12 + "\n";
                        }
                        if (!bl) continue;
                        if (this.printInfo) {
                            FacilityManager.getMsgLogger().printmsg(1, string);
                        }
                        return true;
                    }
                }
            }
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        return false;
    }

    private boolean readResPosCompLy(int[][] nArray, int n, int n2, int n3, int n4, int n5) throws IOException {
        PrecInfo precInfo;
        int n6;
        int n7;
        Point point = this.getNumTiles(null);
        Point point2 = this.getTile(null);
        int n8 = this.hd.getImgULX();
        int n9 = this.hd.getImgULY();
        int n10 = n8 + this.hd.getImgWidth();
        int n11 = n9 + this.hd.getImgHeight();
        int n12 = this.getTilePartULX();
        int n13 = this.getTilePartULY();
        int n14 = this.getNomTileWidth();
        int n15 = this.getNomTileHeight();
        int n16 = point2.x == 0 ? n8 : n12 + point2.x * n14;
        int n17 = point2.y == 0 ? n9 : n13 + point2.y * n15;
        int n18 = point2.x != point.x - 1 ? n12 + (point2.x + 1) * n14 : n10;
        int n19 = point2.y != point.y - 1 ? n13 + (point2.y + 1) * n15 : n11;
        int n20 = this.getTileIdx();
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int[][] nArrayArray = new int[n5][];
        int n24 = 100000;
        int n25 = n18;
        int n26 = n19;
        int n27 = n16;
        int n28 = n17;
        for (n7 = n4; n7 < n5; ++n7) {
            for (n6 = n2; n6 < n3; ++n6) {
                if (n7 >= this.mdl.length || n6 > this.mdl[n7]) continue;
                nArrayArray[n7] = new int[this.mdl[n7] + 1];
                if (nArray[n7] != null && n6 < nArray[n7].length && nArray[n7][n6] < n24) {
                    n24 = nArray[n7][n6];
                }
                for (int i = this.pktDec.getNumPrecinct(n7, n6) - 1; i >= 0; --i) {
                    precInfo = this.pktDec.getPrecInfo(n7, n6, i);
                    if (precInfo.rgulx != n16) {
                        if (precInfo.rgulx < n25) {
                            n25 = precInfo.rgulx;
                        }
                        if (precInfo.rgulx > n27) {
                            n27 = precInfo.rgulx;
                        }
                    }
                    if (precInfo.rguly != n17) {
                        if (precInfo.rguly < n26) {
                            n26 = precInfo.rguly;
                        }
                        if (precInfo.rguly > n28) {
                            n28 = precInfo.rguly;
                        }
                    }
                    if (n23 == 0) {
                        n21 = precInfo.rgw;
                        n22 = precInfo.rgh;
                    } else {
                        n21 = MathUtil.gcd(n21, precInfo.rgw);
                        n22 = MathUtil.gcd(n22, precInfo.rgh);
                    }
                    ++n23;
                }
            }
        }
        if (n23 == 0) {
            throw new Error("Image cannot have no precinct");
        }
        n7 = (n28 - n26) / n22 + 1;
        n6 = (n27 - n25) / n21 + 1;
        boolean bl = false;
        int n29 = this.firstPackOff[n20][this.curTilePart] + this.tilePartLen[n20][this.curTilePart] - 1 - this.tilePartHeadLen[n20][this.curTilePart];
        int n30 = (Integer)this.decSpec.nls.getTileDef(n20);
        String string = this.printInfo ? "Tile " + this.getTileIdx() + " (tile-part:" + this.curTilePart + "): offset, length, header length\n" : null;
        boolean bl2 = false;
        if (((Boolean)this.decSpec.pphs.getTileDef(n20)).booleanValue()) {
            bl2 = true;
        }
        for (int i = n2; i < n3; ++i) {
            int n31 = n17;
            int n32 = n16;
            for (int j = 0; j <= n7; ++j) {
                for (int k = 0; k <= n6; ++k) {
                    for (int i2 = n4; i2 < n5; ++i2) {
                        if (i2 >= this.mdl.length || i > this.mdl[i2] || nArrayArray[i2][i] >= this.pktDec.getNumPrecinct(i2, i)) continue;
                        precInfo = this.pktDec.getPrecInfo(i2, i, nArrayArray[i2][i]);
                        if (precInfo.rgulx != n32 || precInfo.rguly != n31) continue;
                        for (int i3 = n24; i3 < n; ++i3) {
                            if (i >= nArray[i2].length || i3 < nArray[i2][i] || i3 >= n30) continue;
                            int n33 = this.in.getPos();
                            if (bl2) {
                                this.pktDec.readPktHead(i3, i, i2, nArrayArray[i2][i], this.cbI[i2][i], this.nBytes);
                            }
                            if (n33 > n29 && this.curTilePart < this.firstPackOff[n20].length - 1) {
                                ++this.curTilePart;
                                this.in.seek(this.firstPackOff[n20][this.curTilePart]);
                                n29 = this.in.getPos() + this.tilePartLen[n20][this.curTilePart] - 1 - this.tilePartHeadLen[n20][this.curTilePart];
                            }
                            if (bl = this.pktDec.readSOPMarker(this.nBytes, nArrayArray[i2][i], i2, i)) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            if (!bl2) {
                                bl = this.pktDec.readPktHead(i3, i, i2, nArrayArray[i2][i], this.cbI[i2][i], this.nBytes);
                            }
                            if (bl) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            int n34 = this.in.getPos() - n33;
                            this.pktHL.addElement(new Integer(n34));
                            bl = this.pktDec.readPktBody(i3, i, i2, nArrayArray[i2][i], this.cbI[i2][i], this.nBytes);
                            int n35 = this.in.getPos() - n33;
                            if (this.printInfo) {
                                string = string + " Pkt l=" + i3 + ",r=" + i + ",c=" + i2 + ",p=" + nArrayArray[i2][i] + ": " + n33 + ", " + n35 + ", " + n34 + "\n";
                            }
                            if (!bl) continue;
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, string);
                            }
                            return true;
                        }
                        int[] nArray2 = nArrayArray[i2];
                        int n36 = i;
                        nArray2[n36] = nArray2[n36] + 1;
                    }
                    n32 = k != n6 ? n25 + k * n21 : n16;
                }
                n31 = j != n7 ? n26 + j * n22 : n17;
            }
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        return false;
    }

    private boolean readPosCompResLy(int[][] nArray, int n, int n2, int n3, int n4, int n5) throws IOException {
        PrecInfo precInfo;
        int n6;
        int n7;
        Point point = this.getNumTiles(null);
        Point point2 = this.getTile(null);
        int n8 = this.hd.getImgULX();
        int n9 = this.hd.getImgULY();
        int n10 = n8 + this.hd.getImgWidth();
        int n11 = n9 + this.hd.getImgHeight();
        int n12 = this.getTilePartULX();
        int n13 = this.getTilePartULY();
        int n14 = this.getNomTileWidth();
        int n15 = this.getNomTileHeight();
        int n16 = point2.x == 0 ? n8 : n12 + point2.x * n14;
        int n17 = point2.y == 0 ? n9 : n13 + point2.y * n15;
        int n18 = point2.x != point.x - 1 ? n12 + (point2.x + 1) * n14 : n10;
        int n19 = point2.y != point.y - 1 ? n13 + (point2.y + 1) * n15 : n11;
        int n20 = this.getTileIdx();
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int[][] nArrayArray = new int[n5][];
        int n24 = 100000;
        int n25 = n18;
        int n26 = n19;
        int n27 = n16;
        int n28 = n17;
        for (n7 = n4; n7 < n5; ++n7) {
            for (n6 = n2; n6 < n3; ++n6) {
                if (n7 >= this.mdl.length || n6 > this.mdl[n7]) continue;
                nArrayArray[n7] = new int[this.mdl[n7] + 1];
                if (nArray[n7] != null && n6 < nArray[n7].length && nArray[n7][n6] < n24) {
                    n24 = nArray[n7][n6];
                }
                for (int i = this.pktDec.getNumPrecinct(n7, n6) - 1; i >= 0; --i) {
                    precInfo = this.pktDec.getPrecInfo(n7, n6, i);
                    if (precInfo.rgulx != n16) {
                        if (precInfo.rgulx < n25) {
                            n25 = precInfo.rgulx;
                        }
                        if (precInfo.rgulx > n27) {
                            n27 = precInfo.rgulx;
                        }
                    }
                    if (precInfo.rguly != n17) {
                        if (precInfo.rguly < n26) {
                            n26 = precInfo.rguly;
                        }
                        if (precInfo.rguly > n28) {
                            n28 = precInfo.rguly;
                        }
                    }
                    if (n23 == 0) {
                        n21 = precInfo.rgw;
                        n22 = precInfo.rgh;
                    } else {
                        n21 = MathUtil.gcd(n21, precInfo.rgw);
                        n22 = MathUtil.gcd(n22, precInfo.rgh);
                    }
                    ++n23;
                }
            }
        }
        if (n23 == 0) {
            throw new Error("Image cannot have no precinct");
        }
        n7 = (n28 - n26) / n22 + 1;
        n6 = (n27 - n25) / n21 + 1;
        boolean bl = false;
        int n29 = this.firstPackOff[n20][this.curTilePart] + this.tilePartLen[n20][this.curTilePart] - 1 - this.tilePartHeadLen[n20][this.curTilePart];
        int n30 = (Integer)this.decSpec.nls.getTileDef(n20);
        String string = this.printInfo ? "Tile " + this.getTileIdx() + " (tile-part:" + this.curTilePart + "): offset, length, header length\n" : null;
        boolean bl2 = false;
        if (((Boolean)this.decSpec.pphs.getTileDef(n20)).booleanValue()) {
            bl2 = true;
        }
        int n31 = n17;
        int n32 = n16;
        for (int i = 0; i <= n7; ++i) {
            for (int j = 0; j <= n6; ++j) {
                for (int k = n4; k < n5; ++k) {
                    if (k >= this.mdl.length) continue;
                    for (int i2 = n2; i2 < n3; ++i2) {
                        if (i2 > this.mdl[k] || nArrayArray[k][i2] >= this.pktDec.getNumPrecinct(k, i2)) continue;
                        precInfo = this.pktDec.getPrecInfo(k, i2, nArrayArray[k][i2]);
                        if (precInfo.rgulx != n32 || precInfo.rguly != n31) continue;
                        for (int i3 = n24; i3 < n; ++i3) {
                            if (i2 >= nArray[k].length || i3 < nArray[k][i2] || i3 >= n30) continue;
                            int n33 = this.in.getPos();
                            if (bl2) {
                                this.pktDec.readPktHead(i3, i2, k, nArrayArray[k][i2], this.cbI[k][i2], this.nBytes);
                            }
                            if (bl = this.pktDec.readSOPMarker(this.nBytes, nArrayArray[k][i2], k, i2)) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            if (!bl2) {
                                bl = this.pktDec.readPktHead(i3, i2, k, nArrayArray[k][i2], this.cbI[k][i2], this.nBytes);
                            }
                            if (bl) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            int n34 = this.in.getPos() - n33;
                            this.pktHL.addElement(new Integer(n34));
                            bl = this.pktDec.readPktBody(i3, i2, k, nArrayArray[k][i2], this.cbI[k][i2], this.nBytes);
                            int n35 = this.in.getPos() - n33;
                            if (this.printInfo) {
                                string = string + " Pkt l=" + i3 + ",r=" + i2 + ",c=" + k + ",p=" + nArrayArray[k][i2] + ": " + n33 + ", " + n35 + ", " + n34 + "\n";
                            }
                            if (!bl) continue;
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, string);
                            }
                            return true;
                        }
                        int[] nArray2 = nArrayArray[k];
                        int n36 = i2;
                        nArray2[n36] = nArray2[n36] + 1;
                    }
                }
                n32 = j != n6 ? n25 + j * n21 : n16;
            }
            n31 = i != n7 ? n26 + i * n22 : n17;
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        return false;
    }

    private boolean readCompPosResLy(int[][] nArray, int n, int n2, int n3, int n4, int n5) throws IOException {
        PrecInfo precInfo;
        int n6;
        int n7;
        Point point = this.getNumTiles(null);
        Point point2 = this.getTile(null);
        int n8 = this.hd.getImgULX();
        int n9 = this.hd.getImgULY();
        int n10 = n8 + this.hd.getImgWidth();
        int n11 = n9 + this.hd.getImgHeight();
        int n12 = this.getTilePartULX();
        int n13 = this.getTilePartULY();
        int n14 = this.getNomTileWidth();
        int n15 = this.getNomTileHeight();
        int n16 = point2.x == 0 ? n8 : n12 + point2.x * n14;
        int n17 = point2.y == 0 ? n9 : n13 + point2.y * n15;
        int n18 = point2.x != point.x - 1 ? n12 + (point2.x + 1) * n14 : n10;
        int n19 = point2.y != point.y - 1 ? n13 + (point2.y + 1) * n15 : n11;
        int n20 = this.getTileIdx();
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int[][] nArrayArray = new int[n5][];
        int n24 = 100000;
        int n25 = n18;
        int n26 = n19;
        int n27 = n16;
        int n28 = n17;
        for (n7 = n4; n7 < n5; ++n7) {
            for (n6 = n2; n6 < n3; ++n6) {
                if (n7 >= this.mdl.length || n6 > this.mdl[n7]) continue;
                nArrayArray[n7] = new int[this.mdl[n7] + 1];
                if (nArray[n7] != null && n6 < nArray[n7].length && nArray[n7][n6] < n24) {
                    n24 = nArray[n7][n6];
                }
                for (int i = this.pktDec.getNumPrecinct(n7, n6) - 1; i >= 0; --i) {
                    precInfo = this.pktDec.getPrecInfo(n7, n6, i);
                    if (precInfo.rgulx != n16) {
                        if (precInfo.rgulx < n25) {
                            n25 = precInfo.rgulx;
                        }
                        if (precInfo.rgulx > n27) {
                            n27 = precInfo.rgulx;
                        }
                    }
                    if (precInfo.rguly != n17) {
                        if (precInfo.rguly < n26) {
                            n26 = precInfo.rguly;
                        }
                        if (precInfo.rguly > n28) {
                            n28 = precInfo.rguly;
                        }
                    }
                    if (n23 == 0) {
                        n21 = precInfo.rgw;
                        n22 = precInfo.rgh;
                    } else {
                        n21 = MathUtil.gcd(n21, precInfo.rgw);
                        n22 = MathUtil.gcd(n22, precInfo.rgh);
                    }
                    ++n23;
                }
            }
        }
        if (n23 == 0) {
            throw new Error("Image cannot have no precinct");
        }
        n7 = (n28 - n26) / n22 + 1;
        n6 = (n27 - n25) / n21 + 1;
        boolean bl = false;
        int n29 = this.firstPackOff[n20][this.curTilePart] + this.tilePartLen[n20][this.curTilePart] - 1 - this.tilePartHeadLen[n20][this.curTilePart];
        int n30 = (Integer)this.decSpec.nls.getTileDef(n20);
        String string = this.printInfo ? "Tile " + this.getTileIdx() + " (tile-part:" + this.curTilePart + "): offset, length, header length\n" : null;
        boolean bl2 = false;
        if (((Boolean)this.decSpec.pphs.getTileDef(n20)).booleanValue()) {
            bl2 = true;
        }
        for (int i = n4; i < n5; ++i) {
            if (i >= this.mdl.length) continue;
            int n31 = n17;
            int n32 = n16;
            for (int j = 0; j <= n7; ++j) {
                for (int k = 0; k <= n6; ++k) {
                    for (int i2 = n2; i2 < n3; ++i2) {
                        if (i2 > this.mdl[i] || nArrayArray[i][i2] >= this.pktDec.getNumPrecinct(i, i2)) continue;
                        precInfo = this.pktDec.getPrecInfo(i, i2, nArrayArray[i][i2]);
                        if (precInfo.rgulx != n32 || precInfo.rguly != n31) continue;
                        for (int i3 = n24; i3 < n; ++i3) {
                            if (i2 >= nArray[i].length || i3 < nArray[i][i2]) continue;
                            int n33 = this.in.getPos();
                            if (bl2) {
                                this.pktDec.readPktHead(i3, i2, i, nArrayArray[i][i2], this.cbI[i][i2], this.nBytes);
                            }
                            if (n33 > n29 && this.curTilePart < this.firstPackOff[n20].length - 1) {
                                ++this.curTilePart;
                                this.in.seek(this.firstPackOff[n20][this.curTilePart]);
                                n29 = this.in.getPos() + this.tilePartLen[n20][this.curTilePart] - 1 - this.tilePartHeadLen[n20][this.curTilePart];
                            }
                            if (bl = this.pktDec.readSOPMarker(this.nBytes, nArrayArray[i][i2], i, i2)) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            if (!bl2) {
                                bl = this.pktDec.readPktHead(i3, i2, i, nArrayArray[i][i2], this.cbI[i][i2], this.nBytes);
                            }
                            if (bl) {
                                if (this.printInfo) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            int n34 = this.in.getPos() - n33;
                            this.pktHL.addElement(new Integer(n34));
                            bl = this.pktDec.readPktBody(i3, i2, i, nArrayArray[i][i2], this.cbI[i][i2], this.nBytes);
                            int n35 = this.in.getPos() - n33;
                            if (this.printInfo) {
                                string = string + " Pkt l=" + i3 + ",r=" + i2 + ",c=" + i + ",p=" + nArrayArray[i][i2] + ": " + n33 + ", " + n35 + ", " + n34 + "\n";
                            }
                            if (!bl) continue;
                            if (this.printInfo) {
                                FacilityManager.getMsgLogger().printmsg(1, string);
                            }
                            return true;
                        }
                        int[] nArray2 = nArrayArray[i];
                        int n36 = i2;
                        nArray2[n36] = nArray2[n36] + 1;
                    }
                    n32 = k != n6 ? n25 + k * n21 : n16;
                }
                n31 = j != n7 ? n26 + j * n22 : n17;
            }
        }
        if (this.printInfo) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        return false;
    }

    private void readTilePkts(int n) throws IOException {
        int n2;
        int n3;
        int n4;
        Object object;
        this.pktHL = new Vector();
        int n5 = this.nBytes[n];
        int n6 = (Integer)this.decSpec.nls.getTileDef(n);
        if (((Boolean)this.decSpec.pphs.getTileDef(n)).booleanValue()) {
            object = this.hd.getPackedPktHead(n);
            this.cbI = this.pktDec.restart(this.nc, this.mdl, n6, this.cbI, true, (ByteArrayInputStream)object);
        } else {
            this.cbI = this.pktDec.restart(this.nc, this.mdl, n6, this.cbI, false, null);
        }
        object = (int[][])this.decSpec.pcs.getTileDef(n);
        int n7 = object == null ? 1 : ((Object)object).length;
        int[][] nArray = new int[n7][6];
        int n8 = 0;
        nArray[0][1] = 0;
        if (object == null) {
            nArray[n8][0] = (Integer)this.decSpec.pos.getTileDef(n);
            nArray[n8][1] = n6;
            nArray[n8][2] = 0;
            nArray[n8][3] = this.decSpec.dls.getMaxInTile(n) + 1;
            nArray[n8][4] = 0;
            nArray[n8][5] = this.nc;
        } else {
            for (n8 = 0; n8 < n7; ++n8) {
                nArray[n8][0] = (int)object[n8][5];
                nArray[n8][1] = (int)object[n8][2];
                nArray[n8][2] = (int)object[n8][0];
                nArray[n8][3] = (int)object[n8][3];
                nArray[n8][4] = (int)object[n8][1];
                nArray[n8][5] = (int)object[n8][4];
            }
        }
        try {
            if (this.isTruncMode && this.firstPackOff == null || this.firstPackOff[n] == null) {
                return;
            }
            this.in.seek(this.firstPackOff[n][0]);
        }
        catch (EOFException eOFException) {
            FacilityManager.getMsgLogger().printmsg(2, "Codestream truncated in tile " + n);
            return;
        }
        this.curTilePart = 0;
        boolean bl = false;
        int n9 = this.nBytes[n];
        int[][] nArrayArray = new int[this.nc][];
        for (n4 = 0; n4 < this.nc; ++n4) {
            nArrayArray[n4] = new int[(Integer)this.decSpec.dls.getTileCompVal(n, n4) + 1];
        }
        for (n4 = 0; n4 < n7; ++n4) {
            int n10 = nArray[n4][1];
            int n11 = nArray[n4][2];
            int n12 = nArray[n4][3];
            int n13 = nArray[n4][4];
            int n14 = nArray[n4][5];
            switch (nArray[n4][0]) {
                case 0: {
                    bl = this.readLyResCompPos(nArrayArray, n10, n11, n12, n13, n14);
                    break;
                }
                case 1: {
                    bl = this.readResLyCompPos(nArrayArray, n10, n11, n12, n13, n14);
                    break;
                }
                case 2: {
                    bl = this.readResPosCompLy(nArrayArray, n10, n11, n12, n13, n14);
                    break;
                }
                case 3: {
                    bl = this.readPosCompResLy(nArrayArray, n10, n11, n12, n13, n14);
                    break;
                }
                case 4: {
                    bl = this.readCompPosResLy(nArrayArray, n10, n11, n12, n13, n14);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not recognized progression type");
                }
            }
            for (n3 = n13; n3 < n14; ++n3) {
                if (n3 >= nArrayArray.length) continue;
                for (n2 = n11; n2 < n12; ++n2) {
                    if (n2 >= nArrayArray[n3].length) continue;
                    nArrayArray[n3][n2] = n10;
                }
            }
            if (!bl && !this.usePOCQuit) {
                continue;
            }
            break;
        }
        if (this.isTruncMode) {
            this.anbytes += n9 - this.nBytes[n];
            if (bl) {
                this.nBytes[n] = 0;
            }
        } else if (this.nBytes[n] < this.totTileLen[n] - this.totTileHeadLen[n]) {
            int n15;
            n2 = 0;
            int[] nArray2 = new int[this.pktHL.size()];
            for (n15 = this.pktHL.size() - 1; n15 >= 0; --n15) {
                nArray2[n15] = (Integer)this.pktHL.elementAt(n15);
            }
            n3 = 0;
            for (n15 = 0; n15 < n6; ++n15) {
                int n16;
                if (this.cbI == null) continue;
                int n17 = this.cbI.length;
                int n18 = 0;
                for (n16 = 0; n16 < n17; ++n16) {
                    if (this.cbI[n16] == null || this.cbI[n16].length <= n18) continue;
                    n18 = this.cbI[n16].length;
                }
                for (n16 = 0; n16 < n18; ++n16) {
                    int n19;
                    int n20 = 0;
                    for (n19 = 0; n19 < n17; ++n19) {
                        if (this.cbI[n19] == null || this.cbI[n19][n16] == null || this.cbI[n19][n16].length <= n20) continue;
                        n20 = this.cbI[n19][n16].length;
                    }
                    for (n19 = 0; n19 < n20; ++n19) {
                        int n21;
                        if (n16 == 0 && n19 != 0 || n16 != 0 && n19 == 0) continue;
                        int n22 = 0;
                        for (n21 = 0; n21 < n17; ++n21) {
                            if (this.cbI[n21] == null || this.cbI[n21][n16] == null || this.cbI[n21][n16][n19] == null || this.cbI[n21][n16][n19].length <= n22) continue;
                            n22 = this.cbI[n21][n16][n19].length;
                        }
                        for (n21 = 0; n21 < n22; ++n21) {
                            int n23;
                            int n24 = 0;
                            for (n23 = 0; n23 < n17; ++n23) {
                                if (this.cbI[n23] == null || this.cbI[n23][n16] == null || this.cbI[n23][n16][n19] == null || this.cbI[n23][n16][n19][n21] == null || this.cbI[n23][n16][n19][n21].length <= n24) continue;
                                n24 = this.cbI[n23][n16][n19][n21].length;
                            }
                            for (n23 = 0; n23 < n24; ++n23) {
                                for (int i = 0; i < n17; ++i) {
                                    if (this.cbI[i] == null || this.cbI[i][n16] == null || this.cbI[i][n16][n19] == null || this.cbI[i][n16][n19][n21] == null || this.cbI[i][n16][n19][n21][n23] == null) continue;
                                    CBlkInfo cBlkInfo = this.cbI[i][n16][n19][n21][n23];
                                    if (n3 == 0) {
                                        if (this.nBytes[n] < nArray2[cBlkInfo.pktIdx[n15]]) {
                                            n2 = 1;
                                            n3 = 1;
                                        } else if (n2 == 0) {
                                            int n25 = n;
                                            this.nBytes[n25] = this.nBytes[n25] - nArray2[cBlkInfo.pktIdx[n15]];
                                            this.anbytes += nArray2[cBlkInfo.pktIdx[n15]];
                                            nArray2[cBlkInfo.pktIdx[n15]] = 0;
                                        }
                                    }
                                    if (cBlkInfo.len[n15] == 0) continue;
                                    if (cBlkInfo.len[n15] < this.nBytes[n] && n3 == 0) {
                                        int n26 = n;
                                        this.nBytes[n26] = this.nBytes[n26] - cBlkInfo.len[n15];
                                        this.anbytes += cBlkInfo.len[n15];
                                        continue;
                                    }
                                    cBlkInfo.ntp[n15] = 0;
                                    cBlkInfo.off[n15] = 0;
                                    cBlkInfo.len[n15] = 0;
                                    n3 = 1;
                                }
                            }
                        }
                    }
                }
            }
        } else {
            this.anbytes += this.totTileLen[n] - this.totTileHeadLen[n];
            if (n < this.getNumTiles() - 1) {
                int n27 = n + 1;
                this.nBytes[n27] = this.nBytes[n27] + (this.nBytes[n] - (this.totTileLen[n] - this.totTileHeadLen[n]));
            }
        }
        this.nBytes[n] = n5;
    }

    public void setTile(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.ntX || n2 >= this.ntY) {
            throw new IllegalArgumentException();
        }
        int n3 = n2 * this.ntX + n;
        try {
            this.initTile(n3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n3 == 0) {
            this.anbytes = this.headLen;
            if (!this.isTruncMode) {
                this.anbytes += 2;
            }
            for (int i = 0; i < this.nt; ++i) {
                this.nBytes[i] = this.baknBytes[i];
            }
        }
        this.ctX = n;
        this.ctY = n2;
        int n4 = n == 0 ? this.ax : this.px + n * this.ntW;
        int n5 = n2 == 0 ? this.ay : this.py + n2 * this.ntH;
        for (int i = this.nc - 1; i >= 0; --i) {
            this.culx[i] = (n4 + this.hd.getCompSubsX(i) - 1) / this.hd.getCompSubsX(i);
            this.culy[i] = (n5 + this.hd.getCompSubsY(i) - 1) / this.hd.getCompSubsY(i);
            this.offX[i] = (this.px + n * this.ntW + this.hd.getCompSubsX(i) - 1) / this.hd.getCompSubsX(i);
            this.offY[i] = (this.py + n2 * this.ntH + this.hd.getCompSubsY(i) - 1) / this.hd.getCompSubsY(i);
        }
        this.subbTrees = new SubbandSyn[this.nc];
        this.mdl = new int[this.nc];
        this.derived = new boolean[this.nc];
        this.params = new StdDequantizerParams[this.nc];
        this.gb = new int[this.nc];
        for (int i = 0; i < this.nc; ++i) {
            this.derived[i] = this.decSpec.qts.isDerived(n3, i);
            this.params[i] = (StdDequantizerParams)this.decSpec.qsss.getTileCompVal(n3, i);
            this.gb[i] = (Integer)this.decSpec.gbs.getTileCompVal(n3, i);
            this.mdl[i] = (Integer)this.decSpec.dls.getTileCompVal(n3, i);
            this.subbTrees[i] = new SubbandSyn(this.getTileCompWidth(n3, i, this.mdl[i]), this.getTileCompHeight(n3, i, this.mdl[i]), this.getResULX(i, this.mdl[i]), this.getResULY(i, this.mdl[i]), this.mdl[i], this.decSpec.wfs.getHFilters(n3, i), this.decSpec.wfs.getVFilters(n3, i));
            this.initSubbandsFields(i, this.subbTrees[i]);
        }
        try {
            this.readTilePkts(n3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new Error("IO Error when reading tile " + n + " x " + n2);
        }
    }

    public void nextTile() {
        if (this.ctX == this.ntX - 1 && this.ctY == this.ntY - 1) {
            throw new NoNextElementException();
        }
        if (this.ctX < this.ntX - 1) {
            this.setTile(this.ctX + 1, this.ctY);
        } else {
            this.setTile(0, this.ctY + 1);
        }
    }

    public DecLyrdCBlk getCodeBlock(int n, int n2, int n3, SubbandSyn subbandSyn, int n4, int n5, DecLyrdCBlk decLyrdCBlk) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        CBlkInfo cBlkInfo;
        int n11 = this.getTileIdx();
        int n12 = subbandSyn.resLvl;
        int n13 = subbandSyn.sbandIdx;
        int n14 = (Integer)this.decSpec.nls.getTileDef(n11);
        int n15 = (Integer)this.decSpec.ecopts.getTileCompVal(n11, n);
        if (n5 < 0) {
            n5 = n14 - n4 + 1;
        }
        if (this.lQuit != -1 && n4 + n5 > this.lQuit) {
            n5 = this.lQuit - n4;
        }
        int n16 = this.getSynSubbandTree((int)n11, (int)n).resLvl;
        try {
            cBlkInfo = this.cbI[n][n12][n13][n2][n3];
            if (n4 < 1 || n4 > n14 || n4 + n5 - 1 > n14) {
                throw new IllegalArgumentException();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Code-block (t:" + n11 + ", c:" + n + ", r:" + n12 + ", s:" + n13 + ", " + n2 + "x" + n3 + ") not found in codestream");
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("Code-block (t:" + n11 + ", c:" + n + ", r:" + n12 + ", s:" + n13 + ", " + n2 + "x" + n3 + ") not found in bit stream");
        }
        if (decLyrdCBlk == null) {
            decLyrdCBlk = new DecLyrdCBlk();
        }
        decLyrdCBlk.m = n2;
        decLyrdCBlk.n = n3;
        decLyrdCBlk.nl = 0;
        decLyrdCBlk.dl = 0;
        decLyrdCBlk.nTrunc = 0;
        if (cBlkInfo == null) {
            decLyrdCBlk.skipMSBP = 0;
            decLyrdCBlk.prog = false;
            decLyrdCBlk.uly = 0;
            decLyrdCBlk.ulx = 0;
            decLyrdCBlk.h = 0;
            decLyrdCBlk.w = 0;
            return decLyrdCBlk;
        }
        decLyrdCBlk.skipMSBP = cBlkInfo.msbSkipped;
        decLyrdCBlk.ulx = cBlkInfo.ulx;
        decLyrdCBlk.uly = cBlkInfo.uly;
        decLyrdCBlk.w = cBlkInfo.w;
        decLyrdCBlk.h = cBlkInfo.h;
        decLyrdCBlk.ftpIdx = 0;
        for (n10 = 0; n10 < cBlkInfo.len.length && cBlkInfo.len[n10] == 0; ++n10) {
            decLyrdCBlk.ftpIdx += cBlkInfo.ntp[n10];
        }
        for (n10 = n4 - 1; n10 < n4 + n5 - 1; ++n10) {
            ++decLyrdCBlk.nl;
            decLyrdCBlk.dl += cBlkInfo.len[n10];
            decLyrdCBlk.nTrunc += cBlkInfo.ntp[n10];
        }
        if ((n15 & 4) != 0) {
            n9 = decLyrdCBlk.nTrunc - decLyrdCBlk.ftpIdx;
        } else if ((n15 & 1) != 0) {
            if (decLyrdCBlk.nTrunc <= 10) {
                n9 = 1;
            } else {
                n9 = 1;
                for (n8 = decLyrdCBlk.ftpIdx; n8 < decLyrdCBlk.nTrunc; ++n8) {
                    if (n8 < 9 || (n7 = (n8 + 2) % 3) != 1 && n7 != 2) continue;
                    ++n9;
                }
            }
        } else {
            n9 = 1;
        }
        if (decLyrdCBlk.data == null || decLyrdCBlk.data.length < decLyrdCBlk.dl) {
            decLyrdCBlk.data = new byte[decLyrdCBlk.dl];
        }
        if (n9 > 1 && (decLyrdCBlk.tsLengths == null || decLyrdCBlk.tsLengths.length < n9)) {
            decLyrdCBlk.tsLengths = new int[n9];
        } else if (n9 > 1 && (n15 & 5) == 1) {
            ArrayUtil.intArraySet(decLyrdCBlk.tsLengths, 0);
        }
        int n17 = -1;
        n8 = decLyrdCBlk.ftpIdx;
        int n18 = decLyrdCBlk.ftpIdx;
        int n19 = 0;
        for (n10 = n4 - 1; n10 < n4 + n5 - 1; ++n10) {
            int n20;
            n18 += cBlkInfo.ntp[n10];
            if (cBlkInfo.len[n10] == 0) continue;
            try {
                this.in.seek(cBlkInfo.off[n10]);
                this.in.readFully(decLyrdCBlk.data, n17 + 1, cBlkInfo.len[n10]);
                n17 += cBlkInfo.len[n10];
            }
            catch (IOException iOException) {
                JJ2KExceptionHandler.handleException(iOException);
            }
            if (n9 == 1) continue;
            if ((n15 & 4) != 0) {
                n20 = 0;
                while (n8 < n18) {
                    decLyrdCBlk.tsLengths[n19++] = cBlkInfo.segLen[n10] != null ? cBlkInfo.segLen[n10][n20] : cBlkInfo.len[n10];
                    ++n20;
                    ++n8;
                }
                continue;
            }
            n20 = 0;
            while (n8 < n18) {
                if (n8 >= 9 && (n7 = (n8 + 2) % 3) != 0) {
                    if (cBlkInfo.segLen[n10] != null) {
                        int n21 = n19++;
                        decLyrdCBlk.tsLengths[n21] = decLyrdCBlk.tsLengths[n21] + cBlkInfo.segLen[n10][n20++];
                        int n22 = n10;
                        cBlkInfo.len[n22] = cBlkInfo.len[n22] - cBlkInfo.segLen[n10][n20 - 1];
                    } else {
                        int n23 = n19++;
                        decLyrdCBlk.tsLengths[n23] = decLyrdCBlk.tsLengths[n23] + cBlkInfo.len[n10];
                        cBlkInfo.len[n10] = 0;
                    }
                }
                ++n8;
            }
            if (cBlkInfo.segLen[n10] != null && n20 < cBlkInfo.segLen[n10].length) {
                int n24 = n19;
                decLyrdCBlk.tsLengths[n24] = decLyrdCBlk.tsLengths[n24] + cBlkInfo.segLen[n10][n20];
                int n25 = n10;
                cBlkInfo.len[n25] = cBlkInfo.len[n25] - cBlkInfo.segLen[n10][n20];
                continue;
            }
            if (n19 >= n9) continue;
            int n26 = n19;
            decLyrdCBlk.tsLengths[n26] = decLyrdCBlk.tsLengths[n26] + cBlkInfo.len[n10];
            cBlkInfo.len[n10] = 0;
        }
        if (n9 == 1 && decLyrdCBlk.tsLengths != null) {
            decLyrdCBlk.tsLengths[0] = decLyrdCBlk.dl;
        }
        if ((n6 = n4 + n5 - 1) < n14 - 1) {
            for (n10 = n6 + 1; n10 < n14; ++n10) {
                if (cBlkInfo.len[n10] == 0) continue;
                decLyrdCBlk.prog = true;
            }
        }
        return decLyrdCBlk;
    }
}

