/*
 * Decompiled with CFR 0.152.
 */
package be.abeel.io;

import be.abeel.net.URIFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineIterator
implements Iterable<String>,
Iterator<String>,
Closeable {
    private BufferedReader in = null;
    private String next = null;
    private boolean skipBlanks = false;
    private boolean skipComments = false;
    private ArrayList<String> commentIdentifiers = new ArrayList();

    public LineIterator(String input, boolean skipComments, boolean skipBlanks) {
        this(LineIterator.stream(input), skipComments, skipBlanks);
    }

    public LineIterator(String file) {
        this(file, false, false);
    }

    public LineIterator(File f) {
        this(LineIterator.stream(f));
    }

    public LineIterator(File f, boolean skipComments, boolean skipBlanks) {
        this(LineIterator.stream(f), skipComments, skipBlanks);
    }

    private static InputStream stream(File f) {
        try {
            return new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static InputStream stream(String input) {
        try {
            if (input.startsWith("http://")) {
                return URIFactory.url(input).openStream();
            }
            return LineIterator.stream(new File(input));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public LineIterator(InputStream stream) {
        this(new InputStreamReader(LineIterator.wrap(stream)));
    }

    private static InputStream wrap(InputStream stream) {
        try {
            stream = new PushbackInputStream(stream, 2);
            PushbackInputStream tmp = (PushbackInputStream)stream;
            int a = tmp.read();
            int b = tmp.read();
            tmp.unread(b);
            tmp.unread(a);
            if (a == 31 && b == 139) {
                stream = new GZIPInputStream(stream);
            }
            return stream;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public LineIterator(Reader reader, boolean skipComments, boolean skipBlanks) {
        try {
            this.in = new BufferedReader(reader);
            this.next = this.in.readLine();
            if (this.next == null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.commentIdentifiers.add("#");
        this.commentIdentifiers.add("//");
        if (skipComments) {
            this.setSkipComments(true);
        }
        if (skipBlanks) {
            this.setSkipBlanks(true);
        }
    }

    public LineIterator(InputStream stream, boolean skipComments, boolean skipBlanks) {
        this(new InputStreamReader(LineIterator.wrap(stream)), skipComments, skipBlanks);
    }

    public LineIterator(Reader irs) {
        this(irs, false, false);
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    private void getNext() {
        try {
            this.next = this.in.readLine();
            while (this.next != null && (this.skipBlanks && this.next.length() == 0 || this.skipComments && this.isComment(this.next))) {
                this.next = this.in.readLine();
            }
            if (this.next == null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isComment(String line) {
        for (String prefix : this.commentIdentifiers) {
            if (!line.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String next() {
        String oldNext = this.next;
        this.getNext();
        return oldNext;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This operation is not possible on a LineIterator");
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.next = null;
    }

    public final void setSkipBlanks(boolean skipBlanks) {
        this.skipBlanks = skipBlanks;
        if (this.next != null && this.skipBlanks && this.next.length() == 0) {
            this.getNext();
        }
    }

    public final void setSkipComments(boolean skipComments) {
        this.skipComments = skipComments;
        if (this.skipComments && this.next != null && this.isComment(this.next)) {
            this.getNext();
        }
    }

    public final void setCommentIdentifier(String commentIdentifier) {
        this.commentIdentifiers.clear();
        this.addCommentIdentifier(commentIdentifier);
    }

    public final void addCommentIdentifier(String commentIdentifier) {
        this.commentIdentifiers.add(commentIdentifier);
        if (this.next != null && this.skipComments && this.isComment(this.next)) {
            this.getNext();
        }
    }

    public String peek() {
        return this.next;
    }
}

