/*
 * Decompiled with CFR 0.152.
 */
package be.abeel.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnIterator
implements Iterable<String[]>,
Iterator<String[]>,
Closeable {
    private BufferedReader in = null;
    private String next = null;
    private boolean skipBlanks = false;
    private boolean skipComments = false;
    private String commentIdentifier = "#";
    private String delim = "\t";

    public ColumnIterator(String file) {
        this(new File(file));
    }

    public ColumnIterator(File f) {
        try {
            this.in = new BufferedReader(new FileReader(f));
            this.next = this.in.readLine();
            if (this.next == null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ColumnIterator(InputStream stream) {
        this(new InputStreamReader(stream));
    }

    public ColumnIterator(Reader reader) {
        try {
            this.in = new BufferedReader(reader);
            this.next = this.in.readLine();
            if (this.next == null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<String[]> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    private void getNext() {
        try {
            this.next = this.in.readLine();
            while (this.next != null && (this.skipBlanks && this.next.length() == 0 || this.skipComments && this.next.startsWith(this.commentIdentifier))) {
                this.next = this.in.readLine();
            }
            if (this.next == null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String[] next() {
        String oldNext = this.next;
        this.getNext();
        return oldNext.split(this.delim);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This operation is not possible on a ColumnIterator");
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.next = null;
    }

    public final void setSkipBlanks(boolean skipBlanks) {
        this.skipBlanks = skipBlanks;
        if (this.next != null && this.skipBlanks && this.next.length() == 0) {
            this.getNext();
        }
    }

    public final void setSkipComments(boolean skipComments) {
        this.skipComments = skipComments;
        if (this.skipComments && this.next != null && this.next.startsWith(this.commentIdentifier)) {
            this.getNext();
        }
    }

    public final void setCommentIdentifier(String commentIdentifier) {
        this.commentIdentifier = commentIdentifier;
        if (this.next != null && this.skipComments && this.next.startsWith(commentIdentifier)) {
            this.getNext();
        }
    }

    public final void setDelimiter(String delim) {
        this.delim = delim;
    }
}

