/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.dialogs.support;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.esa.snap.engine_utilities.db.ProductDB;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.graphbuilder.rcp.dialogs.support.FileTableModel;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;

public abstract class BaseFileModel
extends AbstractTableModel
implements FileTableModel {
    protected String[] titles = null;
    protected Class[] types = null;
    protected int[] widths = null;
    protected final List<File> fileList = new ArrayList<File>(10);
    protected final List<TableData> dataList = new ArrayList<TableData>(10);

    public BaseFileModel() {
        this.setColumnData();
        this.addBlankFile();
    }

    protected abstract void setColumnData();

    protected abstract TableData createFileStats(File var1);

    protected abstract TableData createFileStats(ProductEntry var1);

    @Override
    public File[] getFileList() {
        return this.fileList.toArray(new File[this.fileList.size()]);
    }

    private static ProductEntry getProductEntry(File file) {
        try {
            return ProductDB.instance().getProductEntry(file);
        }
        catch (Exception e) {
            if (SnapApp.getDefault() != null) {
                Dialogs.showError((String)("Error getting product entry: " + e.getMessage()));
            }
            return null;
        }
    }

    @Override
    public void addFile(File file) {
        this.fileList.add(file);
        this.clearBlankFile();
        ProductEntry existingEntry = BaseFileModel.getProductEntry(file);
        if (existingEntry != null) {
            this.dataList.add(this.createFileStats(existingEntry));
        } else {
            this.dataList.add(this.createFileStats(file));
        }
        this.fireTableDataChanged();
    }

    @Override
    public void addFile(ProductEntry entry) {
        this.fileList.add(entry.getFile());
        this.clearBlankFile();
        this.dataList.add(this.createFileStats(entry));
        this.fireTableDataChanged();
    }

    public void addFile(File file, String[] values) {
        this.fileList.add(file);
        this.clearBlankFile();
        this.dataList.add(new TableData(values));
        this.fireTableDataChanged();
    }

    @Override
    public void removeFile(int index) {
        this.fileList.remove(index);
        this.dataList.remove(index);
        this.fireTableDataChanged();
    }

    @Override
    public void move(int oldIndex, int newIndex) {
        if (oldIndex < 1 && oldIndex > newIndex || oldIndex > this.fileList.size() || newIndex < 0 || newIndex >= this.fileList.size()) {
            return;
        }
        File file = this.fileList.get(oldIndex);
        TableData data = this.dataList.get(oldIndex);
        this.fileList.remove(oldIndex);
        this.dataList.remove(oldIndex);
        this.fileList.add(newIndex, file);
        this.dataList.add(newIndex, data);
        this.fireTableDataChanged();
    }

    @Override
    public int getIndexOf(File file) {
        return this.fileList.indexOf(file);
    }

    private void addBlankFile() {
        this.addFile(new File(""));
    }

    protected void clearBlankFile() {
        if (this.fileList.size() > 1 && this.fileList.get(0).getName().isEmpty()) {
            this.removeFile(0);
        }
    }

    @Override
    public void clear() {
        this.fileList.clear();
        this.dataList.clear();
        this.addBlankFile();
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.dataList.size();
    }

    @Override
    public int getColumnCount() {
        return this.titles.length;
    }

    @Override
    public String getColumnName(int c) {
        return this.titles[c];
    }

    public Class getColumnClass(int c) {
        return this.types[c];
    }

    @Override
    public Object getValueAt(int r, int c) {
        return this.dataList.get((int)r).data[c];
    }

    @Override
    public File getFileAt(int index) {
        return this.fileList.get(index);
    }

    @Override
    public File[] getFilesAt(int[] indices) {
        ArrayList<File> files = new ArrayList<File>(indices.length);
        for (int i : indices) {
            files.add(this.fileList.get(i));
        }
        return files.toArray(new File[files.size()]);
    }

    @Override
    public void setColumnWidths(TableColumnModel columnModel) {
        for (int i = 0; i < this.widths.length; ++i) {
            columnModel.getColumn(i).setMinWidth(this.widths[i]);
            columnModel.getColumn(i).setPreferredWidth(this.widths[i]);
            columnModel.getColumn(i).setWidth(this.widths[i]);
        }
    }

    public class TableData {
        protected final String[] data;

        public TableData() {
            this.data = new String[BaseFileModel.this.titles.length];
        }

        public TableData(File file) {
            this.data = new String[BaseFileModel.this.titles.length];
            this.readProduct(file);
        }

        public TableData(ProductEntry entry) {
            this.data = new String[BaseFileModel.this.titles.length];
            this.updateData(entry);
        }

        public TableData(String[] values) {
            this.data = new String[BaseFileModel.this.titles.length];
            System.arraycopy(values, 0, this.data, 0, this.data.length);
        }

        protected void updateData(File file) throws IOException {
        }

        protected void updateData(ProductEntry entry) {
        }

        private void readProduct(final File file) {
            SwingWorker worker = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    block6: {
                        try {
                            if (file.getName().isEmpty()) break block6;
                            try {
                                TableData.this.updateData(file);
                            }
                            catch (Exception ex) {
                                TableData.this.data[0] = file.getName();
                                for (int i = 1; i < TableData.this.data.length; ++i) {
                                    TableData.this.data[i] = "";
                                }
                            }
                        }
                        finally {
                            BaseFileModel.this.fireTableDataChanged();
                        }
                    }
                    return null;
                }
            };
            worker.execute();
        }
    }
}

