/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.dialogs;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.common.ReadOp;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.engine_utilities.db.CommonReaders;
import org.esa.snap.engine_utilities.util.MemUtils;
import org.esa.snap.engine_utilities.util.ProductFunctions;
import org.esa.snap.engine_utilities.util.ResourceUtils;
import org.esa.snap.graphbuilder.gpf.ui.ProductSetReaderOpUI;
import org.esa.snap.graphbuilder.gpf.ui.SourceUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.dialogs.PromptDialog;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphDialog;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphExecuter;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphNode;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphPanel;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphsMenu;
import org.esa.snap.graphbuilder.rcp.dialogs.support.ProgressBarProgressMonitor;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.tango.TangoIcons;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.ModelessDialog;
import org.openide.util.HelpCtx;

public class GraphBuilderDialog
extends ModelessDialog
implements Observer,
GraphDialog {
    private static final ImageIcon processIcon = TangoIcons.actions_media_playback_start((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon saveIcon = TangoIcons.actions_document_save_as((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon loadIcon = TangoIcons.actions_document_open((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon clearIcon = TangoIcons.actions_edit_clear((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon helpIcon = TangoIcons.apps_help_browser((TangoIcons.Res)TangoIcons.Res.R22);
    private static final ImageIcon infoIcon = TangoIcons.apps_accessories_text_editor((TangoIcons.Res)TangoIcons.Res.R22);
    private final AppContext appContext;
    private GraphPanel graphPanel = null;
    private JLabel statusLabel = null;
    private String lastWarningMsg = "";
    private JPanel progressPanel = null;
    private JProgressBar progressBar = null;
    private ProgressBarProgressMonitor progBarMonitor = null;
    private JLabel progressMsgLabel = null;
    private boolean initGraphEnabled = true;
    private final GraphExecuter graphEx;
    private boolean isProcessing = false;
    private boolean allowGraphBuilding = true;
    private final List<ProcessingListener> listenerList = new ArrayList<ProcessingListener>(1);
    private static final String LAST_GRAPH_PATH = "graphbuilder.last_graph_path";
    private JTabbedPane tabbedPanel = null;

    public GraphBuilderDialog(AppContext theAppContext, String title, String helpID) {
        this(theAppContext, title, helpID, true);
    }

    public GraphBuilderDialog(AppContext theAppContext, String title, String helpID, boolean allowGraphBuilding) {
        super(theAppContext.getApplicationWindow(), title, 0, helpID);
        this.allowGraphBuilding = allowGraphBuilding;
        this.appContext = theAppContext;
        this.graphEx = new GraphExecuter();
        this.graphEx.addObserver(this);
        String lastDir = SnapApp.getDefault().getPreferences().get(LAST_GRAPH_PATH, ResourceUtils.getGraphFolder((String)"").toFile().getAbsolutePath());
        if (new File(lastDir).exists()) {
            SnapApp.getDefault().getPreferences().put(LAST_GRAPH_PATH, lastDir);
        }
        this.initUI();
    }

    private void initUI() {
        if (this.allowGraphBuilding) {
            super.getJDialog().setMinimumSize(new Dimension(650, 750));
        } else {
            super.getJDialog().setMinimumSize(new Dimension(650, 500));
        }
        JPanel mainPanel = new JPanel(new BorderLayout(4, 4));
        JPanel northPanel = new JPanel(new BorderLayout(4, 4));
        if (this.allowGraphBuilding) {
            this.graphPanel = new GraphPanel(this.graphEx);
            this.graphPanel.setBackground(Color.WHITE);
            this.graphPanel.setPreferredSize(new Dimension(1500, 1000));
            JScrollPane scrollPane = new JScrollPane(this.graphPanel);
            scrollPane.setPreferredSize(new Dimension(300, 300));
            northPanel.add((Component)scrollPane, "Center");
            mainPanel.add((Component)northPanel, "North");
        }
        JPanel midPanel = new JPanel(new BorderLayout(4, 4));
        this.tabbedPanel = new JTabbedPane();
        this.tabbedPanel.setTabLayoutPolicy(1);
        this.tabbedPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GraphBuilderDialog.this.ValidateAllNodes();
            }
        });
        this.statusLabel = new JLabel("");
        this.statusLabel.setForeground(new Color(255, 0, 0));
        midPanel.add((Component)this.tabbedPanel, "Center");
        midPanel.add((Component)this.statusLabel, "South");
        mainPanel.add((Component)midPanel, "Center");
        JPanel southPanel = new JPanel(new BorderLayout(4, 4));
        JPanel buttonPanel = new JPanel();
        this.initButtonPanel(buttonPanel);
        southPanel.add((Component)buttonPanel, "Center");
        this.progressBar = new JProgressBar();
        this.progressBar.setName(this.getClass().getName() + "progressBar");
        this.progressBar.setStringPainted(true);
        this.progressPanel = new JPanel();
        this.progressPanel.setLayout(new BorderLayout(2, 2));
        this.progressMsgLabel = new JLabel();
        this.progressPanel.add((Component)this.progressMsgLabel, "North");
        this.progressPanel.add((Component)this.progressBar, "Center");
        JButton progressCancelBtn = new JButton("Cancel");
        progressCancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphBuilderDialog.this.CancelProcessing();
            }
        });
        this.progressPanel.add((Component)progressCancelBtn, "East");
        this.progressPanel.setVisible(false);
        southPanel.add((Component)this.progressPanel, "South");
        mainPanel.add((Component)southPanel, "South");
        mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        if (this.getJDialog().getJMenuBar() == null && this.allowGraphBuilding) {
            GraphsMenu operatorMenu = new GraphsMenu(this.getJDialog(), this);
            this.getJDialog().setJMenuBar(operatorMenu.createDefaultMenu());
        }
        this.setContent(mainPanel);
    }

    private void initButtonPanel(JPanel panel) {
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        JButton processButton = DialogUtils.createButton("processButton", "Run", processIcon, panel, DialogUtils.ButtonStyle.TextAndIcon);
        processButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphBuilderDialog.this.DoProcessing();
            }
        });
        JButton saveButton = DialogUtils.createButton("saveButton", "Save", saveIcon, panel, DialogUtils.ButtonStyle.TextAndIcon);
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphBuilderDialog.this.SaveGraph();
            }
        });
        JButton loadButton = DialogUtils.createButton("loadButton", "Load", loadIcon, panel, DialogUtils.ButtonStyle.TextAndIcon);
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphBuilderDialog.this.LoadGraph();
            }
        });
        JButton clearButton = DialogUtils.createButton("clearButton", "Clear", clearIcon, panel, DialogUtils.ButtonStyle.TextAndIcon);
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphBuilderDialog.this.ClearGraph();
            }
        });
        JButton infoButton = DialogUtils.createButton("infoButton", "Note", infoIcon, panel, DialogUtils.ButtonStyle.TextAndIcon);
        infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphBuilderDialog.this.OnInfo();
            }
        });
        JButton helpButton = DialogUtils.createButton("helpButton", "Help", helpIcon, panel, DialogUtils.ButtonStyle.TextAndIcon);
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphBuilderDialog.this.OnHelp();
            }
        });
        gbc.weightx = 0.0;
        if (this.allowGraphBuilding) {
            panel.add((Component)loadButton, gbc);
            panel.add((Component)saveButton, gbc);
            panel.add((Component)clearButton, gbc);
            panel.add((Component)infoButton, gbc);
        }
        panel.add((Component)helpButton, gbc);
        panel.add((Component)processButton, gbc);
    }

    public void DoProcessing() {
        if (this.ValidateAllNodes()) {
            if (!this.checkIfOutputExists()) {
                return;
            }
            MemUtils.freeAllMemory();
            this.progressBar.setValue(0);
            this.progBarMonitor = new ProgressBarProgressMonitor(this.progressBar, this.progressMsgLabel, this.progressPanel);
            ProcessThread processThread = new ProcessThread(this.progBarMonitor);
            processThread.execute();
        } else {
            this.showErrorDialog(this.statusLabel.getText());
        }
    }

    private boolean checkIfOutputExists() {
        File[] files;
        for (File file : files = this.graphEx.getPotentialOutputFiles()) {
            int answer;
            if (!file.exists() || (answer = JOptionPane.showOptionDialog(this.getJDialog(), "File " + file.getPath() + " already exists.\nWould you like to overwrite?", "Overwrite?", 0, 3, null, null, null)) != 1) continue;
            return false;
        }
        return true;
    }

    private void CancelProcessing() {
        if (this.progBarMonitor != null) {
            this.progBarMonitor.setCanceled(true);
        }
    }

    private boolean InitGraph() {
        boolean result = true;
        try {
            if (this.initGraphEnabled) {
                result = this.graphEx.InitGraph();
            }
            if (!result) {
                this.statusLabel.setText("Graph is incomplete");
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                this.statusLabel.setText("Error in graph: " + e.getMessage());
            } else {
                this.statusLabel.setText("Error in graph: " + e.toString());
            }
            result = false;
        }
        return result;
    }

    @Override
    public boolean canSaveGraphs() {
        return true;
    }

    @Override
    public void SaveGraph() {
        try {
            File file = this.graphEx.saveGraph();
            if (file != null) {
                this.setTitle(file.getName());
            }
        }
        catch (GraphException e) {
            this.showErrorDialog(e.getMessage());
        }
    }

    public void setTitle(String title) {
        super.setTitle("Graph Builder : " + title);
    }

    @Override
    public void LoadGraph() {
        SnapFileFilter fileFilter = new SnapFileFilter("XML", "xml", "Graph");
        File graphFile = Dialogs.requestFileForOpen((String)"Load Graph", (boolean)false, (FileFilter)fileFilter, (String)LAST_GRAPH_PATH);
        if (graphFile == null) {
            return;
        }
        this.LoadGraph(graphFile);
    }

    @Override
    public void LoadGraph(File file) {
        try {
            this.LoadGraph(new FileInputStream(file), file);
            if (this.allowGraphBuilding) {
                this.setTitle(file.getName());
            }
        }
        catch (IOException e) {
            SnapApp.getDefault().handleError("Unable to load graph " + file.toString(), (Throwable)e);
        }
    }

    public void LoadGraph(InputStream fileStream, File file) {
        try {
            this.initGraphEnabled = false;
            this.tabbedPanel.removeAll();
            this.graphEx.loadGraph(fileStream, file, true);
            if (this.allowGraphBuilding) {
                this.graphPanel.showRightClickHelp(false);
                this.graphPanel.repaint();
            }
            this.initGraphEnabled = true;
        }
        catch (GraphException e) {
            this.showErrorDialog(e.getMessage());
        }
    }

    @Override
    public String getGraphAsString() throws GraphException, IOException {
        return this.graphEx.getGraphAsString();
    }

    public void EnableInitialInstructions(boolean flag) {
        if (this.allowGraphBuilding) {
            this.graphPanel.showRightClickHelp(flag);
        }
    }

    private void ClearGraph() {
        this.initGraphEnabled = false;
        this.tabbedPanel.removeAll();
        this.graphEx.ClearGraph();
        this.graphPanel.repaint();
        this.initGraphEnabled = true;
        this.statusLabel.setText("");
    }

    public void setInputFiles(File[] productFileList) {
        GraphNode productSetNode = this.graphEx.getGraphNodeList().findGraphNodeByOperator("ProductSet-Reader");
        if (productSetNode != null) {
            ProductSetReaderOpUI ui = (ProductSetReaderOpUI)productSetNode.GetOperatorUI();
            ui.setProductFileList(productFileList);
        }
    }

    public void setInputFile(Product product) {
        GraphNode readerNode = this.graphEx.getGraphNodeList().findGraphNodeByOperator(ReadOp.Spi.getOperatorAlias(ReadOp.class));
        if (readerNode != null) {
            SourceUI ui = (SourceUI)readerNode.GetOperatorUI();
            ui.setSourceProduct(product);
            this.ValidateAllNodes();
        }
    }

    private void OnHelp() {
        new HelpCtx(this.getHelpID()).display();
    }

    private void OnInfo() {
        PromptDialog dlg = new PromptDialog("Graph Description", "Description", this.graphEx.getGraphDescription(), true);
        dlg.show();
        if (dlg.IsOK()) {
            this.graphEx.setGraphDescription(dlg.getValue());
        }
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    boolean ValidateAllNodes() {
        if (this.isProcessing) {
            return false;
        }
        boolean isValid = true;
        StringBuilder errorMsg = new StringBuilder(100);
        StringBuilder warningMsg = new StringBuilder(100);
        for (GraphNode n : this.graphEx.GetGraphNodes()) {
            try {
                UIValidation validation = n.validateParameterMap();
                if (validation.getState() == UIValidation.State.ERROR) {
                    isValid = false;
                    errorMsg.append(validation.getMsg()).append('\n');
                    continue;
                }
                if (validation.getState() != UIValidation.State.WARNING) continue;
                warningMsg.append(validation.getMsg()).append('\n');
            }
            catch (Exception e) {
                isValid = false;
                errorMsg.append(e.getMessage()).append('\n');
            }
        }
        this.statusLabel.setForeground(new Color(255, 0, 0));
        this.statusLabel.setText("");
        String warningStr = warningMsg.toString();
        if (!isValid) {
            this.statusLabel.setText(errorMsg.toString());
            return false;
        }
        if (!warningStr.isEmpty()) {
            if (warningStr.length() > 100 && !warningStr.equals(this.lastWarningMsg)) {
                Dialogs.showWarning((String)warningStr);
                this.lastWarningMsg = warningStr;
            } else {
                this.statusLabel.setForeground(new Color(0, 100, 255));
                this.statusLabel.setText("Warning: " + warningStr);
            }
        }
        return this.InitGraph();
    }

    public void addListener(ProcessingListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void removeListener(ProcessingListener listener) {
        this.listenerList.remove(listener);
    }

    private void notifyMSG(ProcessingListener.MSG msg, String text) {
        for (ProcessingListener listener : this.listenerList) {
            listener.notifyMSG(msg, text);
        }
    }

    private void notifyMSG(ProcessingListener.MSG msg, File[] fileList) {
        for (ProcessingListener listener : this.listenerList) {
            listener.notifyMSG(msg, fileList);
        }
    }

    @Override
    public void update(Observable subject, Object data) {
        try {
            GraphExecuter.GraphEvent event = (GraphExecuter.GraphEvent)data;
            GraphNode node = (GraphNode)event.getData();
            String opID = node.getID();
            if (event.getEventType() == GraphExecuter.events.ADD_EVENT) {
                this.tabbedPanel.addTab(opID, null, this.CreateOperatorTab(node), opID + " Operator");
            } else if (event.getEventType() == GraphExecuter.events.REMOVE_EVENT) {
                int index = this.tabbedPanel.indexOfTab(opID);
                this.tabbedPanel.remove(index);
            } else if (event.getEventType() == GraphExecuter.events.SELECT_EVENT) {
                int index = this.tabbedPanel.indexOfTab(opID);
                this.tabbedPanel.setSelectedIndex(index);
            } else if (event.getEventType() == GraphExecuter.events.CONNECT_EVENT) {
                this.ValidateAllNodes();
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null || msg.isEmpty()) {
                msg = e.toString();
            }
            this.statusLabel.setText(msg);
        }
    }

    private JComponent CreateOperatorTab(GraphNode node) {
        return node.GetOperatorUI().CreateOpTab(node.getOperatorName(), node.getParameterMap(), this.appContext);
    }

    private ProcessingStats openTargetProducts(File[] fileList) {
        ProcessingStats stats = new ProcessingStats();
        if (fileList.length != 0) {
            for (File file : fileList) {
                try {
                    Product product = CommonReaders.readProduct((File)file);
                    if (product == null) continue;
                    this.appContext.getProductManager().addProduct(product);
                    stats.totalBytes += ProductFunctions.getRawStorageSize((Product)product);
                    stats.totalPixels = ProductFunctions.getTotalPixels((Product)product);
                }
                catch (IOException e) {
                    this.showErrorDialog(e.getMessage());
                }
            }
        }
        return stats;
    }

    public static File getInternalGraphFolder() {
        return ResourceUtils.getGraphFolder((String)"internal").toFile();
    }

    public static File getStandardGraphFolder() {
        return ResourceUtils.getGraphFolder((String)"Standard Graphs").toFile();
    }

    public static interface ProcessingListener {
        public void notifyMSG(MSG var1, File[] var2);

        public void notifyMSG(MSG var1, String var2);

        public static enum MSG {
            DONE,
            UPDATE;

        }
    }

    private static class ProcessingStats {
        long totalBytes = 0L;
        long totalPixels = 0L;

        private ProcessingStats() {
        }
    }

    private class ProcessThread
    extends SwingWorker<GraphExecuter, Object> {
        private final ProgressMonitor pm;
        private Date executeStartTime = null;
        private boolean errorOccured = false;

        public ProcessThread(ProgressMonitor pm) {
            this.pm = pm;
        }

        @Override
        protected GraphExecuter doInBackground() throws Exception {
            this.pm.beginTask("Processing Graph...", 10);
            try {
                this.executeStartTime = Calendar.getInstance().getTime();
                GraphBuilderDialog.this.isProcessing = true;
                GraphBuilderDialog.this.graphEx.executeGraph(this.pm);
            }
            catch (Throwable e) {
                System.out.print(e.getMessage());
                if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                    GraphBuilderDialog.this.statusLabel.setText(e.getMessage());
                } else {
                    GraphBuilderDialog.this.statusLabel.setText(e.getCause().toString());
                }
                this.errorOccured = true;
            }
            finally {
                GraphBuilderDialog.this.isProcessing = false;
                GraphBuilderDialog.this.graphEx.disposeGraphContext();
                MemUtils.freeAllMemory();
                this.pm.done();
            }
            return GraphBuilderDialog.this.graphEx;
        }

        @Override
        public void done() {
            if (!this.errorOccured) {
                Date now = Calendar.getInstance().getTime();
                long totalSeconds = (now.getTime() - this.executeStartTime.getTime()) / 1000L;
                GraphBuilderDialog.this.statusLabel.setText(ProductFunctions.getProcessingStatistics((Long)totalSeconds));
                List<File> fileList = GraphBuilderDialog.this.graphEx.getProductsToOpenInDAT();
                File[] files = fileList.toArray(new File[fileList.size()]);
                GraphBuilderDialog.this.notifyMSG(ProcessingListener.MSG.DONE, files);
                ProcessingStats stats = GraphBuilderDialog.this.openTargetProducts(files);
                GraphBuilderDialog.this.statusLabel.setText(ProductFunctions.getProcessingStatistics((Long)totalSeconds, (Long)stats.totalBytes, (Long)stats.totalPixels));
            }
        }
    }
}

