/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.actions;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.esa.snap.graphbuilder.rcp.actions.OperatorAction;
import org.esa.snap.graphbuilder.rcp.dialogs.GraphBuilderDialog;
import org.esa.snap.ui.ModelessDialog;

public class GraphAction
extends OperatorAction {
    public static GraphAction create(Map<String, Object> properties) {
        GraphAction action = new GraphAction();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (!KNOWN_KEYS.contains(entry.getKey())) continue;
            action.putValue(entry.getKey(), entry.getValue());
        }
        return action;
    }

    public String getGraphFileName() {
        return this.getPropertyString("graphFile");
    }

    public boolean isEditingEnabled() {
        String enableEditingStr = this.getPropertyString("enableEditing");
        return enableEditingStr != null && enableEditingStr.equalsIgnoreCase("true");
    }

    @Override
    protected ModelessDialog createOperatorDialog() {
        this.setHelpId(this.getPropertyString("helpId"));
        GraphBuilderDialog dialog = new GraphBuilderDialog(this.getAppContext(), this.getDialogTitle(), this.getHelpId(), this.isEditingEnabled());
        dialog.show();
        File graphPath = GraphBuilderDialog.getInternalGraphFolder();
        File graphFile = new File(graphPath, this.getGraphFileName());
        this.addIcon(dialog);
        dialog.LoadGraph(graphFile);
        return dialog;
    }

    static {
        KNOWN_KEYS.addAll(Arrays.asList("graphFile", "enableEditing"));
    }
}

