/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.gpf.ui.worldmap;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.LayerTypeRegistry;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Product;

public class NestWorldMapPaneDataModel {
    public static final String PROPERTY_LAYER = "layer";
    public static final String PROPERTY_SELECTED_PRODUCT = "selectedProduct";
    public static final String PROPERTY_PRODUCTS = "products";
    public static final String PROPERTY_ADDITIONAL_GEO_BOUNDARIES = "additionalGeoBoundaries";
    public static final String PROPERTY_SELECTED_GEO_BOUNDARIES = "selectedGeoBoundaries";
    public static final String PROPERTY_AUTO_ZOOM_ENABLED = "autoZoomEnabled";
    private PropertyChangeSupport changeSupport;
    private static final LayerType layerType = LayerTypeRegistry.getLayerType((String)"org.esa.snap.worldmap.BlueMarbleLayerType");
    private Layer worldMapLayer;
    private Product selectedProduct;
    private boolean autoZoomEnabled = false;
    private ArrayList<Product> productList;
    private final ArrayList<GeoPos[]> additionalGeoBoundaryList;
    private final ArrayList<GeoPos[]> selectedGeoBoundaryList;
    private final GeoPos selectionBoxStart = new GeoPos();
    private final GeoPos selectionBoxEnd = new GeoPos();

    public NestWorldMapPaneDataModel() {
        this.productList = new ArrayList();
        this.additionalGeoBoundaryList = new ArrayList();
        this.selectedGeoBoundaryList = new ArrayList();
    }

    public Layer getWorldMapLayer(LayerContext context) {
        if (this.worldMapLayer == null) {
            this.worldMapLayer = layerType.createLayer(context, (PropertySet)new PropertyContainer());
        }
        return this.worldMapLayer;
    }

    public Product getSelectedProduct() {
        return this.selectedProduct;
    }

    public void setSelectedProduct(Product product) {
        Product oldSelectedProduct = this.selectedProduct;
        if (oldSelectedProduct != product) {
            this.selectedProduct = product;
            this.firePropertyChange(PROPERTY_SELECTED_PRODUCT, oldSelectedProduct, this.selectedProduct);
        }
    }

    public void setSelectionBoxStart(float lat, float lon) {
        this.selectionBoxStart.setLocation((double)lat, (double)lon);
    }

    public void setSelectionBoxEnd(float lat, float lon) {
        this.selectionBoxEnd.setLocation((double)lat, (double)lon);
    }

    public GeoPos[] getSelectionBox() {
        GeoPos[] selectionBox = new GeoPos[]{this.selectionBoxStart, new GeoPos(this.selectionBoxStart.getLat(), this.selectionBoxEnd.getLon()), this.selectionBoxEnd, new GeoPos(this.selectionBoxEnd.getLat(), this.selectionBoxStart.getLon())};
        return selectionBox;
    }

    public Product[] getProducts() {
        return this.productList.toArray(new Product[this.productList.size()]);
    }

    public void setProducts(Product[] products) {
        Product[] oldProducts = this.getProducts();
        this.productList.clear();
        if (products != null) {
            this.productList.addAll(Arrays.asList(products));
        }
        this.firePropertyChange(PROPERTY_PRODUCTS, oldProducts, this.getProducts());
    }

    public GeoPos[][] getAdditionalGeoBoundaries() {
        return (GeoPos[][])this.additionalGeoBoundaryList.toArray((T[])new GeoPos[this.additionalGeoBoundaryList.size()][]);
    }

    public void setAdditionalGeoBoundaries(GeoPos[][] geoBoundarys) {
        GeoPos[][] oldGeoBoundarys = this.getAdditionalGeoBoundaries();
        this.additionalGeoBoundaryList.clear();
        if (geoBoundarys != null) {
            this.additionalGeoBoundaryList.addAll(Arrays.asList(geoBoundarys));
        }
        this.firePropertyChange(PROPERTY_ADDITIONAL_GEO_BOUNDARIES, oldGeoBoundarys, this.additionalGeoBoundaryList);
    }

    public GeoPos[][] getSelectedGeoBoundaries() {
        return (GeoPos[][])this.selectedGeoBoundaryList.toArray((T[])new GeoPos[this.selectedGeoBoundaryList.size()][]);
    }

    public void setSelectedGeoBoundaries(GeoPos[][] geoBoundarys) {
        GeoPos[][] oldGeoBoundarys = this.getSelectedGeoBoundaries();
        this.selectedGeoBoundaryList.clear();
        if (geoBoundarys != null) {
            this.selectedGeoBoundaryList.addAll(Arrays.asList(geoBoundarys));
        }
        this.firePropertyChange(PROPERTY_SELECTED_GEO_BOUNDARIES, oldGeoBoundarys, this.selectedGeoBoundaryList);
    }

    public void addModelChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removeModelChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    public void addProduct(Product product) {
        if (!this.productList.contains(product)) {
            Product[] oldProducts = this.getProducts();
            if (this.productList.add(product)) {
                this.firePropertyChange(PROPERTY_PRODUCTS, oldProducts, this.getProducts());
            }
        }
    }

    public void removeProduct(Product product) {
        if (this.productList.contains(product)) {
            Product[] oldProducts = this.getProducts();
            if (this.productList.remove(product)) {
                this.firePropertyChange(PROPERTY_PRODUCTS, oldProducts, this.getProducts());
            }
        }
    }

    public boolean isAutoZommEnabled() {
        return this.autoZoomEnabled;
    }

    public void setAutoZoomEnabled(boolean autoZoomEnabled) {
        boolean oldAutoZommEnabled = this.isAutoZommEnabled();
        if (oldAutoZommEnabled != autoZoomEnabled) {
            this.autoZoomEnabled = autoZoomEnabled;
            this.firePropertyChange(PROPERTY_AUTO_ZOOM_ENABLED, oldAutoZommEnabled, autoZoomEnabled);
        }
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

