/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.gpf.ui;

import java.io.File;
import java.util.Map;
import javax.swing.JComponent;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.dialogs.ProductSetPanel;
import org.esa.snap.graphbuilder.rcp.dialogs.support.FileTable;
import org.esa.snap.ui.AppContext;

public class ProductSetReaderOpUI
extends BaseOperatorUI {
    private final FileTable productSetTable = new FileTable();

    @Override
    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        ProductSetPanel panel = new ProductSetPanel(appContext, "", this.productSetTable, false, true);
        this.initParameters();
        return panel;
    }

    @Override
    public void initParameters() {
        String[] fList = (String[])this.paramMap.get("fileList");
        this.productSetTable.setFiles(fList);
    }

    @Override
    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    @Override
    public void updateParameters() {
        File[] fileList = this.productSetTable.getFileList();
        if (fileList.length == 0) {
            return;
        }
        String[] fList = new String[fileList.length];
        for (int i = 0; i < fileList.length; ++i) {
            fList[i] = fileList[i].getName().isEmpty() ? "" : fileList[i].getAbsolutePath();
        }
        this.paramMap.put("fileList", fList);
    }

    public void setProductFileList(File[] productFileList) {
        this.productSetTable.setFiles(productFileList);
    }
}

