/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.gpf.ui;

import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.db.CommonReaders;

public final class OperatorUIUtils {
    public static final String SOURCE_BAND_NAMES = "sourceBandNames";

    public static void initParamList(JList paramList, String[] availNames) {
        OperatorUIUtils.initParamList(paramList, availNames, null);
    }

    public static void initParamList(JList paramList, String[] availNames, Object[] defaultSelection) {
        List selectedValues = paramList.getSelectedValuesList();
        paramList.removeAll();
        paramList.setListData(availNames);
        paramList.setFixedCellWidth(200);
        paramList.setMinimumSize(new Dimension(50, 4));
        int size = paramList.getModel().getSize();
        ArrayList<Integer> indices = new ArrayList<Integer>(size);
        block0: for (Object selectedValue : selectedValues) {
            String selValue = (String)selectedValue;
            for (int j = 0; j < size; ++j) {
                String val = (String)paramList.getModel().getElementAt(j);
                if (!val.equals(selValue)) continue;
                indices.add(j);
                continue block0;
            }
        }
        if (selectedValues.isEmpty() && defaultSelection != null) {
            int j = 0;
            for (String name : availNames) {
                for (Object defaultSel : defaultSelection) {
                    if (!name.equals(defaultSel.toString())) continue;
                    indices.add(j);
                }
                ++j;
            }
        }
        OperatorUIUtils.setSelectedListIndices(paramList, indices);
    }

    public static void setSelectedListIndices(JList list, List<Integer> indices) {
        int[] selIndex = new int[indices.size()];
        for (int i = 0; i < indices.size(); ++i) {
            selIndex[i] = indices.get(i);
        }
        list.setSelectedIndices(selIndex);
    }

    public static void updateParamList(JList paramList, Map<String, Object> paramMap, String paramName) {
        List selectedValues = paramList.getSelectedValuesList();
        String[] names = new String[selectedValues.size()];
        int i = 0;
        for (Object selectedValue : selectedValues) {
            names[i++] = (String)selectedValue;
        }
        if (names.length == 0 && paramMap.get(paramName) != null) {
            return;
        }
        paramMap.put(paramName, names);
    }

    public static double getNoDataValue(File extFile) {
        try {
            Product product = CommonReaders.readProduct((File)extFile);
            if (product != null) {
                return product.getBandAt(0).getNoDataValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0;
    }
}

