/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.gpf.ui;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.ConverterRegistry;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.PropertySetDescriptor;
import com.bc.ceres.binding.dom.DomConverter;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.binding.dom.XppDomElement;
import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.PropertySetDescriptorFactory;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.ui.AppContext;

public abstract class BaseOperatorUI
implements OperatorUI {
    protected PropertySet propertySet = null;
    protected Map<String, Object> paramMap = null;
    protected Product[] sourceProducts = null;
    protected String operatorName = "";

    @Override
    public abstract JComponent CreateOpTab(String var1, Map<String, Object> var2, AppContext var3);

    @Override
    public abstract void initParameters();

    @Override
    public abstract UIValidation validateParameters();

    @Override
    public abstract void updateParameters();

    @Override
    public String getOperatorName() {
        return this.operatorName;
    }

    protected void initializeOperatorUI(String operatorName, Map<String, Object> parameterMap) {
        PropertySetDescriptor propertySetDescriptor;
        this.operatorName = operatorName;
        this.paramMap = parameterMap;
        OperatorSpi operatorSpi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(operatorName);
        if (operatorSpi == null) {
            throw new IllegalArgumentException("operator " + operatorName + " not found");
        }
        ParameterDescriptorFactory descriptorFactory = new ParameterDescriptorFactory();
        OperatorDescriptor operatorDescriptor = operatorSpi.getOperatorDescriptor();
        try {
            propertySetDescriptor = PropertySetDescriptorFactory.createForOperator((OperatorDescriptor)operatorDescriptor, (Map)descriptorFactory.getSourceProductMap());
        }
        catch (ConversionException e) {
            throw new IllegalStateException("Not able to init OperatorParameterSupport.", e);
        }
        this.propertySet = PropertyContainer.createMapBacked(this.paramMap, (PropertySetDescriptor)propertySetDescriptor);
        if (this.paramMap.isEmpty()) {
            try {
                this.propertySet.setDefaultValues();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setSourceProducts(Product[] products) {
        if (this.sourceProducts == null || !Arrays.equals(this.sourceProducts, products)) {
            this.sourceProducts = products;
            if (this.paramMap != null) {
                this.initParameters();
            }
        }
    }

    @Override
    public boolean hasSourceProducts() {
        return this.sourceProducts != null;
    }

    @Override
    public void convertToDOM(XppDomElement parentElement) throws GraphException {
        Property[] properties;
        if (this.propertySet == null) {
            this.setParamsToConfiguration(parentElement.getXppDom());
            return;
        }
        for (Property p : properties = this.propertySet.getProperties()) {
            DomElement childElement;
            PropertyDescriptor descriptor = p.getDescriptor();
            DomConverter domConverter = descriptor.getDomConverter();
            if (domConverter != null) {
                try {
                    DomElement childElement2 = parentElement.createChild(BaseOperatorUI.getElementName(p));
                    domConverter.convertValueToDom(p.getValue(), childElement2);
                }
                catch (ConversionException e) {
                    e.printStackTrace();
                }
                continue;
            }
            String itemAlias = descriptor.getItemAlias();
            if (descriptor.getType().isArray() && itemAlias != null && !itemAlias.isEmpty()) {
                childElement = descriptor.getItemsInlined() ? parentElement : parentElement.createChild(BaseOperatorUI.getElementName(p));
                Object array = p.getValue();
                Converter itemConverter = BaseOperatorUI.getItemConverter(descriptor);
                if (array == null || itemConverter == null) continue;
                int arrayLength = Array.getLength(array);
                for (int i = 0; i < arrayLength; ++i) {
                    Object component = Array.get(array, i);
                    DomElement itemElement = childElement.createChild(itemAlias);
                    String text = itemConverter.format(component);
                    if (text == null || text.isEmpty()) continue;
                    itemElement.setValue(text);
                }
                continue;
            }
            childElement = parentElement.createChild(BaseOperatorUI.getElementName(p));
            Object childValue = p.getValue();
            Converter converter = descriptor.getConverter();
            if (converter == null) {
                throw new GraphException(this.operatorName + " BaseOperatorUI: no coverter found for parameter " + descriptor.getName());
            }
            String text = converter.format(childValue);
            if (text == null || text.isEmpty()) continue;
            childElement.setValue(text);
        }
    }

    protected String[] getBandNames() {
        ArrayList<String> bandNames = new ArrayList<String>(5);
        if (this.sourceProducts != null) {
            for (Product prod : this.sourceProducts) {
                if (this.sourceProducts.length > 1) {
                    for (String name : prod.getBandNames()) {
                        bandNames.add(name + "::" + prod.getName());
                    }
                    continue;
                }
                bandNames.addAll(Arrays.asList(prod.getBandNames()));
            }
        }
        return bandNames.toArray(new String[bandNames.size()]);
    }

    protected String[] getGeometries() {
        ArrayList<String> geometryNames = new ArrayList<String>(5);
        if (this.sourceProducts != null) {
            for (Product prod : this.sourceProducts) {
                if (this.sourceProducts.length > 1) {
                    for (String name : prod.getMaskGroup().getNodeNames()) {
                        geometryNames.add(name + "::" + prod.getName());
                    }
                    continue;
                }
                geometryNames.addAll(Arrays.asList(prod.getMaskGroup().getNodeNames()));
            }
        }
        return geometryNames.toArray(new String[geometryNames.size()]);
    }

    private void setParamsToConfiguration(XppDom config) {
        if (this.paramMap == null) {
            return;
        }
        Set<String> keys = this.paramMap.keySet();
        for (String key : keys) {
            Object value = this.paramMap.get(key);
            if (value == null) continue;
            XppDom xml = config.getChild(key);
            if (xml == null) {
                xml = new XppDom(key);
                config.addChild(xml);
            }
            xml.setValue(value.toString());
        }
    }

    private static Converter getItemConverter(PropertyDescriptor descriptor) {
        Class<?> itemType = descriptor.getType().getComponentType();
        Converter itemConverter = descriptor.getConverter();
        if (itemConverter == null) {
            itemConverter = ConverterRegistry.getInstance().getConverter(itemType);
        }
        return itemConverter;
    }

    private static String getElementName(Property p) {
        String alias = p.getDescriptor().getAlias();
        if (alias != null && !alias.isEmpty()) {
            return alias;
        }
        return p.getDescriptor().getName();
    }
}

