/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.unmixing.ui;

import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.selection.AbstractSelectionChangeListener;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.ui.SourceProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelector;
import org.esa.snap.core.gpf.ui.TargetProductSelectorModel;
import org.esa.snap.ui.AppContext;
import org.esa.snap.unmixing.ui.EndmemberForm;
import org.esa.snap.unmixing.ui.SpectralUnmixingFormModel;

class SpectralUnmixingForm
extends JPanel {
    AppContext appContext;
    SpectralUnmixingFormModel formModel;
    EndmemberForm endmemberForm;
    SourceProductSelector sourceProductSelector;
    TargetProductSelector targetProductSelector;
    JList sourceBandNames;
    JTextField abundanceBandNameSuffix;
    JTextField errorBandNameSuffix;
    JTextField minBandwidth;
    JComboBox unmixingModelName;
    JCheckBox computeErrorBands;

    SpectralUnmixingForm(AppContext appContext, PropertySet propertySet, TargetProductSelector targetProductSelector) {
        this.appContext = appContext;
        this.targetProductSelector = targetProductSelector;
        this.formModel = new SpectralUnmixingFormModel(appContext.getSelectedProduct(), propertySet);
        this.endmemberForm = new EndmemberForm(appContext);
        this.sourceProductSelector = new SourceProductSelector(appContext);
        this.createComponents();
        this.bindComponents();
    }

    public SpectralUnmixingFormModel getFormModel() {
        return this.formModel;
    }

    public EndmemberForm getEndmemberForm() {
        return this.endmemberForm;
    }

    void prepareShow() {
        this.sourceProductSelector.initProducts();
        Product selectedProduct = this.appContext.getSelectedProduct();
        this.updateTargetProductName(selectedProduct);
        this.targetProductSelector.getProductNameTextField().requestFocus();
    }

    private void updateTargetProductName(Product selectedProduct) {
        TargetProductSelectorModel selectorModel = this.targetProductSelector.getModel();
        if (selectedProduct != null) {
            selectorModel.setProductName(selectedProduct.getName() + "_unmixed");
        } else if (selectorModel.getProductName() == null) {
            selectorModel.setProductName("unmixed");
        }
    }

    void prepareHide() {
        this.sourceProductSelector.releaseProducts();
    }

    private void bindComponents() {
        BindingContext bindingContext = new BindingContext(this.formModel.getOperatorValueContainer());
        bindingContext.bind("unmixingModelName", this.unmixingModelName);
        bindingContext.bind("abundanceBandNameSuffix", this.abundanceBandNameSuffix);
        bindingContext.bind("errorBandNameSuffix", this.errorBandNameSuffix);
        bindingContext.bind("sourceBandNames", this.sourceBandNames, true);
        bindingContext.bind("computeErrorBands", this.computeErrorBands);
        bindingContext.bind("minBandwidth", this.minBandwidth);
    }

    private void createComponents() {
        this.sourceBandNames = new JList();
        final PropertyDescriptor propertyDescriptor = this.formModel.getOperatorValueContainer().getDescriptor("sourceBandNames");
        AbstractSelectionChangeListener valueSetUpdater = new AbstractSelectionChangeListener(){

            public void selectionChanged(SelectionChangeEvent event) {
                Object[] validNames;
                Product selectedProduct = (Product)event.getSelection().getSelectedValue();
                if (selectedProduct != null) {
                    String[] bandNames = selectedProduct.getBandNames();
                    ArrayList<String> names = new ArrayList<String>(bandNames.length);
                    for (String bandName : bandNames) {
                        if (!((double)selectedProduct.getBand(bandName).getSpectralWavelength() > 0.0)) continue;
                        names.add(bandName);
                    }
                    validNames = names.toArray(new String[names.size()]);
                } else {
                    validNames = new String[]{};
                }
                ValueSet valueSet = new ValueSet(validNames);
                propertyDescriptor.setValueSet(valueSet);
                SpectralUnmixingForm.this.formModel.setSourceProduct(selectedProduct);
                SpectralUnmixingForm.this.updateTargetProductName(selectedProduct);
            }
        };
        this.sourceProductSelector.addSelectionChangeListener((SelectionChangeListener)valueSetUpdater);
        TargetProductSelectorModel targetProductSelectorModel = this.targetProductSelector.getModel();
        targetProductSelectorModel.setSaveToFileSelected(true);
        targetProductSelectorModel.setOpenInAppSelected(true);
        this.abundanceBandNameSuffix = new JTextField();
        this.errorBandNameSuffix = new JTextField();
        this.unmixingModelName = new JComboBox();
        this.computeErrorBands = new JCheckBox("Compute error bands");
        this.minBandwidth = new JTextField();
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setTableAnchor(TableLayout.Anchor.NORTHWEST);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setRowFill(1, TableLayout.Fill.BOTH);
        tableLayout.setCellFill(0, 0, TableLayout.Fill.BOTH);
        tableLayout.setCellColspan(1, 0, Integer.valueOf(2));
        tableLayout.setCellColspan(2, 0, Integer.valueOf(2));
        tableLayout.setRowWeightY(1, Double.valueOf(1.0));
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        this.setLayout((LayoutManager)tableLayout);
        this.add(this.createSourcePanel());
        this.add(this.createTargetPanel());
        this.add(this.createParametersPanel());
    }

    private JPanel createSourcePanel() {
        return this.sourceProductSelector.createDefaultPanel();
    }

    private JComponent createTargetPanel() {
        return this.targetProductSelector.createDefaultPanel();
    }

    private JPanel createParametersPanel() {
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setTableAnchor(TableLayout.Anchor.CENTER);
        tableLayout.setTableFill(TableLayout.Fill.BOTH);
        tableLayout.setTablePadding(3, 3);
        tableLayout.setCellPadding(0, 0, new Insets(0, 0, 10, 10));
        tableLayout.setCellColspan(1, 0, Integer.valueOf(2));
        tableLayout.setCellColspan(2, 0, Integer.valueOf(2));
        tableLayout.setRowWeightY(0, Double.valueOf(0.5));
        tableLayout.setRowWeightY(1, Double.valueOf(0.0));
        tableLayout.setRowWeightY(2, Double.valueOf(0.5));
        tableLayout.setColumnWeightX(0, Double.valueOf(1.0));
        tableLayout.setColumnWeightX(1, Double.valueOf(1.0));
        JPanel panel = new JPanel((LayoutManager)tableLayout);
        panel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        panel.add(this.createSourceBandsPanel());
        panel.add(this.createSubParametersPanel());
        panel.add(new JLabel("Endmembers:"));
        panel.add(this.endmemberForm);
        return panel;
    }

    private JPanel createSourceBandsPanel() {
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.add((Component)new JLabel("Spectral source bands:"), "North");
        panel.add((Component)new JScrollPane(this.sourceBandNames), "Center");
        return panel;
    }

    private JPanel createSubParametersPanel() {
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setTablePadding(3, 3);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setColumnWeightX(1, Double.valueOf(1.0));
        tableLayout.setCellColspan(4, 0, Integer.valueOf(2));
        JPanel panel = new JPanel((LayoutManager)tableLayout);
        panel.add(new JLabel("Abundance band name suffix: "));
        panel.add(this.abundanceBandNameSuffix);
        panel.add(new JLabel("Error band name suffix: "));
        panel.add(this.errorBandNameSuffix);
        panel.add(new JLabel("Spectral unmixing model: "));
        panel.add(this.unmixingModelName);
        panel.add(new JLabel("Minimum spectral bandwidth: "));
        panel.add(this.minBandwidth);
        panel.add(this.computeErrorBands);
        panel.add(tableLayout.createVerticalSpacer());
        return panel;
    }
}

