/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.unmixing.ui;

import java.awt.Component;
import java.util.Map;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.ui.OperatorMenu;
import org.esa.snap.core.gpf.ui.OperatorParameterSupport;
import org.esa.snap.core.gpf.ui.ParameterUpdater;
import org.esa.snap.core.gpf.ui.SingleTargetProductDialog;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.DefaultAppContext;
import org.esa.snap.unmixing.Endmember;
import org.esa.snap.unmixing.SpectralUnmixingOp;
import org.esa.snap.unmixing.ui.Bundle;
import org.esa.snap.unmixing.ui.EndmemberFormModel;
import org.esa.snap.unmixing.ui.SpectralUnmixingForm;
import org.esa.snap.unmixing.ui.SpectralUnmixingFormModel;

public class SpectralUnmixingDialog
extends SingleTargetProductDialog {
    public static final String HELP_ID = "spectralUnmixing";
    private static final String TITLE = Bundle.CTL_SpectralUnmixingAction_Text();
    private final SpectralUnmixingForm form;
    private final OperatorParameterSupport parameterSupport;

    public SpectralUnmixingDialog(AppContext appContext) {
        super(appContext, TITLE, 24, HELP_ID);
        ParameterUpdater parameterUpdater = new ParameterUpdater(){

            public void handleParameterSaveRequest(Map<String, Object> parameterMap) {
                SpectralUnmixingDialog.this.updateParameterMap(parameterMap);
            }

            public void handleParameterLoadRequest(Map<String, Object> parameterMap) {
                SpectralUnmixingDialog.this.updateEndmemberFormModel(parameterMap);
            }
        };
        OperatorSpi operatorSpi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(SpectralUnmixingOp.Spi.class.getName());
        this.parameterSupport = new OperatorParameterSupport(operatorSpi.getOperatorDescriptor(), null, null, parameterUpdater);
        this.form = new SpectralUnmixingForm(appContext, this.parameterSupport.getPropertySet(), this.getTargetProductSelector());
        OperatorMenu operatorMenu = new OperatorMenu((Component)this.getJDialog(), operatorSpi.getOperatorDescriptor(), this.parameterSupport, appContext, HELP_ID);
        this.getJDialog().setJMenuBar(operatorMenu.createDefaultMenu());
    }

    private void updateEndmemberFormModel(Map<String, Object> parameterMap) {
        Object endmembers = parameterMap.get("endmembers");
        if (endmembers instanceof Endmember[]) {
            EndmemberFormModel endmemberFormModel = this.form.getEndmemberForm().getFormModel();
            endmemberFormModel.setEndmembers((Endmember[])endmembers);
        }
    }

    private void updateParameterMap(Map<String, Object> parameterMap) {
        parameterMap.put("endmembers", this.form.getEndmemberForm().getFormModel().getEndmembers());
    }

    protected Product createTargetProduct() throws Exception {
        SpectralUnmixingFormModel formModel = this.form.getFormModel();
        Map parameterMap = this.parameterSupport.getParameterMap();
        this.updateParameterMap(parameterMap);
        return GPF.createProduct((String)OperatorSpi.getOperatorAlias(SpectralUnmixingOp.class), (Map)parameterMap, (Product)formModel.getSourceProduct());
    }

    public int show() {
        this.form.prepareShow();
        this.setContent(this.form);
        return super.show();
    }

    public void hide() {
        this.form.prepareHide();
        super.hide();
    }

    protected boolean verifyUserInput() {
        SpectralUnmixingFormModel formModel = this.form.getFormModel();
        if (formModel.getSourceProduct() == null) {
            this.showErrorDialog("No source product selected.");
            return false;
        }
        Map parameterMap = this.parameterSupport.getParameterMap();
        this.updateParameterMap(parameterMap);
        Endmember[] endmembers = (Endmember[])parameterMap.get("endmembers");
        String[] sourceBandNames = (String[])parameterMap.get("sourceBandNames");
        double minBandwidth = (Double)parameterMap.get("minBandwidth");
        double[] sourceWavelengths = new double[sourceBandNames.length];
        double[] sourceBandwidths = new double[sourceBandNames.length];
        for (int i = 0; i < sourceBandNames.length; ++i) {
            Band sourceBand = formModel.getSourceProduct().getBand(sourceBandNames[i]);
            sourceWavelengths[i] = sourceBand.getSpectralWavelength();
            sourceBandwidths[i] = sourceBand.getSpectralBandwidth();
        }
        if (!SpectralUnmixingDialog.matchingWavelength(endmembers, sourceWavelengths, sourceBandwidths, minBandwidth)) {
            this.showErrorDialog("One or more source wavelengths do not fit\nto one or more endmember spectra.\n\nConsider increasing the maximum wavelength deviation.");
            return false;
        }
        return true;
    }

    private static boolean matchingWavelength(Endmember[] endmembers, double[] sourceWavelengths, double[] sourceBandwidths, double minBandwidth) {
        for (Endmember endmember : endmembers) {
            double[] endmemberWavelengths = endmember.getWavelengths();
            for (int i = 0; i < sourceWavelengths.length; ++i) {
                double sourceWavelength = sourceWavelengths[i];
                double sourceBandwidth = sourceBandwidths[i];
                int k = SpectralUnmixingOp.findEndmemberSpectralIndex((double[])endmemberWavelengths, (double)sourceWavelength, (double)Math.max(sourceBandwidth, minBandwidth));
                if (k != -1) continue;
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) throws IllegalAccessException, UnsupportedLookAndFeelException, InstantiationException, ClassNotFoundException {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        float[] wl = new float[]{412.63956f, 442.51602f, 489.8733f, 509.83f, 559.75757f, 619.7248f, 664.7287f, 680.9848f, 708.49896f, 753.53125f, 761.7092f, 778.552f, 864.88f, 884.8976f, 899.91003f};
        Product inputProduct = new Product("MER_RR_1P", "MER_RR_1P", 16, 16);
        for (int i = 0; i < wl.length; ++i) {
            Band band = inputProduct.addBand("radiance_" + (i + 1), 30);
            band.setSpectralWavelength(wl[i]);
            band.setSpectralBandIndex(i);
        }
        inputProduct.addBand("l1_flags", 22);
        DefaultAppContext context = new DefaultAppContext("dev0");
        context.getProductManager().addProduct(inputProduct);
        context.setSelectedProduct(inputProduct);
        SpectralUnmixingDialog dialog = new SpectralUnmixingDialog((AppContext)context);
        dialog.getJDialog().setDefaultCloseOperation(2);
        dialog.show();
    }
}

