/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.unmixing.ui;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.runtime.Config;
import org.esa.snap.tango.TangoIcons;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.diagram.DefaultDiagramGraphStyle;
import org.esa.snap.ui.diagram.Diagram;
import org.esa.snap.ui.diagram.DiagramAxis;
import org.esa.snap.ui.diagram.DiagramGraph;
import org.esa.snap.ui.diagram.DiagramGraphIO;
import org.esa.snap.unmixing.Endmember;
import org.esa.snap.unmixing.ui.EndmemberGraph;
import org.esa.snap.unmixing.ui.SpectralUnmixingDialog;

class EndmemberFormModel {
    private DefaultListModel<Endmember> endmemberListModel;
    private DefaultListSelectionModel endmemberListSelectionModel;
    private int selectedEndmemberIndex;
    private Diagram endmemberDiagram;
    private Action addAction = new AddAction();
    private Action removeAction = new RemoveAction();
    private Action clearAction = new ClearAction();
    private Action exportAction = new ExportAction();
    private AppContext appContext;
    private PropertyChangeSupport propertyChangeSupport;
    private Color[] defaultColors = new Color[]{Color.BLACK, Color.RED.darker(), Color.GREEN.darker(), Color.BLUE.darker(), Color.YELLOW};
    private static Path defaultEndmemberDir = SystemUtils.getAuxDataPath().resolve("unmix");

    public EndmemberFormModel(AppContext appContext) {
        this.appContext = appContext;
        this.endmemberListModel = new DefaultListModel();
        this.endmemberListSelectionModel = new DefaultListSelectionModel();
        this.endmemberListSelectionModel.setSelectionMode(0);
        this.endmemberListModel.addListDataListener(new EndmemberListDataListener());
        this.endmemberListSelectionModel.addListSelectionListener(new EndmemberListSelectionListener());
        this.endmemberDiagram = new Diagram();
        this.endmemberDiagram.setXAxis(new DiagramAxis("Wavelength", ""));
        this.endmemberDiagram.setYAxis(new DiagramAxis("Radiation", ""));
        this.endmemberDiagram.setDrawGrid(false);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public Endmember[] getEndmembers() {
        Endmember[] endmembers = new Endmember[this.endmemberListModel.getSize()];
        for (int i = 0; i < endmembers.length; ++i) {
            endmembers[i] = this.endmemberListModel.getElementAt(i);
        }
        return endmembers;
    }

    public void setEndmembers(Endmember[] endmembers) {
        this.endmemberListModel.removeAllElements();
        for (Endmember endmember : endmembers) {
            this.endmemberListModel.addElement(endmember);
        }
    }

    public ListModel<Endmember> getEndmemberListModel() {
        return this.endmemberListModel;
    }

    public DefaultListSelectionModel getEndmemberListSelectionModel() {
        return this.endmemberListSelectionModel;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public int getSelectedEndmemberIndex() {
        return this.selectedEndmemberIndex;
    }

    public Action getAddAction() {
        return this.addAction;
    }

    public Action getRemoveAction() {
        return this.removeAction;
    }

    public Action getClearAction() {
        return this.clearAction;
    }

    public Action getExportAction() {
        return this.exportAction;
    }

    public Diagram getEndmemberDiagram() {
        return this.endmemberDiagram;
    }

    private void addEndmember(Endmember endmember) {
        this.endmemberListModel.addElement(endmember);
        EndmemberGraph endmemberGraph = new EndmemberGraph(endmember);
        Color color = this.defaultColors[this.endmemberListModel.getSize() % this.defaultColors.length];
        DefaultDiagramGraphStyle style = (DefaultDiagramGraphStyle)endmemberGraph.getStyle();
        style.setOutlineColor(color);
        style.setOutlineStroke((Stroke)new BasicStroke(1.0f));
        style.setShowingPoints(false);
        this.endmemberDiagram.addGraph((DiagramGraph)endmemberGraph);
        this.endmemberDiagram.adjustAxes(true);
    }

    public void setSelectedEndmemberIndex(int index) {
        DiagramGraph endmemberGraph;
        int oldIndex = this.selectedEndmemberIndex;
        if (oldIndex == index) {
            return;
        }
        if (oldIndex >= 0 && this.endmemberDiagram.getGraphCount() > 0) {
            endmemberGraph = this.endmemberDiagram.getGraph(oldIndex);
            ((DefaultDiagramGraphStyle)endmemberGraph.getStyle()).setOutlineStroke((Stroke)new BasicStroke(1.0f));
        }
        this.selectedEndmemberIndex = index;
        if (this.selectedEndmemberIndex >= 0 && this.endmemberDiagram.getGraphCount() > 0) {
            endmemberGraph = this.endmemberDiagram.getGraph(this.selectedEndmemberIndex);
            ((DefaultDiagramGraphStyle)endmemberGraph.getStyle()).setOutlineStroke((Stroke)new BasicStroke(2.0f));
        }
        this.endmemberDiagram.invalidate();
        this.propertyChangeSupport.firePropertyChange("selectedEndmemberIndex", oldIndex, this.selectedEndmemberIndex);
    }

    private void ensureDefaultDirSet() {
        if (!Files.exists(defaultEndmemberDir, new LinkOption[0])) {
            Path sourceDirPath = ResourceInstaller.findModuleCodeBasePath(SpectralUnmixingDialog.class).resolve("auxdata");
            ResourceInstaller resourceInstaller = new ResourceInstaller(sourceDirPath, defaultEndmemberDir);
            try {
                resourceInstaller.install(".*", ProgressMonitor.NULL);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String key = "diagramGraphIO.lastDir";
        Preferences preferences = Config.instance().preferences();
        if (preferences.get("diagramGraphIO.lastDir", null) == null) {
            preferences.put("diagramGraphIO.lastDir", defaultEndmemberDir.toAbsolutePath().toString());
        }
    }

    private class EndmemberListSelectionListener
    implements ListSelectionListener {
        private EndmemberListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (EndmemberFormModel.this.endmemberListSelectionModel.isSelectionEmpty()) {
                    EndmemberFormModel.this.setSelectedEndmemberIndex(-1);
                } else {
                    EndmemberFormModel.this.setSelectedEndmemberIndex(EndmemberFormModel.this.endmemberListSelectionModel.getLeadSelectionIndex());
                }
            }
        }
    }

    private class EndmemberListDataListener
    implements ListDataListener {
        private EndmemberListDataListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            EndmemberFormModel.this.endmemberDiagram.invalidate();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            EndmemberFormModel.this.endmemberDiagram.invalidate();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            EndmemberFormModel.this.endmemberDiagram.invalidate();
        }
    }

    private class ExportAction
    extends AbstractAction {
        public ExportAction() {
            super("Export");
            this.putValue("SwingLargeIconKey", TangoIcons.actions_document_save_as((TangoIcons.Res)TangoIcons.Res.R16));
            this.putValue("ShortDescription", "Export Endmembers");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EndmemberFormModel.this.ensureDefaultDirSet();
            DiagramGraphIO.writeGraphs(null, (String)"Export Endmembers", (SnapFileFilter[])new SnapFileFilter[]{DiagramGraphIO.SPECTRA_CSV_FILE_FILTER}, (PropertyMap)EndmemberFormModel.this.appContext.getPreferences(), (DiagramGraph[])EndmemberFormModel.this.endmemberDiagram.getGraphs());
        }
    }

    private class ClearAction
    extends AbstractAction {
        public ClearAction() {
            super("Clear");
            this.putValue("SwingLargeIconKey", TangoIcons.actions_edit_clear((TangoIcons.Res)TangoIcons.Res.R16));
            this.putValue("ShortDescription", "Clear List");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EndmemberFormModel.this.setSelectedEndmemberIndex(-1);
            EndmemberFormModel.this.endmemberListModel.removeAllElements();
            EndmemberFormModel.this.endmemberDiagram.removeAllGraphs();
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            super("Remove");
            this.putValue("SwingLargeIconKey", TangoIcons.actions_list_remove((TangoIcons.Res)TangoIcons.Res.R16));
            this.putValue("ShortDescription", "Remove Endmember");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = EndmemberFormModel.this.selectedEndmemberIndex;
            if (index >= 0) {
                EndmemberFormModel.this.setSelectedEndmemberIndex(-1);
                EndmemberFormModel.this.endmemberListModel.removeElementAt(index);
                EndmemberFormModel.this.endmemberDiagram.removeGraph(EndmemberFormModel.this.endmemberDiagram.getGraph(index));
                EndmemberFormModel.this.endmemberDiagram.adjustAxes(true);
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        public AddAction() {
            super("Add");
            this.putValue("SwingLargeIconKey", TangoIcons.actions_list_add((TangoIcons.Res)TangoIcons.Res.R16));
            this.putValue("ShortDescription", "Add Endmembers");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Endmember[] endmembers;
            EndmemberFormModel.this.ensureDefaultDirSet();
            DiagramGraph[] diagramGraphs = DiagramGraphIO.readGraphs(null, (String)"Add Endmembers", (SnapFileFilter[])new SnapFileFilter[]{DiagramGraphIO.SPECTRA_CSV_FILE_FILTER}, (PropertyMap)EndmemberFormModel.this.appContext.getPreferences());
            for (Endmember endmember : endmembers = this.convertGraphsToEndmembers(diagramGraphs)) {
                EndmemberFormModel.this.addEndmember(endmember);
            }
        }

        private Endmember[] convertGraphsToEndmembers(DiagramGraph[] diagramGraphs) {
            Endmember[] endmembers = new Endmember[diagramGraphs.length];
            for (int i = 0; i < diagramGraphs.length; ++i) {
                DiagramGraph diagramGraph = diagramGraphs[i];
                int numValues = diagramGraph.getNumValues();
                double[] wavelengths = new double[numValues];
                double[] radiations = new double[numValues];
                for (int j = 0; j < numValues; ++j) {
                    wavelengths[j] = diagramGraph.getXValueAt(j);
                    radiations[j] = diagramGraph.getYValueAt(j);
                }
                endmembers[i] = new Endmember(diagramGraph.getYName(), wavelengths, radiations);
            }
            return endmembers;
        }
    }
}

